/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.jcr.workspace;

import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.gcube.common.core.utils.logging.GCUBEClientLog;
import org.gcube.contentmanagement.contentmanager.stubs.model.protocol.URIs;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderBulkCreator;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.QueryType;
import org.gcube.portlets.user.homelibrary.jcr.importing.ImportContentManagerItemRequest;
import org.gcube.portlets.user.homelibrary.jcr.importing.ImportQueryRequest;
import org.gcube.portlets.user.homelibrary.jcr.importing.ImportRequest;
import org.gcube.portlets.user.homelibrary.jcr.importing.ImportUrlRequest;
import org.gcube.portlets.user.homelibrary.jcr.importing.JCRWorkspaceFolderItemImporter;
import org.gcube.portlets.user.homelibrary.jcr.repository.JCRRepository;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRFolderBulkCreatorManager;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspaceFolder;

public class JCRFolderBulkCreator
implements FolderBulkCreator {
    private static final String NT_FOLDER_BULK_CREATOR = "nthl:folderBulkCreator";
    private static final String FOLDER_ID = "hl:folderId";
    private static final String STATUS = "hl:status";
    private static final String FAILURES = "hl:failures";
    private static final String REQUESTS = "hl:requests";
    private String id;
    private String nodeId;
    private JCRWorkspaceFolder folder;
    private JCRFolderBulkCreatorManager manager;
    private List<ImportRequest> requests = new LinkedList<ImportRequest>();
    private boolean commited = false;
    private GCUBEClientLog logger = new GCUBEClientLog((Object)this, new Properties[0]);
    private final JCRWorkspace workspace;

    public JCRFolderBulkCreator(JCRWorkspace workspace, Node node, JCRFolderBulkCreatorManager manager) throws RepositoryException, InternalErrorException {
        this.workspace = workspace;
        this.manager = manager;
        this.commited = true;
        this.id = node.getName();
        this.nodeId = node.getIdentifier();
        try {
            this.folder = (JCRWorkspaceFolder)workspace.getItem(node.getSession(), node.getProperty(FOLDER_ID).getString());
        }
        catch (ItemNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public JCRFolderBulkCreator(String id, JCRWorkspaceFolder folder, JCRFolderBulkCreatorManager manager) throws InternalErrorException {
        this.workspace = folder.getWorkspace();
        this.commited = false;
        this.id = id;
        this.folder = folder;
        this.manager = manager;
    }

    public String getId() {
        return this.id;
    }

    public void createMetadata(URI uri) throws InsufficientPrivilegesException, InternalErrorException {
        if (this.commited) {
            throw new InternalErrorException("FolderBulkCreator already active");
        }
        if (uri == null) {
            throw new IllegalArgumentException("Uri are null");
        }
        try {
            URIs.validate((URI)uri);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid URI", e);
        }
        this.requests.add(ImportContentManagerItemRequest.metadataRequest(uri));
    }

    public void createAnnotation(URI uri) throws InsufficientPrivilegesException, InternalErrorException {
        if (this.commited) {
            throw new InternalErrorException("FolderBulkCreator already active");
        }
        if (uri == null) {
            throw new IllegalArgumentException("Uri are null");
        }
        try {
            URIs.validate((URI)uri);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid URI", e);
        }
        this.requests.add(ImportContentManagerItemRequest.annotationRequest(uri));
    }

    public void createDocumentPartItem(URI uri) throws InsufficientPrivilegesException, InternalErrorException {
    }

    public void createDocumentAlternativeItem(URI uri) throws InsufficientPrivilegesException, InternalErrorException {
        if (this.commited) {
            throw new InternalErrorException("FolderBulkCreator already active");
        }
        if (uri == null) {
            throw new IllegalArgumentException("Uri are null");
        }
        this.requests.add(ImportContentManagerItemRequest.alternativeRequest(uri));
    }

    public void createDocumentItem(URI uri) throws InsufficientPrivilegesException, InternalErrorException {
        if (this.commited) {
            throw new InternalErrorException("FolderBulkCreator already active");
        }
        if (uri == null) {
            throw new IllegalArgumentException("Uri are null");
        }
        try {
            URIs.validate((URI)uri);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid URI", e);
        }
        this.requests.add(ImportContentManagerItemRequest.documentRequest(uri));
    }

    public void createExternalUrl(String url) throws InternalErrorException {
        if (this.commited) {
            throw new InternalErrorException("FolderBulkCreator already active");
        }
        if (url == null) {
            throw new IllegalArgumentException("The url can't be null.");
        }
        this.requests.add(new ImportUrlRequest(url));
    }

    public void createQuery(String name, String query, QueryType queryType) throws InternalErrorException {
        if (this.commited) {
            throw new InternalErrorException("FolderBulkCreator already active");
        }
        if (name == null || query == null || queryType == null) {
            throw new IllegalArgumentException("name, query or queryType null");
        }
        this.requests.add(new ImportQueryRequest(name, query, queryType));
    }

    private void saveFolderBulkCreator() throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            Node rootCreator = this.workspace.getRepository().getRootFolderBulkCreators(session);
            Node node = rootCreator.addNode(this.id, NT_FOLDER_BULK_CREATOR);
            node.setProperty(FOLDER_ID, this.folder.getId());
            node.setProperty(REQUESTS, (long)this.requests.size());
            session.save();
            this.nodeId = node.getIdentifier();
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public void commit() throws InternalErrorException {
        this.logger.debug((Object)"Request commited");
        if (this.commited) {
            throw new IllegalStateException("This FolderBulkCreator has already commited");
        }
        this.commited = true;
        if (this.requests.size() == 0) {
            this.logger.debug((Object)"No request was submitted");
            return;
        }
        JCRWorkspaceFolderItemImporter folderItemImporter = new JCRWorkspaceFolderItemImporter(this.manager, this.getId(), this.requests, this.folder);
        Thread fiiThread = new Thread((Runnable)folderItemImporter, "FolderItemImporter");
        this.manager.addFolderBulkCreator(this, fiiThread);
        this.saveFolderBulkCreator();
        this.logger.debug((Object)"Start importer");
        fiiThread.start();
    }

    public WorkspaceFolder getDestinationFolder() {
        return this.folder;
    }

    public int getNumberOfRequests() throws InternalErrorException {
        if (this.nodeId == null) {
            return this.requests.size();
        }
        Session session = JCRRepository.getSession();
        try {
            Node node = session.getNodeByIdentifier(this.nodeId);
            int n = (int)node.getProperty(REQUESTS).getLong();
            return n;
        }
        catch (Exception e) {
            this.logger.error((Object)"getStatus error ", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public float getStatus() throws InternalErrorException {
        if (this.nodeId == null) {
            return 0.0f;
        }
        Session session = JCRRepository.getSession();
        try {
            Node node = session.getNodeByIdentifier(this.nodeId);
            long successes = node.getProperty(STATUS).getLong();
            long failures = node.getProperty(FAILURES).getLong();
            float f = (float)(successes + failures) / (float)node.getProperty(REQUESTS).getLong();
            return f;
        }
        catch (Exception e) {
            this.logger.error((Object)"getStatus error ", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public int getFailures() throws InternalErrorException {
        if (this.nodeId == null) {
            return 0;
        }
        Session session = JCRRepository.getSession();
        try {
            Node node = session.getNodeByIdentifier(this.nodeId);
            int n = (int)node.getProperty(FAILURES).getLong();
            return n;
        }
        catch (Exception e) {
            this.logger.error((Object)"getStatus error ", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public void remove() throws InternalErrorException {
        this.manager.removeThread(this.id);
        if (this.nodeId == null) {
            return;
        }
        Session session = JCRRepository.getSession();
        try {
            Node node = session.getNodeByIdentifier(this.nodeId);
            node.remove();
            session.save();
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }
}

