/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items;

import ij.ImagePlus;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.Image;
import org.gcube.portlets.user.homelibrary.jcr.content.JCRRepository;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRFile;
import org.gcube.portlets.user.homelibrary.jcr.workspace.util.WorkspaceItemUtil;

public class JCRImage
extends JCRFile
implements Image {
    private static final String IMAGE_WIDTH = "hl:width";
    private static final String IMAGE_HEIGHT = "hl:height";
    private static final String THUMBNAIL_DATA = "hl:thumbnailData";
    private static final String THUMBNAIL_WIDTH = "hl:thumbnailWidth";
    private static final String THUMBNAIL_HEIGHT = "hl:thumbnailHeight";

    public JCRImage(Node node) throws RepositoryException {
        super(node);
    }

    public JCRImage(Node node, InputStream data) throws RepositoryException, IOException {
        super(node, new BufferedInputStream(data));
        InputStream dataImage = node.getProperty("jcr:data").getBinary().getStream();
        ImagePlus imagePlus = WorkspaceItemUtil.getImgePlus(dataImage);
        int width = imagePlus.getWidth();
        int height = imagePlus.getHeight();
        int[] thumbnailSize = WorkspaceItemUtil.getThumbnailDimension(width, height);
        InputStream thumbnailStream = WorkspaceItemUtil.getThumbnailAsPng(imagePlus, thumbnailSize);
        Binary binary = node.getSession().getValueFactory().createBinary(thumbnailStream);
        node.setProperty(IMAGE_WIDTH, (long)width);
        node.setProperty(IMAGE_HEIGHT, (long)height);
        node.setProperty(THUMBNAIL_WIDTH, (long)thumbnailSize[0]);
        node.setProperty(THUMBNAIL_HEIGHT, (long)thumbnailSize[1]);
        node.setProperty(THUMBNAIL_DATA, binary);
        thumbnailStream.close();
        imagePlus.close();
        dataImage.close();
    }

    public int getWidth() {
        Session session = null;
        try {
            session = JCRRepository.getSession();
            Node node = session.getNodeByIdentifier(this.nodeId);
            int n = (int)node.getProperty(IMAGE_WIDTH).getLong();
            return n;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            session.logout();
        }
    }

    public int getHeight() {
        Session session = null;
        try {
            session = JCRRepository.getSession();
            Node node = session.getNodeByIdentifier(this.nodeId);
            int n = (int)node.getProperty(IMAGE_HEIGHT).getLong();
            return n;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            session.logout();
        }
    }

    public InputStream getThumbnail() throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            Node node = session.getNodeByIdentifier(this.nodeId);
            InputStream inputStream = node.getProperty(THUMBNAIL_DATA).getBinary().getStream();
            return inputStream;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public int getThumbnailWidth() {
        Session session = null;
        try {
            session = JCRRepository.getSession();
            Node node = session.getNodeByIdentifier(this.nodeId);
            int n = (int)node.getProperty(THUMBNAIL_WIDTH).getLong();
            return n;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            session.logout();
        }
    }

    public int getThumbnailHeight() {
        Session session = null;
        try {
            session = JCRRepository.getSession();
            Node node = session.getNodeByIdentifier(this.nodeId);
            int n = (int)node.getProperty(THUMBNAIL_HEIGHT).getLong();
            return n;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            session.logout();
        }
    }

    public long getThumbnailLength() throws InternalErrorException {
        Session session = null;
        try {
            session = JCRRepository.getSession();
            Node node = session.getNodeByIdentifier(this.nodeId);
            long l = node.getProperty(THUMBNAIL_DATA).getBinary().getSize();
            return l;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            session.logout();
        }
    }
}

