/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.jcr.workspace;

import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.commons.lang.Validate;
import org.apache.jackrabbit.util.Text;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBEClientLog;
import org.gcube.portlets.user.homelibrary.home.Home;
import org.gcube.portlets.user.homelibrary.home.User;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.Workspace;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceSmartFolder;
import org.gcube.portlets.user.homelibrary.home.workspace.acl.Capabilities;
import org.gcube.portlets.user.homelibrary.home.workspace.events.AbstractWorkspaceEventSource;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WrongDestinationException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WrongItemTypeException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WrongParentTypeException;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderBulkCreator;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderBulkCreatorManager;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItemType;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ExternalFile;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ExternalImage;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ExternalPDFFile;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ExternalResourceLink;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ExternalUrl;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.QueryType;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.Report;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ReportTemplate;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.WorkflowReport;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.WorkflowTemplate;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.Annotation;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.Document;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.ImageDocument;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.Metadata;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.PDFDocument;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.UrlDocument;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.link.DocumentLink;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.link.ImageDocumentLink;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.link.PDFDocumentLink;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ts.TimeSeries;
import org.gcube.portlets.user.homelibrary.home.workspace.search.SearchFolderItem;
import org.gcube.portlets.user.homelibrary.home.workspace.search.SearchItem;
import org.gcube.portlets.user.homelibrary.home.workspace.sharing.WorkspaceMessageManager;
import org.gcube.portlets.user.homelibrary.jcr.content.JCRRepository;
import org.gcube.portlets.user.homelibrary.jcr.home.JCRHome;
import org.gcube.portlets.user.homelibrary.jcr.sharing.JCRWorkspaceMessageManager;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRFolderBulkCreatorManager;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspaceFolder;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspaceItem;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspaceSmartFolder;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.ContentType;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRAquaMapsItem;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRExternalFile;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRExternalImage;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRExternalPDFFile;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRExternalUrl;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRFile;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRImage;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRPDFFile;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRQuery;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRReport;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRReportTemplate;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRTimeSeries;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRWorkflowReport;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRWorkflowTemplate;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.gcube.JCRAnnotation;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.gcube.JCRDocument;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.gcube.JCRExternalResourceLink;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.gcube.JCRImageDocument;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.gcube.JCRMetadata;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.gcube.JCRPDFDocument;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.gcube.JCRUrlDocument;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.gcube.link.JCRDocumentLink;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.gcube.link.JCRImageDocumentLink;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.gcube.link.JCRPDFDocumentLink;
import org.gcube.portlets.user.homelibrary.jcr.workspace.search.JCRSearchFolder;
import org.gcube.portlets.user.homelibrary.jcr.workspace.search.JCRSearchFolderItem;
import org.gcube.portlets.user.homelibrary.util.Util;
import org.gcube.portlets.user.homelibrary.util.WorkspaceUtil;

public class JCRWorkspace
extends AbstractWorkspaceEventSource
implements Workspace {
    private static final String WORKSPACE_ROOT_FOLDER = "Workspace";
    private static final String NT_WORKSPACE_FOLDER = "nthl:workspaceItem";
    private static final String NT_WORKSPACE_FOLDER_ITEM = "nthl:workspaceLeafItem";
    private static final String NT_WORKSPACE_FILE = "nthl:externalFile";
    private static final String NT_WORKSPACE_IMAGE = "nthl:externalImage";
    private static final String NT_WORKSPACE_PDF_FILE = "nthl:externalPdf";
    private static final String NT_WORKSPACE_URL = "nthl:externalUrl";
    private static final String NT_WORKSPACE_REPORT = "nthl:report";
    private static final String NT_WORKSPACE_REPORT_TEMPLATE = "nthl:reportTemplate";
    private static final String NT_WORKSPACE_WORKFLOW_REPORT = "nthl:workflowReport";
    private static final String NT_WORKSPACE_WORKFLOW_TEMPLATE = "nthl:workflowTemplate";
    private static final String NT_ANNOTATION_ITEM = "nthl:gCubeAnnotation";
    private static final String NT_ANNOTATION_LINK_ITEM = "nthl:gCubeAnnotationLink";
    private static final String NT_DOCUMENT_ITEM = "nthl:gCubeDocument";
    private static final String NT_DOCUMENT_LINK_ITEM = "nthl:gCubeDocumentLink";
    private static final String NT_IMAGE_DOCUMENT_ITEM = "nthl:gCubeImageDocument";
    private static final String NT_IMAGE_DOCUMENT_LINK_ITEM = "nthl:gCubeImageDocumentLink";
    private static final String NT_PDF_DOCUMENT_ITEM = "nthl:gCubePDFDocument";
    private static final String NT_PDF_DOCUMENT_LINK_ITEM = "nthl:gCubePDFDocumentLink";
    private static final String NT_URL_DOCUMENT_ITEM = "nthl:gCubeURLDocument";
    private static final String NT_METADATA_ITEM = "nthl:gCubeMetadata";
    private static final String NT_METADATA_LINK_ITEM = "nthl:gCubeMetadataLink";
    private static final String NT_AQUAMAPS_ITEM = "nthl:aquamapsItem";
    private static final String NT_TIMESERIES_ITEM = "nthl:timeSeriesItem";
    private static final String NT_QUERY = "nthl:query";
    private static final String NT_EXTERNAL_RESOURCE_LINK_ITEM = "nthl:externalResourceLink";
    private static final String NT_FILE = "nt:file";
    private static final String CONTENT = "jcr:content";
    private String scope;
    private final Home home;
    private final JCRRepository repository;
    private final JCRFolderBulkCreatorManager folderBulkCreatorsManager;
    private JCRWorkspaceFolder root;
    private JCRWorkspaceMessageManager sendRequestManager;
    private GCUBEClientLog logger;

    public JCRWorkspace(Home home, JCRRepository repository) throws InternalErrorException {
        this.scope = null;
        this.home = home;
        this.repository = repository;
        this.folderBulkCreatorsManager = new JCRFolderBulkCreatorManager(this);
        this.logger = new GCUBEClientLog((Object)this, new Properties[0]);
        Session session = JCRRepository.getSession();
        String pathRoot = null;
        try {
            Node userHome = repository.getUserHome(session);
            Node node = null;
            try {
                node = userHome.addNode(WORKSPACE_ROOT_FOLDER, NT_WORKSPACE_FOLDER);
                this.root = new JCRWorkspaceFolder(this, node, WORKSPACE_ROOT_FOLDER, "The root");
                this.root.save(node);
            }
            catch (ItemExistsException e) {
                node = userHome.getNode(WORKSPACE_ROOT_FOLDER);
                this.root = new JCRWorkspaceFolder(this, node);
            }
            pathRoot = node.getPath();
        }
        catch (RepositoryException e) {
            this.logger.error((Object)"Root WorkspaceFolder failed creation", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        JCRRepository.setACL(home.getOwner().getPortalLogin(), pathRoot);
    }

    public JCRWorkspace(JCRHome home) {
        this.home = home;
        this.repository = null;
        this.folderBulkCreatorsManager = null;
    }

    private Node addChildNode(Session session, String parentId, String nodeName, String nodeType) throws ItemAlreadyExistException, WorkspaceFolderNotFoundException, InternalErrorException, WrongDestinationException {
        Node parent;
        Validate.notNull((Object)parentId, (String)"Destination folder must be not null");
        Validate.notNull((Object)nodeName, (String)"Name must be not null");
        if (!this.isValidName(nodeName)) {
            this.logger.error((Object)("The name  " + nodeName + "contains illegal chars or is empty"));
            throw new IllegalArgumentException("The name contains illegal chars or is empty");
        }
        try {
            parent = session.getNodeByIdentifier(parentId);
            if (!parent.getPrimaryNodeType().getName().equals(NT_WORKSPACE_FOLDER)) {
                throw new WrongDestinationException("Not is a folder");
            }
        }
        catch (RepositoryException e) {
            this.logger.error((Object)"Destination folder not found");
            throw new WorkspaceFolderNotFoundException(e.getMessage());
        }
        try {
            return parent.addNode(Text.escapeIllegalJcrChars((String)nodeName), nodeType);
        }
        catch (ItemExistsException e) {
            this.logger.error((Object)"Item already exist");
            throw new ItemAlreadyExistException(e.getMessage());
        }
        catch (RepositoryException e) {
            this.logger.fatal((Object)e);
            throw new InternalErrorException((Throwable)e);
        }
    }

    public String getPathSeparator() {
        return "/";
    }

    public Home getHome() {
        return this.home;
    }

    public JCRRepository getRepository() {
        return this.repository;
    }

    public User getOwner() {
        return this.home.getOwner();
    }

    public WorkspaceFolder getRoot() {
        return this.getRoot(null);
    }

    public WorkspaceFolder getRoot(GCUBEScope scope) {
        this.scope = scope == null ? null : scope.toString();
        return this.root;
    }

    public WorkspaceFolder createFolder(String name, String description, String destinationFolderId) throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, WrongDestinationException, org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException, WorkspaceFolderNotFoundException {
        this.logger.trace((Object)"Create workspace folder");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_WORKSPACE_FOLDER);
            JCRWorkspaceFolder folder = new JCRWorkspaceFolder(this, node, name, description);
            folder.save(node);
            this.fireItemCreatedEvent(folder);
            JCRWorkspaceFolder jCRWorkspaceFolder = folder;
            return jCRWorkspaceFolder;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public ExternalImage createExternalImage(String name, String description, String mimeType, InputStream imageData, String destinationFolderId) throws InsufficientPrivilegesException, WorkspaceFolderNotFoundException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException {
        this.logger.trace((Object)"Create external image");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_WORKSPACE_IMAGE);
            JCRExternalImage image = new JCRExternalImage(this, node, name, description, mimeType, imageData);
            image.save(node);
            this.fireItemCreatedEvent(image);
            JCRExternalImage jCRExternalImage = image;
            return jCRExternalImage;
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public ExternalFile createExternalFile(String name, String description, String mimeType, InputStream fileData, String destinationFolderId) throws InsufficientPrivilegesException, WorkspaceFolderNotFoundException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException {
        this.logger.trace((Object)"Create external file");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_WORKSPACE_FILE);
            JCRExternalFile file = new JCRExternalFile(this, node, name, description, mimeType, fileData);
            file.save(node);
            this.fireItemCreatedEvent(file);
            JCRExternalFile jCRExternalFile = file;
            return jCRExternalFile;
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public ExternalPDFFile createExternalPDFFile(String name, String description, String mimeType, InputStream fileData, String destinationFolderId) throws InsufficientPrivilegesException, WorkspaceFolderNotFoundException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException {
        this.logger.trace((Object)"Create external pdf file");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_WORKSPACE_PDF_FILE);
            JCRExternalPDFFile file = new JCRExternalPDFFile(this, node, name, description, mimeType, fileData);
            file.save(node);
            this.fireItemCreatedEvent(file);
            JCRExternalPDFFile jCRExternalPDFFile = file;
            return jCRExternalPDFFile;
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public ExternalUrl createExternalUrl(String name, String description, String url, String destinationFolderId) throws InsufficientPrivilegesException, WorkspaceFolderNotFoundException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException {
        this.logger.trace((Object)"Create external url");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_WORKSPACE_URL);
            JCRExternalUrl externalUrl = new JCRExternalUrl(this, node, name, description, url);
            externalUrl.save(node);
            this.fireItemCreatedEvent(externalUrl);
            JCRExternalUrl jCRExternalUrl = externalUrl;
            return jCRExternalUrl;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public ExternalUrl createExternalUrl(String name, String description, InputStream url, String destinationFolderId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException, WorkspaceFolderNotFoundException {
        String urlString;
        try {
            urlString = Util.readStreamAsString((InputStream)url);
        }
        catch (IOException e) {
            throw new InternalErrorException("Error converting url from input stream to string.");
        }
        return this.createExternalUrl(name, description, urlString, destinationFolderId);
    }

    public ReportTemplate createReportTemplate(String name, String description, Calendar created, Calendar lastEdit, String author, String lastEditBy, int numberOfSections, String status, InputStream templateData, String destinationfolderId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException, WorkspaceFolderNotFoundException {
        this.logger.trace((Object)"Created report template");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationfolderId, name, NT_WORKSPACE_REPORT_TEMPLATE);
            JCRReportTemplate reportTemplate = new JCRReportTemplate(this, node, name, description, created, lastEdit, author, lastEditBy, numberOfSections, status, templateData);
            reportTemplate.save(node);
            this.fireItemCreatedEvent(reportTemplate);
            JCRReportTemplate jCRReportTemplate = reportTemplate;
            return jCRReportTemplate;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public Report createReport(String name, String description, Calendar created, Calendar lastEdit, String author, String lastEditBy, String templateName, int numberOfSections, String status, InputStream reportData, String destinationfolderId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException, WorkspaceFolderNotFoundException {
        this.logger.trace((Object)"Create report");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationfolderId, name, NT_WORKSPACE_REPORT);
            JCRReport report = new JCRReport(this, node, name, description, created, lastEdit, author, lastEditBy, templateName, numberOfSections, status, reportData);
            report.save(node);
            this.fireItemCreatedEvent(report);
            JCRReport jCRReport = report;
            return jCRReport;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public org.gcube.portlets.user.homelibrary.home.workspace.folder.items.Query createQuery(String name, String description, String query, QueryType queryType, String destinationFolderId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException, WorkspaceFolderNotFoundException {
        this.logger.trace((Object)"Create query");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_QUERY);
            JCRQuery jcrQuery = new JCRQuery(this, node, name, description, query, queryType);
            jcrQuery.save(node);
            this.fireItemCreatedEvent(jcrQuery);
            JCRQuery jCRQuery = jcrQuery;
            return jCRQuery;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public org.gcube.portlets.user.homelibrary.home.workspace.folder.items.Query createQuery(String name, String description, InputStream query, QueryType queryType, String destinationFolderId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException, WorkspaceFolderNotFoundException {
        try {
            return this.createQuery(name, description, Util.readStreamAsString((InputStream)query), queryType, destinationFolderId);
        }
        catch (IOException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public WorkspaceFolder createAquaMapsItem(String name, String description, String mapName, String mapType, String author, int numberOfSpecies, String boundingBox, float psoThreshold, int numberOfGeneratedImages, InputStream metadata, Map<String, InputStream> images, String destinationFolderId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException, WorkspaceFolderNotFoundException {
        JCRWorkspaceFolder folder;
        this.logger.trace((Object)"Create aquamaps item");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_WORKSPACE_FOLDER);
            folder = new JCRWorkspaceFolder(this, node, name, description);
            folder.save(node);
            String fileName = WorkspaceUtil.getUniqueName((String)"metadata.xml", (WorkspaceFolder)folder);
            Node nodeFile = this.addChildNode(session, node.getIdentifier(), fileName, NT_WORKSPACE_FILE);
            JCRExternalFile file = new JCRExternalFile(this, nodeFile, fileName, name + " metadata", "text/xml", metadata);
            file.save(nodeFile);
            this.fireItemCreatedEvent(file);
            for (Map.Entry<String, InputStream> entry : images.entrySet()) {
                String imageName = Text.escapeIllegalJcrChars((String)entry.getKey());
                Node imageNode = this.addChildNode(session, node.getIdentifier(), imageName, NT_WORKSPACE_IMAGE);
                JCRExternalImage image = new JCRExternalImage(this, imageNode, imageName, description, "", entry.getValue());
                image.save(imageNode);
                this.fireItemCreatedEvent(image);
            }
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
        return folder;
    }

    public Annotation createAnnotation(String name, String description, String oid, Map<String, String> data, String destinationFolderId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WorkspaceFolderNotFoundException {
        this.logger.trace((Object)"Create annotation item");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_ANNOTATION_ITEM);
            JCRAnnotation annotation = new JCRAnnotation(this, node, name, description, oid, data);
            annotation.save(node);
            this.fireItemCreatedEvent(annotation);
            JCRAnnotation jCRAnnotation = annotation;
            return jCRAnnotation;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public Metadata createMetadata(String name, String description, String oid, String schema, String language, String data, String collectionName, String destinationFolderId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException, WorkspaceFolderNotFoundException {
        this.logger.trace((Object)"Create metadata item");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_METADATA_ITEM);
            JCRMetadata item = new JCRMetadata(this, node, name, description, oid, schema, language, collectionName, data);
            item.save(node);
            this.fireItemCreatedEvent(item);
            JCRMetadata jCRMetadata = item;
            return jCRMetadata;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public Document createDocument(String name, String description, String oid, String mimeType, InputStream documentData, Map<String, String> metadata, Map<String, String> annotations, String collectionName, String destinationFolderId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException, WorkspaceFolderNotFoundException {
        this.logger.trace((Object)"Create document item");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_DOCUMENT_ITEM);
            JCRDocument item = new JCRDocument(this, node, name, description, oid, mimeType, documentData, metadata, annotations, collectionName);
            item.save(node);
            this.fireItemCreatedEvent(item);
            JCRDocument jCRDocument = item;
            return jCRDocument;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public ImageDocument createImageDocument(String name, String description, String oid, String mimeType, InputStream imageData, Map<String, String> metadata, Map<String, String> annotations, String collectionName, String destinationFolderId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException, WorkspaceFolderNotFoundException {
        this.logger.trace((Object)"Create image document item");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_IMAGE_DOCUMENT_ITEM);
            JCRImageDocument item = new JCRImageDocument(this, node, name, description, oid, mimeType, imageData, metadata, annotations, collectionName);
            item.save(node);
            this.fireItemCreatedEvent(item);
            JCRImageDocument jCRImageDocument = item;
            return jCRImageDocument;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public PDFDocument createPDFDocument(String name, String description, String oid, String mimeType, InputStream data, Map<String, String> metadata, Map<String, String> annotations, String collectionName, String destinationFolderId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException, WorkspaceFolderNotFoundException {
        this.logger.trace((Object)"Create pdf document item");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_PDF_DOCUMENT_ITEM);
            JCRPDFDocument item = new JCRPDFDocument(this, node, name, description, oid, mimeType, data, metadata, annotations, collectionName);
            item.save(node);
            this.fireItemCreatedEvent(item);
            JCRPDFDocument jCRPDFDocument = item;
            return jCRPDFDocument;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public UrlDocument createUrlDocument(String name, String description, String oid, String mimeType, InputStream documentData, Map<String, String> metadata, Map<String, String> annotations, String collectionName, String destinationFolderId) throws InsufficientPrivilegesException, WorkspaceFolderNotFoundException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException {
        this.logger.trace((Object)"Create url document item");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_URL_DOCUMENT_ITEM);
            JCRUrlDocument item = new JCRUrlDocument(this, node, name, description, oid, mimeType, documentData, metadata, annotations, collectionName);
            item.save(node);
            this.fireItemCreatedEvent(item);
            JCRUrlDocument jCRUrlDocument = item;
            return jCRUrlDocument;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public DocumentLink createDocumentLink(String name, String description, String oid, Map<String, String> metadata, Map<String, String> annotations, String collectionName, String mimeType, String destinationFolderId) throws InsufficientPrivilegesException, WorkspaceFolderNotFoundException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException {
        this.logger.trace((Object)"Create document link item");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_DOCUMENT_LINK_ITEM);
            JCRDocumentLink item = new JCRDocumentLink(this, node, name, description, oid, mimeType, metadata, annotations, collectionName);
            item.save(node);
            this.fireItemCreatedEvent(item);
            JCRDocumentLink jCRDocumentLink = item;
            return jCRDocumentLink;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public ImageDocumentLink createImageDocumentLink(String name, String description, String oid, Map<String, String> metadata, Map<String, String> annotations, String collectionName, String mimeType, String destinationFolderId) throws InsufficientPrivilegesException, WorkspaceFolderNotFoundException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException {
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_IMAGE_DOCUMENT_LINK_ITEM);
            JCRImageDocumentLink item = new JCRImageDocumentLink(this, node, name, description, oid, mimeType, metadata, annotations, collectionName);
            item.save(node);
            this.fireItemCreatedEvent(item);
            JCRImageDocumentLink jCRImageDocumentLink = item;
            return jCRImageDocumentLink;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public PDFDocumentLink createPDFDocumentLink(String name, String description, String oid, Map<String, String> metadata, Map<String, String> annotations, String collectionName, String mimeType, String destinationFolderId) throws InsufficientPrivilegesException, WorkspaceFolderNotFoundException, InternalErrorException, ItemAlreadyExistException, WrongDestinationException {
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_PDF_DOCUMENT_LINK_ITEM);
            JCRPDFDocumentLink item = new JCRPDFDocumentLink(this, node, name, description, oid, mimeType, metadata, annotations, collectionName);
            item.save(node);
            this.fireItemCreatedEvent(item);
            JCRPDFDocumentLink jCRPDFDocumentLink = item;
            return jCRPDFDocumentLink;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public TimeSeries createTimeSeries(String name, String description, String timeseriesId, String title, String creator, String timeseriesDescription, String timeseriesCreationDate, String publisher, String sourceId, String sourceName, String rights, long dimension, List<String> headerLabels, InputStream compressedCSV, String destinationFolderId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WorkspaceFolderNotFoundException, WrongDestinationException {
        this.logger.trace((Object)"Create TimeSeries item");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_TIMESERIES_ITEM);
            JCRTimeSeries item = new JCRTimeSeries(this, node, name, description, timeseriesId, title, creator, timeseriesDescription, timeseriesCreationDate, publisher, sourceId, sourceName, rights, dimension, headerLabels, compressedCSV);
            item.save(node);
            this.fireItemCreatedEvent(item);
            JCRTimeSeries jCRTimeSeries = item;
            return jCRTimeSeries;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public WorkflowReport createWorkflowReport(String name, String description, String workflowId, String workflowStatus, String workflowData, String destinationFolderId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WorkspaceFolderNotFoundException, WrongDestinationException {
        this.logger.trace((Object)"Create WorkflowReport item");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_WORKSPACE_WORKFLOW_REPORT);
            JCRWorkflowReport workflowReport = new JCRWorkflowReport(this, node, name, description, workflowId, workflowStatus, workflowData);
            workflowReport.save(node);
            this.fireItemCreatedEvent(workflowReport);
            JCRWorkflowReport jCRWorkflowReport = workflowReport;
            return jCRWorkflowReport;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public WorkflowTemplate createWorkflowTemplate(String name, String description, String workflowId, String workflowStatus, String workflowData, String destinationFolderId) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WorkspaceFolderNotFoundException, WrongDestinationException {
        this.logger.trace((Object)"Create WorkflowTemplate item");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_WORKSPACE_WORKFLOW_TEMPLATE);
            JCRWorkflowTemplate workflowTemplate = new JCRWorkflowTemplate(this, node, name, description, workflowId, workflowStatus, workflowData);
            workflowTemplate.save(node);
            this.fireItemCreatedEvent(workflowTemplate);
            JCRWorkflowTemplate jCRWorkflowTemplate = workflowTemplate;
            return jCRWorkflowTemplate;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public ExternalResourceLink createExternalResourceLink(String name, String description, String mimeType, String resourceId, String pluginName, String destinationFolderId) throws WorkspaceFolderNotFoundException, WrongDestinationException, InternalErrorException, ItemAlreadyExistException, InsufficientPrivilegesException {
        this.logger.trace((Object)"Create service resource link");
        Session session = JCRRepository.getSession();
        try {
            Node node = this.addChildNode(session, destinationFolderId, name, NT_EXTERNAL_RESOURCE_LINK_ITEM);
            JCRExternalResourceLink item = new JCRExternalResourceLink(this, node, name, mimeType, description, resourceId, pluginName);
            item.save(node);
            this.fireItemCreatedEvent(item);
            JCRExternalResourceLink jCRExternalResourceLink = item;
            return jCRExternalResourceLink;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public void removeItem(String itemId) throws org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException, InternalErrorException, InsufficientPrivilegesException {
        Validate.notNull((Object)itemId, (String)"Item id must be not null");
        Session session = JCRRepository.getSession();
        try {
            Node node = session.getNodeByIdentifier(itemId);
            this.fireItemRemovedEvent(this.getWorkspaceItem(node));
            node.remove();
            session.save();
        }
        catch (RepositoryException e) {
            throw new org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException(e.getMessage());
        }
        finally {
            session.logout();
        }
    }

    public void moveItem(String itemId, String destinationFolderId) throws org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException, WrongDestinationException, InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, WorkspaceFolderNotFoundException {
        this.logger.debug((Object)("Move item with id " + itemId + "to destination with id " + destinationFolderId));
        Validate.notNull((Object)itemId, (String)"Item id must be not null");
        Validate.notNull((Object)destinationFolderId, (String)"Destination folder id must be not null");
        Session session = JCRRepository.getSession();
        try {
            Node nodeItem;
            Node nodeFolder;
            try {
                nodeFolder = session.getNodeByIdentifier(destinationFolderId);
                if (!nodeFolder.getPrimaryNodeType().getName().equals(NT_WORKSPACE_FOLDER)) {
                    this.logger.error((Object)"Destination is not a folder");
                    throw new WrongDestinationException("Destination is not a folder");
                }
            }
            catch (RepositoryException e) {
                this.logger.error((Object)"Destination not found");
                throw new WorkspaceFolderNotFoundException(e.getMessage());
            }
            try {
                nodeItem = session.getNodeByIdentifier(itemId);
            }
            catch (ItemNotFoundException e) {
                this.logger.error((Object)("Item with id " + itemId + " not found"));
                throw new org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException(e.getMessage());
            }
            catch (RepositoryException e) {
                this.logger.fatal((Object)("Fatal error retrieving item with id " + itemId));
                throw new InternalErrorException((Throwable)e);
            }
            try {
                this.getWorkspaceItem(nodeItem).internalMove(nodeFolder);
            }
            catch (RepositoryException e) {
                this.logger.fatal((Object)("Fatal error moving item with id " + itemId + " to WorkspaceFolder with id " + destinationFolderId));
                throw new InternalErrorException((Throwable)e);
            }
            session.save();
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public void renameItem(String itemId, String newName) throws org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException, InternalErrorException, ItemAlreadyExistException {
        Validate.notNull((Object)itemId, (String)"Item id must be not null");
        if (!this.isValidName(newName)) {
            throw new IllegalArgumentException("Invalid item name");
        }
        Session session = JCRRepository.getSession();
        try {
            Node nodeItem;
            try {
                nodeItem = session.getNodeByIdentifier(itemId);
            }
            catch (RepositoryException e) {
                throw new org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException(e.getMessage());
            }
            try {
                this.getWorkspaceItem(nodeItem).internalRename(nodeItem, newName);
            }
            catch (RepositoryException e) {
                throw new InternalErrorException((Throwable)e);
            }
            session.save();
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public void changeDescription(String itemId, String newDescription) throws org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException, InternalErrorException {
        Validate.notNull((Object)itemId, (String)"Item id must be not null");
        Session session = JCRRepository.getSession();
        try {
            Node nodeItem = session.getNodeByIdentifier(itemId);
            this.getWorkspaceItem(nodeItem).internalDescription(nodeItem, newDescription);
        }
        catch (RepositoryException e) {
            throw new org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException(e.getMessage());
        }
        finally {
            session.logout();
        }
    }

    public WorkspaceItem getItem(String itemId) throws org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException {
        Validate.notNull((Object)itemId, (String)"Item id must be not null");
        Session session = null;
        try {
            session = JCRRepository.getSession();
            WorkspaceItem workspaceItem = this.getItem(session, itemId);
            return workspaceItem;
        }
        catch (InternalErrorException e) {
            throw new org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException(e.getMessage());
        }
        catch (RepositoryException e) {
            throw new org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException(e.getMessage());
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    public WorkspaceItem getItem(Session session, String itemId) throws RepositoryException, InternalErrorException {
        Node nodeItem = session.getNodeByIdentifier(itemId);
        return this.getWorkspaceItem(nodeItem);
    }

    public Capabilities getCapabilities(String itemId) throws org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException, InternalErrorException {
        return null;
    }

    public void removeChild(String childId, String folderId) throws org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException, InternalErrorException, InsufficientPrivilegesException, WrongParentTypeException {
        Validate.notNull((Object)childId, (String)"Child Id must be not null");
        Validate.notNull((Object)folderId, (String)"Folder Id must be not null");
        Session session = JCRRepository.getSession();
        try {
            try {
                Node parent = session.getNodeByIdentifier(folderId);
                if (!parent.getPrimaryNodeType().getName().equals(NT_WORKSPACE_FOLDER)) {
                    throw new WrongParentTypeException("Folder id is not folder");
                }
            }
            catch (RepositoryException e) {
                throw new org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException("Folder is not present");
            }
            Node childNode = session.getNodeByIdentifier(childId);
            this.fireItemRemovedEvent(this.getWorkspaceItem(childNode));
            childNode.remove();
            session.save();
        }
        catch (RepositoryException e) {
            throw new org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException("Item is not present");
        }
        finally {
            session.logout();
        }
    }

    public void remove(String itemName, String folderId) throws org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException, InternalErrorException, InsufficientPrivilegesException, WrongItemTypeException {
        Session session = JCRRepository.getSession();
        try {
            Node nodeFolder = null;
            try {
                nodeFolder = session.getNodeByIdentifier(folderId);
            }
            catch (ItemNotFoundException e) {
                throw new org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException(e.getMessage());
            }
            catch (RepositoryException e) {
                throw new InternalErrorException((Throwable)e);
            }
            try {
                Node childNode = nodeFolder.getNode(Text.escapeIllegalJcrChars((String)itemName));
                this.fireItemRemovedEvent(this.getWorkspaceItem(childNode));
                childNode.remove();
            }
            catch (PathNotFoundException e) {
                throw new org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException(e.getMessage());
            }
            catch (RepositoryException e) {
                throw new InternalErrorException((Throwable)e);
            }
            session.save();
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public WorkspaceItem copy(String itemId, String newName, String destinationFolderId) throws org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException, WrongDestinationException, InternalErrorException, ItemAlreadyExistException, InsufficientPrivilegesException, WorkspaceFolderNotFoundException {
        Validate.notNull((Object)itemId, (String)"ItemId must be not null");
        Validate.notNull((Object)newName, (String)"NewName must be not null");
        Validate.notNull((Object)destinationFolderId, (String)"Destination Folder id must be not null");
        if (!this.isValidName(newName)) {
            this.logger.error((Object)"The name contains illegal chars or is empty");
            throw new IllegalArgumentException("The name contains illegal chars or is empty");
        }
        return this.internalCopy(itemId, newName, destinationFolderId);
    }

    public WorkspaceItem copy(String itemId, String destinationFolderId) throws org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException, WrongDestinationException, InternalErrorException, ItemAlreadyExistException, InsufficientPrivilegesException, WorkspaceFolderNotFoundException {
        Validate.notNull((Object)itemId, (String)"Item id must be not null");
        Validate.notNull((Object)destinationFolderId, (String)"destinationFolder id must be not null");
        return this.internalCopy(itemId, null, destinationFolderId);
    }

    private WorkspaceItem internalCopy(String itemId, String newName, String destinationFolderId) throws org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException, WrongDestinationException, WorkspaceFolderNotFoundException, ItemAlreadyExistException, InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            Node nodeItem = null;
            try {
                nodeItem = session.getNodeByIdentifier(itemId);
            }
            catch (RepositoryException e) {
                throw new org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException(e.getMessage());
            }
            Node nodeDestinationFolder = null;
            try {
                if (destinationFolderId == null) {
                    destinationFolderId = nodeItem.getParent().getIdentifier();
                }
                if (!(nodeDestinationFolder = session.getNodeByIdentifier(destinationFolderId)).getPrimaryNodeType().getName().equals(NT_WORKSPACE_FOLDER)) {
                    throw new WrongDestinationException("Destination is not a folder");
                }
            }
            catch (RepositoryException e) {
                throw new WorkspaceFolderNotFoundException(e.getMessage());
            }
            if (newName == null) {
                newName = nodeItem.getName();
            }
            Node newNode = this.getWorkspaceItem(nodeItem).internalCopy(nodeDestinationFolder, newName);
            session.save();
            JCRWorkspaceItem jCRWorkspaceItem = this.getWorkspaceItem(newNode);
            return jCRWorkspaceItem;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public WorkspaceItem cloneItem(String itemId, String cloneName) throws org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException, ItemAlreadyExistException, InsufficientPrivilegesException, InternalErrorException, WrongDestinationException, WorkspaceFolderNotFoundException {
        Validate.notNull((Object)itemId, (String)"itemId must be not null");
        if (!this.isValidName(cloneName)) {
            throw new IllegalArgumentException("cloneName is a not valid name");
        }
        return this.internalCopy(itemId, cloneName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String name, String folderId) throws InternalErrorException, org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException, WrongItemTypeException {
        Validate.notNull((Object)name, (String)"Name must be not null");
        Validate.notNull((Object)folderId, (String)"Name must be not null");
        Session session = JCRRepository.getSession();
        try {
            Node folderNode;
            try {
                folderNode = session.getNodeByIdentifier(folderId);
            }
            catch (RepositoryException e) {
                throw new org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException(e.getMessage());
            }
            if (!this.isValidName(name)) {
                boolean e = false;
                return e;
            }
            try {
                folderNode.getNode(Text.escapeIllegalJcrChars((String)name));
            }
            catch (RepositoryException e) {
                this.logger.debug((Object)"Item not exists");
                boolean bl = false;
                session.logout();
                return bl;
            }
            this.logger.debug((Object)"Item exists");
            boolean bl = true;
            return bl;
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String itemId) throws InternalErrorException {
        Validate.notNull((Object)itemId, (String)"Item id must be not null");
        Session session = JCRRepository.getSession();
        try {
            try {
                session.getNodeByIdentifier(itemId);
            }
            catch (RepositoryException e) {
                boolean bl = false;
                session.logout();
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            session.logout();
        }
    }

    public WorkspaceItem find(String name, String folderId) throws InternalErrorException, org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException, WrongItemTypeException {
        Session session = JCRRepository.getSession();
        try {
            Node nodeFolder = session.getNodeByIdentifier(folderId);
            Node node = nodeFolder.getNode(Text.escapeIllegalJcrChars((String)name));
            JCRWorkspaceItem jCRWorkspaceItem = this.getWorkspaceItem(node);
            return jCRWorkspaceItem;
        }
        catch (ItemNotFoundException e) {
            throw new org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException(e.getMessage());
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public WorkspaceItem find(String path) throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            String[] strings = path.split("/");
            String pathCleaned = "";
            for (String string : strings) {
                pathCleaned = pathCleaned + "/" + Text.escapeIllegalJcrChars((String)string);
            }
            Node rootNode = session.getNodeByIdentifier(this.root.getId());
            Node node = session.getNode(rootNode.getPath() + pathCleaned);
            JCRWorkspaceItem jCRWorkspaceItem = this.getWorkspaceItem(node);
            return jCRWorkspaceItem;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public boolean isValidName(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        return !name.contains("/");
    }

    public FolderBulkCreator getNewFolderBulkCreator(String folderId) throws WorkspaceFolderNotFoundException, WrongItemTypeException, InternalErrorException {
        Validate.notNull((Object)folderId, (String)"Folder id must be not null");
        Session session = JCRRepository.getSession();
        try {
            Node folderNode;
            try {
                folderNode = session.getNodeByIdentifier(folderId);
            }
            catch (RepositoryException e) {
                throw new WorkspaceFolderNotFoundException(e.getMessage());
            }
            try {
                if (!folderNode.getPrimaryNodeType().getName().equals(NT_WORKSPACE_FOLDER)) {
                    throw new WrongItemTypeException("A FolderBulkCreator can be created  only for a folder");
                }
            }
            catch (RepositoryException e) {
                throw new InternalErrorException((Throwable)e);
            }
            JCRWorkspaceFolder folder = new JCRWorkspaceFolder(this, folderNode);
            FolderBulkCreator folderBulkCreator = this.folderBulkCreatorsManager.getFolderBulk(folder);
            return folderBulkCreator;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public FolderBulkCreatorManager getFolderBulkCreatorManager() {
        return this.folderBulkCreatorsManager;
    }

    public WorkspaceMessageManager getWorkspaceMessageManager() {
        if (this.sendRequestManager == null) {
            this.sendRequestManager = new JCRWorkspaceMessageManager(this);
        }
        return this.sendRequestManager;
    }

    public WorkspaceFolder decomposeAquaMapsItem(String itemId, String folderName, String destinationWorkspaceId) throws WrongItemTypeException, WorkspaceFolderNotFoundException, WrongDestinationException, InternalErrorException, ItemAlreadyExistException, InsufficientPrivilegesException, org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException {
        return null;
    }

    public JCRWorkspaceItem getWorkspaceItem(Node node) throws RepositoryException, InternalErrorException {
        if (node.getPrimaryNodeType().getName().equals(NT_WORKSPACE_FOLDER)) {
            return new JCRWorkspaceFolder(this, node);
        }
        if (node.getPrimaryNodeType().getName().equals(NT_WORKSPACE_FILE)) {
            JCRExternalFile item = new JCRExternalFile(this, node);
            return item;
        }
        if (node.getPrimaryNodeType().getName().equals(NT_WORKSPACE_IMAGE)) {
            JCRExternalImage item = new JCRExternalImage(this, node);
            return item;
        }
        if (node.getPrimaryNodeType().getName().equals(NT_WORKSPACE_PDF_FILE)) {
            JCRExternalPDFFile item = new JCRExternalPDFFile(this, node);
            return item;
        }
        if (node.getPrimaryNodeType().getName().equals(NT_WORKSPACE_URL)) {
            return new JCRExternalUrl(this, node);
        }
        if (node.getPrimaryNodeType().getName().equals(NT_WORKSPACE_REPORT)) {
            return new JCRReport(this, node);
        }
        if (node.getPrimaryNodeType().getName().equals(NT_WORKSPACE_REPORT_TEMPLATE)) {
            return new JCRReportTemplate(this, node);
        }
        if (node.getPrimaryNodeType().getName().equals(NT_WORKSPACE_WORKFLOW_REPORT)) {
            return new JCRWorkflowReport(this, node);
        }
        if (node.getPrimaryNodeType().getName().equals(NT_WORKSPACE_WORKFLOW_TEMPLATE)) {
            return new JCRWorkflowTemplate(this, node);
        }
        if (node.getPrimaryNodeType().getName().equals(NT_AQUAMAPS_ITEM)) {
            return new JCRAquaMapsItem(this, node);
        }
        if (node.getPrimaryNodeType().getName().equals(NT_QUERY)) {
            return new JCRQuery(this, node);
        }
        if (node.getPrimaryNodeType().getName().equals(NT_TIMESERIES_ITEM)) {
            return new JCRTimeSeries(this, node);
        }
        if (node.getPrimaryNodeType().getName().equals(NT_DOCUMENT_ITEM)) {
            return new JCRDocument(this, node);
        }
        if (node.getPrimaryNodeType().getName().equals(NT_DOCUMENT_LINK_ITEM)) {
            return new JCRDocumentLink(this, node);
        }
        if (node.getPrimaryNodeType().getName().equals(NT_IMAGE_DOCUMENT_ITEM)) {
            return new JCRImageDocument(this, node);
        }
        if (node.getPrimaryNodeType().getName().equals(NT_IMAGE_DOCUMENT_LINK_ITEM)) {
            return new JCRImageDocumentLink(this, node);
        }
        if (node.getPrimaryNodeType().getName().equals(NT_PDF_DOCUMENT_ITEM)) {
            return new JCRPDFDocument(this, node);
        }
        if (node.getPrimaryNodeType().getName().equals(NT_PDF_DOCUMENT_LINK_ITEM)) {
            return new JCRPDFDocumentLink(this, node);
        }
        if (node.getPrimaryNodeType().getName().equals(NT_URL_DOCUMENT_ITEM)) {
            return new JCRUrlDocument(this, node);
        }
        if (node.getPrimaryNodeType().getName().equals(NT_ANNOTATION_ITEM)) {
            return new JCRAnnotation(this, node);
        }
        if (node.getPrimaryNodeType().getName().equals(NT_METADATA_ITEM)) {
            return new JCRMetadata(this, node);
        }
        if (node.getPrimaryNodeType().getName().equals(NT_WORKSPACE_FOLDER_ITEM)) {
            return new JCRWorkspaceSmartFolder(this, node);
        }
        if (node.getPrimaryNodeType().getName().equals(NT_EXTERNAL_RESOURCE_LINK_ITEM)) {
            return new JCRExternalResourceLink(this, node);
        }
        throw new InternalErrorException("JCR node type unknow");
    }

    public FolderItemType getFolderItemType(Node node) throws RepositoryException {
        String nodeType = node.getPrimaryNodeType().getName();
        if (nodeType.equals(NT_WORKSPACE_FILE)) {
            return FolderItemType.EXTERNAL_FILE;
        }
        if (nodeType.equals(NT_WORKSPACE_IMAGE)) {
            return FolderItemType.EXTERNAL_IMAGE;
        }
        if (nodeType.equals(NT_WORKSPACE_PDF_FILE)) {
            return FolderItemType.EXTERNAL_PDF_FILE;
        }
        if (nodeType.equals(NT_WORKSPACE_URL)) {
            return FolderItemType.EXTERNAL_URL;
        }
        if (nodeType.equals(NT_WORKSPACE_REPORT)) {
            return FolderItemType.REPORT;
        }
        if (nodeType.equals(NT_WORKSPACE_REPORT_TEMPLATE)) {
            return FolderItemType.REPORT_TEMPLATE;
        }
        if (nodeType.equals(NT_WORKSPACE_WORKFLOW_REPORT)) {
            return FolderItemType.WORKFLOW_REPORT;
        }
        if (nodeType.equals(NT_WORKSPACE_WORKFLOW_TEMPLATE)) {
            return FolderItemType.WORKFLOW_TEMPLATE;
        }
        if (nodeType.equals(NT_AQUAMAPS_ITEM)) {
            return FolderItemType.AQUAMAPS_ITEM;
        }
        if (nodeType.equals(NT_QUERY)) {
            return FolderItemType.QUERY;
        }
        if (nodeType.equals(NT_TIMESERIES_ITEM)) {
            return FolderItemType.TIME_SERIES;
        }
        if (nodeType.equals(NT_DOCUMENT_ITEM)) {
            return FolderItemType.DOCUMENT;
        }
        if (nodeType.equals(NT_DOCUMENT_LINK_ITEM)) {
            return FolderItemType.DOCUMENT_LINK;
        }
        if (nodeType.equals(NT_IMAGE_DOCUMENT_ITEM)) {
            return FolderItemType.IMAGE_DOCUMENT;
        }
        if (nodeType.equals(NT_IMAGE_DOCUMENT_LINK_ITEM)) {
            return FolderItemType.IMAGE_DOCUMENT_LINK;
        }
        if (nodeType.equals(NT_PDF_DOCUMENT_ITEM)) {
            return FolderItemType.PDF_DOCUMENT;
        }
        if (nodeType.equals(NT_PDF_DOCUMENT_LINK_ITEM)) {
            return FolderItemType.PDF_DOCUMENT_LINK;
        }
        if (nodeType.equals(NT_URL_DOCUMENT_ITEM)) {
            return FolderItemType.URL_DOCUMENT;
        }
        if (nodeType.equals(NT_ANNOTATION_ITEM)) {
            return FolderItemType.ANNOTATION;
        }
        if (nodeType.equals(NT_METADATA_ITEM)) {
            return FolderItemType.METADATA_LINK;
        }
        if (nodeType.equals(NT_EXTERNAL_RESOURCE_LINK_ITEM)) {
            return FolderItemType.EXTERNAL_RESOURCE_LINK;
        }
        return null;
    }

    public WorkspaceFolder getParent(Node node) throws RepositoryException, InternalErrorException {
        Node parent = node.getParent();
        if (parent.getPrimaryNodeType().getName().equals(NT_WORKSPACE_FOLDER)) {
            return new JCRWorkspaceFolder(this, parent);
        }
        return null;
    }

    public JCRFile getGCUBEDocumentContent(Session session, String oid, ContentType contentType) throws RepositoryException {
        Node node = JCRRepository.getGCubeRoot(session).getNode(Text.escapeIllegalJcrChars((String)oid));
        switch (contentType) {
            case GENERAL: {
                return new JCRFile(node.getNode(CONTENT));
            }
            case IMAGE: {
                return new JCRImage(node.getNode(CONTENT));
            }
            case PDF: {
                return new JCRPDFFile(node.getNode(CONTENT));
            }
        }
        return null;
    }

    public JCRFile setGCUBEDocumentContent(Session session, String oid, InputStream data, String mimeType, ContentType contentType) throws IOException, ItemExistsException, RepositoryException {
        Node parent = JCRRepository.getGCubeRoot(session);
        Node nodeFile = parent.addNode(Text.escapeIllegalJcrChars((String)oid), NT_FILE);
        JCRFile file = null;
        switch (contentType) {
            case GENERAL: {
                file = new JCRFile(nodeFile.addNode(CONTENT, ContentType.GENERAL.toString()), mimeType, data);
                break;
            }
            case IMAGE: {
                file = new JCRImage(nodeFile.addNode(CONTENT, ContentType.IMAGE.toString()), data);
                break;
            }
            case PDF: {
                file = new JCRPDFFile(nodeFile.addNode(CONTENT, ContentType.PDF.toString()), mimeType, data);
                break;
            }
        }
        return file;
    }

    public List<SearchItem> searchByName(String name) throws InternalErrorException {
        Session session = JCRRepository.getSession();
        LinkedList<SearchItem> list = null;
        try {
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            Query q = queryManager.createQuery("/jcr:root/Home/" + this.getHome().getOwner().getPortalLogin() + "/Workspace//element()[jcr:contains(@jcr:title,'*" + name + "*')] ", "xpath");
            QueryResult result = q.execute();
            NodeIterator iterator = result.getNodes();
            list = new LinkedList<SearchItem>();
            while (iterator != null && iterator.hasNext()) {
                Node node = iterator.nextNode();
                if (node.getPrimaryNodeType().getName().equals(NT_WORKSPACE_FOLDER)) {
                    list.add((SearchItem)new JCRSearchFolder(node));
                    continue;
                }
                list.add((SearchItem)new JCRSearchFolderItem(node, this.getFolderItemType(node)));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Error searchByName ", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
        return list;
    }

    public List<WorkspaceItem> getWorkspaceTree(WorkspaceItem item) throws InternalErrorException {
        LinkedList<WorkspaceItem> listItems = new LinkedList<WorkspaceItem>();
        listItems.addAll(item.getChildren());
        for (WorkspaceItem child : item.getChildren()) {
            listItems.addAll(this.getWorkspaceTree(child));
        }
        return listItems;
    }

    public WorkspaceSmartFolder createSmartFolder(String name, String description, String query) throws ItemAlreadyExistException, InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            Node node = this.repository.getRootSmartFolders(session).addNode(name, NT_WORKSPACE_FOLDER_ITEM);
            JCRWorkspaceSmartFolder folder = new JCRWorkspaceSmartFolder(this, node, name, description, query);
            folder.save(node);
            JCRWorkspaceSmartFolder jCRWorkspaceSmartFolder = folder;
            return jCRWorkspaceSmartFolder;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public List<WorkspaceSmartFolder> getAllSmartFolders() throws InternalErrorException {
        Session session = JCRRepository.getSession();
        LinkedList<WorkspaceSmartFolder> folders = new LinkedList<WorkspaceSmartFolder>();
        try {
            NodeIterator iterator = this.repository.getRootSmartFolders(session).getNodes();
            while (iterator.hasNext()) {
                Node node = iterator.nextNode();
                folders.add(new JCRWorkspaceSmartFolder(this, node));
            }
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
        return folders;
    }

    public WorkspaceSmartFolder getSmartFolder(String folderId) throws org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException, InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            JCRWorkspaceSmartFolder jCRWorkspaceSmartFolder = new JCRWorkspaceSmartFolder(this, session.getNodeByIdentifier(folderId));
            return jCRWorkspaceSmartFolder;
        }
        catch (ItemNotFoundException e) {
            throw new org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException(e.getMessage());
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public List<SearchItem> getFolderItems(FolderItemType ... types) throws InternalErrorException {
        LinkedList<SearchItem> list = new LinkedList<SearchItem>();
        for (FolderItemType folderItemType : types) {
            list.addAll(this.getFolderItems(folderItemType));
        }
        return list;
    }

    public List<SearchItem> getFolderItems(FolderItemType type) throws InternalErrorException {
        Session session = JCRRepository.getSession();
        NodeIterator iterator = null;
        LinkedList<SearchItem> list = null;
        try {
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            Query q = queryManager.createQuery("/jcr:root/Home/" + this.getHome().getOwner().getPortalLogin() + "/Workspace//element()[@hl:workspaceItemType = '" + type.toString() + "']", "xpath");
            QueryResult result = q.execute();
            iterator = result.getNodes();
            list = new LinkedList<SearchItem>();
            while (iterator != null && iterator.hasNext()) {
                Node node = iterator.nextNode();
                try {
                    if (node.getPrimaryNodeType().getName().equals(NT_WORKSPACE_FOLDER)) {
                        list.add((SearchItem)new JCRSearchFolder(node));
                        continue;
                    }
                    list.add((SearchItem)new JCRSearchFolderItem(node, this.getFolderItemType(node)));
                }
                catch (RepositoryException e) {
                    try {
                        this.logger.error((Object)("Item " + node.getName() + "unknow"));
                    }
                    catch (RepositoryException e1) {
                        this.logger.error((Object)e1);
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Error getFolderItems", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
        return list;
    }

    public List<SearchFolderItem> searchByMimeType(String mimeType) throws InternalErrorException {
        Session session = JCRRepository.getSession();
        NodeIterator iterator = null;
        LinkedList<SearchFolderItem> list = null;
        try {
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            Query q = queryManager.createQuery("/jcr:root/Home/" + this.getHome().getOwner().getPortalLogin() + "/Workspace//element()[@jcr:mimeType = '" + mimeType + "']", "xpath");
            QueryResult result = q.execute();
            iterator = result.getNodes();
            list = new LinkedList<SearchFolderItem>();
            while (iterator != null && iterator.hasNext()) {
                Node node = iterator.nextNode();
                try {
                    list.add(new JCRSearchFolderItem(node.getParent(), this.getFolderItemType(node.getParent())));
                }
                catch (RepositoryException e) {
                    try {
                        this.logger.error((Object)("Item " + node.getName() + " unknow"));
                    }
                    catch (RepositoryException e1) {
                        this.logger.error((Object)e1);
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Error getFolderItems", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
        return list;
    }

    private String getJCRWorkspaceItemType(FolderItemType type) {
        switch (type) {
            case ANNOTATION: {
                return NT_ANNOTATION_ITEM;
            }
            case ANNOTATION_LINK: {
                return NT_ANNOTATION_LINK_ITEM;
            }
            case AQUAMAPS_ITEM: {
                return NT_AQUAMAPS_ITEM;
            }
            case DOCUMENT: {
                return NT_DOCUMENT_ITEM;
            }
            case DOCUMENT_LINK: {
                return NT_DOCUMENT_LINK_ITEM;
            }
            case EXTERNAL_FILE: {
                return NT_WORKSPACE_FILE;
            }
            case EXTERNAL_IMAGE: {
                return NT_WORKSPACE_IMAGE;
            }
            case EXTERNAL_PDF_FILE: {
                return NT_WORKSPACE_PDF_FILE;
            }
            case EXTERNAL_URL: {
                return NT_WORKSPACE_URL;
            }
            case IMAGE_DOCUMENT: {
                return NT_IMAGE_DOCUMENT_ITEM;
            }
            case IMAGE_DOCUMENT_LINK: {
                return NT_IMAGE_DOCUMENT_LINK_ITEM;
            }
            case METADATA: {
                return NT_METADATA_ITEM;
            }
            case METADATA_LINK: {
                return NT_METADATA_LINK_ITEM;
            }
            case PDF_DOCUMENT: {
                return NT_PDF_DOCUMENT_ITEM;
            }
            case PDF_DOCUMENT_LINK: {
                return NT_PDF_DOCUMENT_LINK_ITEM;
            }
            case QUERY: {
                return NT_QUERY;
            }
            case REPORT: {
                return NT_WORKSPACE_REPORT;
            }
            case REPORT_TEMPLATE: {
                return NT_WORKSPACE_REPORT_TEMPLATE;
            }
            case TIME_SERIES: {
                return NT_TIMESERIES_ITEM;
            }
            case URL_DOCUMENT: {
                return NT_URL_DOCUMENT_ITEM;
            }
            case WORKFLOW_REPORT: {
                return NT_WORKSPACE_WORKFLOW_REPORT;
            }
            case WORKFLOW_TEMPLATE: {
                return NT_WORKSPACE_WORKFLOW_TEMPLATE;
            }
        }
        return null;
    }

    public GCUBEScope getScope() {
        if (this.scope == null) {
            return null;
        }
        return GCUBEScope.getScope((String)this.scope);
    }

    public String getUrlWebDav() throws InternalErrorException {
        return this.repository.getUserHomeUrl(this.home.getOwner().getPortalLogin()) + this.getPathSeparator() + WORKSPACE_ROOT_FOLDER;
    }
}

