package org.gcube.portlets.user.homelibrary.jcr.content;

import java.security.Principal;
import java.util.LinkedList;
import java.util.List;

import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.SimpleCredentials;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.security.AccessControlList;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import javax.jcr.security.Privilege;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.jackrabbit.rmi.repository.URLRemoteRepository;


import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.queries.GCUBERuntimeResourceQuery;
import org.gcube.common.core.resources.GCUBERuntimeResource;
import org.gcube.common.core.resources.runtime.AccessPoint;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBEClientLog;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.portlets.user.homelibrary.home.User;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;


public class JCRRepository {
	
	public static final String PATH_SEPARATOR 			= "/";
	public static final String ROOT_WEBDAV				= "/repository/default/";
	
	private static final String HL_NAMESPACE			= "";
	private static final String DOWNLOADS				= "Downloads";
	private static final String HOME_FOLDER 			= "Home";
	private static final String SMART_FOLDER 			= "Folders";
	private static final String GCUBE_FOLDER 			= "GCube";
	private static final String IN_BOX_FOLDER 			= "InBox";
	private static final String OUT_BOX_FOLDER			= "OutBox";
	
	private static final String DATA_FOLDER = "ApplicationData";	
	private static final String NT_FOLDER = "nt:folder";
	private static final String NT_HOME						= "nthl:home";
	private static final String NT_ROOT_ITEM_SENT  			= "nthl:rootItemSentRequest";
	private static final String NT_ROOT_FOLDER_BULK_CREATOR = "nthl:rootFolderBulkCreator";
	
	private static final String SCOPES						= "hl:scopes";
	
	private static final String nameResource = "HomeLibraryRepository";
	
	private static Repository repository;
	
	private String userHomeId;
	private String applicationDataId;
	private static String gcubeRootId;
	private String smartFoldersId;
	private String downloadsId;
	private String inBoxId;
	private String outBoxId;
	
	private static String user;
	private static String pass;
	private static String url;
	
	
	private static GCUBELog logger = new GCUBEClientLog(JCRRepository.class); 
	
	private synchronized static void setRepository() throws InternalErrorException {
		
		if(repository != null)
			return;

		try {
			ISClient client = GHNContext.getImplementation(ISClient.class);
			GCUBERuntimeResourceQuery rtrQuery = client.getQuery(GCUBERuntimeResourceQuery.class);
			rtrQuery.addAtomicConditions(new AtomicCondition("/Profile/Name",nameResource));

			GHNContext ctx = GHNContext.getContext();
			String rootVOName = (String) ctx.getProperty(GHNContext.INFRASTRUCTURE_NAME, true);

			List<GCUBERuntimeResource> rtrs = client.execute(rtrQuery,
					GCUBEScope.getScope("/" + rootVOName));

			if (rtrs.size()==0) 
				throw new InternalErrorException("Resource " + nameResource + "not found");

			GCUBERuntimeResource rtr = rtrs.get(0);

			if (rtr.getAccessPoints().size()==0) 
				throw new InternalErrorException("Accesspoint in resource " + nameResource + " not found");

			AccessPoint ap = rtr.getAccessPoints().get(0);
			url = ap.getEndpoint();
			user = ap.getUsername(); 
			pass = ap.getPassword(); 

//			user = "workspacerep.imarine";
//			pass = "gcube2010*onan";
//			url = "http://node76.p.d4science.research-infrastructures.eu:8080/jackrabbit-custom-webapp-2.4.1";
//			user = "pippo.pippa";
//			pass = "onanismo";
//			url = "http://127.0.0.1:8080/jackrabbit-webapp-2.4.3";	
//			url = "http://node11.d.d4science.research-infrastructures.eu:8080/jackrabbit-custom-webapp-2.4.1";
//			repository = JcrUtils.getRepository(url + "/server");
			repository = new URLRemoteRepository(url + "/rmi");
					
		} catch (Exception e) {
			throw new InternalErrorException(e);
		}
		
	}
	
	public static void addUserToJCRUserManager(String userId, String userHome) {
		
		 GetMethod getMethod = null;
		 try {
             
			 HttpClient httpClient = new HttpClient();            
	
             getMethod =  new GetMethod(url + "/PortalUserManager?userId=" + userId + "&userHome=" +userHome);
             int returnCode = httpClient.executeMethod(getMethod);
             
             logger.debug("User set with status code " + getMethod.getResponseBodyAsString());
             
          } catch (Exception e) {
        	  logger.error("User set with error ", e);
          } finally {
        	  if(getMethod != null)
        		  getMethod.releaseConnection();
          }
   
	}
	
	public static Session getSession() throws InternalErrorException  {
			
		setRepository();
		synchronized (repository) {
			try {

				Session session = repository.login( 
						new SimpleCredentials(user, pass.toCharArray()));
				return session;
			} catch (Exception e) {
				throw new InternalErrorException(e);
			}
		}
	}
	
	public synchronized static void Initialize() throws InternalErrorException {
		
		logger.debug("Initialize ContentManager");
		
		Session session = getSession();
		try {
			Node root = session.getRootNode();
			if (!exist(root, HL_NAMESPACE + HOME_FOLDER)){
				root.addNode(HL_NAMESPACE + HOME_FOLDER, NT_FOLDER);
			}

			if (!exist(root, GCUBE_FOLDER)){
				root.addNode(GCUBE_FOLDER, NT_FOLDER);
			}

			gcubeRootId = root.getNode(GCUBE_FOLDER).getIdentifier();
			session.save();
			
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}
	}
	
	public JCRRepository(final User user) throws InternalErrorException {
		
		Session session = getSession();
		String userHomePath = null;
		try {
			Node root = session.getRootNode();
			Node home = root.getNode(HL_NAMESPACE + HOME_FOLDER);
			
			
			Node userHome;
			if (!exist(home, HL_NAMESPACE + user.getPortalLogin())) {
				userHome = home.addNode(HL_NAMESPACE + user.getPortalLogin(), NT_HOME);
			} else {
				userHome = home.getNode(HL_NAMESPACE + user.getPortalLogin());
			}
			session.save();
			userHomeId = userHome.getIdentifier();
			
			
			if(user.getScope() != null) 
				setScope(session, user.getScope().toString());
			
			addUserToJCRUserManager(user.getPortalLogin(), userHome.getPath());
			userHomePath = userHome.getPath();
			
			
			Node smartFolders;
			if (!exist(userHome, HL_NAMESPACE + SMART_FOLDER)) {
				smartFolders = userHome.addNode(HL_NAMESPACE + SMART_FOLDER, NT_FOLDER);
			} else {
				smartFolders = userHome.getNode(HL_NAMESPACE + SMART_FOLDER);
			}

			Node inBoxNode;
			if (!exist(userHome, HL_NAMESPACE + IN_BOX_FOLDER)) {
				inBoxNode = userHome.addNode(HL_NAMESPACE + IN_BOX_FOLDER, NT_ROOT_ITEM_SENT);
			} else {
				inBoxNode = userHome.getNode(HL_NAMESPACE + IN_BOX_FOLDER);
			}
			
			Node outBoxNode;
			if (!exist(userHome, HL_NAMESPACE + OUT_BOX_FOLDER)) {
				outBoxNode = userHome.addNode(HL_NAMESPACE + OUT_BOX_FOLDER, NT_ROOT_ITEM_SENT);
			} else {
				outBoxNode = userHome.getNode(HL_NAMESPACE + OUT_BOX_FOLDER);
			}
			
			Node downloads = null;
			if (!exist(userHome, HL_NAMESPACE + DOWNLOADS)) {
				downloads = userHome.addNode(HL_NAMESPACE + DOWNLOADS, NT_ROOT_FOLDER_BULK_CREATOR);
			} else {
				downloads = userHome.getNode(HL_NAMESPACE + DOWNLOADS);
			}
			
			session.save();
			
			smartFoldersId = smartFolders.getIdentifier();
			inBoxId = inBoxNode.getIdentifier();
			outBoxId = outBoxNode.getIdentifier();
			downloadsId = downloads.getIdentifier(); 
							
		} catch (RepositoryException e) {
			logger.error("Repository not instantiated", e);
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}
		
	
//		setACL(user.getPortalLogin(), userHomePath);
	

	}

	public static void setACL(final String portalLogin , String userHome)
			throws InternalErrorException {
		
		
		Session session = null;
		try {
			
			Repository RMIrepository = new URLRemoteRepository(url + "/rmi");
			session = RMIrepository.login( 
					new SimpleCredentials(user, pass.toCharArray()));
			
			AccessControlManager accessControlManager = session.getAccessControlManager();
			AccessControlPolicyIterator acpIterator = accessControlManager.getApplicablePolicies(userHome);
			if (acpIterator.hasNext()) {
				logger.debug(" ------------ ACL Present ");
				AccessControlPolicy policy = acpIterator.nextAccessControlPolicy();
				AccessControlList list = (AccessControlList)policy;
				list.addAccessControlEntry(new Principal() {

					@Override
					public String getName() {
						return portalLogin;
					}
				}, new Privilege[]{accessControlManager.privilegeFromName(Privilege.JCR_READ)});

				accessControlManager.setPolicy(userHome, list);
			}
			session.save();
		} catch (Exception e) {
			throw new InternalErrorException(e);
		} finally {
			if(session != null)
				session.logout();
		}
	}
	
	
	public void setScope(Session session, String scope) throws RepositoryException {
		
		Node userHome = getUserHome(session);
		
		Property scopes;
		try {
			scopes = userHome.getProperty(SCOPES);
		} catch (PathNotFoundException e) {
			String[] values = {scope};
			userHome.setProperty(SCOPES, values);
			return;
		}
		
		for (Value value : scopes.getValues()) {
			if(value.getString().equals(scope))
				return;
		}

		


		String[] newScopes = new String[scopes.getValues().length + 1];
		newScopes[0] = scope;
		for (int i = 1; i < newScopes.length; i++) {
			newScopes[i] = scopes.getValues()[i - 1].getString();
		}
		userHome.setProperty(SCOPES, newScopes);
	}
	
	
	private static boolean exist(Node parent, String childName) throws RepositoryException {
		
		try {
			parent.getNode(childName);
		} catch (PathNotFoundException e) {
			return false;
		} 
		return true;
	}
	
	public boolean existChild(Node father, String child){
		
		try {
			father.getNode(child);
		} catch (RepositoryException e) {
			return false;
		}
		return true;
	}
	
	public List<String> listScopes() throws RepositoryException, InternalErrorException {
		
		List<String> list = new LinkedList<String>();
		
		Session session = getSession();
		try {
			Node userHome = session.getNodeByIdentifier(userHomeId);
			Property scopes = userHome.getProperty(SCOPES);

			for (Value value  : scopes.getValues()) {
				list.add(value.getString());
			}
			return list;

		} catch (PathNotFoundException e) {
			return new LinkedList<String>();
		} finally {
			if (session != null)
				session.logout();
		}
	}
	
	
	public static Node getGCubeRoot(Session session) throws RepositoryException {
		return session.getNodeByIdentifier(gcubeRootId);
	}

	public Node getUserHome(Session session) throws RepositoryException {		
		return  session.getNodeByIdentifier(userHomeId); 
	}
	
	public Node getRootSmartFolders(Session session) throws RepositoryException {
		return  session.getNodeByIdentifier(smartFoldersId);
	}
	
	public Node getOwnInBoxFolder(Session session) throws RepositoryException {
		return  session.getNodeByIdentifier(inBoxId);
	}
	
	public Node getRootFolderBulkCreators(Session session) throws RepositoryException {
		return session.getNodeByIdentifier(downloadsId);
	}
	
	public Node getOutBoxFolder(Session session) throws RepositoryException {
		return session.getNodeByIdentifier(outBoxId);
	}
	
	public Node getInBoxFolder(Session session, String user) throws RepositoryException,
	InternalErrorException  {
		return session.getRootNode().getNode(HOME_FOLDER + PATH_SEPARATOR 
				+ HL_NAMESPACE + user + PATH_SEPARATOR + IN_BOX_FOLDER);
	}
	
	public String getUserHomeUrl(String portalLogin) {
		return url + ROOT_WEBDAV + HOME_FOLDER + PATH_SEPARATOR + portalLogin;     
	}
}
