/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.jcr.importing;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.util.Text;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBEClientLog;
import org.gcube.contentmanagement.contentmanager.stubs.model.protocol.URIs;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.DocumentReader;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.AlternativeProjection;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.AnnotationProjection;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.DocumentProjection;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.MetadataProjection;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.PartProjection;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.Projection;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.Projections;
import org.gcube.contentmanagement.gcubedocumentlibrary.properties.Property;
import org.gcube.contentmanagement.gcubedocumentlibrary.properties.PropertyTypes;
import org.gcube.contentmanagement.gcubedocumentlibrary.util.Collection;
import org.gcube.contentmanagement.gcubedocumentlibrary.util.Collections;
import org.gcube.contentmanagement.gcubedocumentlibrary.views.MetadataView;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeAlternative;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeAnnotation;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeDocument;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeElement;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeMetadata;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubePart;
import org.gcube.contentmanagement.gcubemodellibrary.elements.InnerElements;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ExternalUrl;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.Query;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.Document;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.Metadata;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.link.DocumentAlternativeLink;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.link.DocumentPartLink;
import org.gcube.portlets.user.homelibrary.jcr.content.JCRRepository;
import org.gcube.portlets.user.homelibrary.jcr.importing.ContentManagerItemType;
import org.gcube.portlets.user.homelibrary.jcr.importing.ImportContentManagerItemRequest;
import org.gcube.portlets.user.homelibrary.jcr.importing.ImportQueryRequest;
import org.gcube.portlets.user.homelibrary.jcr.importing.ImportRequest;
import org.gcube.portlets.user.homelibrary.jcr.importing.ImportUrlRequest;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRFolderBulkCreatorManager;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspaceFolder;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.ContentType;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRFile;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.gcube.JCRDocument;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.gcube.link.JCRDocumentAlternativeLink;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.gcube.link.JCRDocumentPartLink;
import org.gcube.portlets.user.homelibrary.util.WorkspaceUtil;

public class JCRWorkspaceFolderItemImporter
implements Runnable {
    protected static final AlternativeProjection ALTERNATIVE_PROJECTION = (AlternativeProjection)Projections.alternative().allexcept((Property)Projections.BYTESTREAM, (Property[])new PropertyTypes.AlternativeProperty[0]);
    protected static final AlternativeProjection ALTERNATIVE_WITH_CONTENT_PROJECTION = (AlternativeProjection)((AlternativeProjection)Projections.alternative().etc()).with(Projections.opt((Property)Projections.BYTESTREAM), (Property[])new PropertyTypes.AlternativeProperty[]{(PropertyTypes.AlternativeProperty)Projections.opt((Property)Projections.BYTESTREAM_URI)});
    protected static final AnnotationProjection ANNOTATION_PROJECTION = Projections.annotation();
    protected static final AnnotationProjection ANNOTATION_WITH_CONTENT_PROJECTION = (AnnotationProjection)((AnnotationProjection)Projections.annotation().etc()).with(Projections.opt((Property)Projections.BYTESTREAM), (Property[])new PropertyTypes.AnnotationProperty[]{(PropertyTypes.AnnotationProperty)Projections.opt((Property)Projections.BYTESTREAM_URI)});
    protected static final MetadataProjection METADATA_PROJECTION = Projections.metadata();
    protected static final MetadataProjection METADATA_WITH_CONTENT_PROJECTION = (MetadataProjection)((MetadataProjection)Projections.metadata().etc()).with(Projections.opt((Property)Projections.BYTESTREAM), (Property[])new PropertyTypes.MetadataProperty[]{(PropertyTypes.MetadataProperty)Projections.opt((Property)Projections.BYTESTREAM_URI)});
    protected static final PartProjection PART_PROJECTION = Projections.part();
    protected static final PartProjection PART_WITH_CONTENT_PROJECTION = (PartProjection)((PartProjection)Projections.part().etc()).with(Projections.opt((Property)Projections.BYTESTREAM), (Property[])new PropertyTypes.PartProperty[]{(PropertyTypes.PartProperty)Projections.opt((Property)Projections.BYTESTREAM_URI)});
    protected static final DocumentProjection DOCUMENT_PROJECTION = (DocumentProjection)((DocumentProjection)((DocumentProjection)((DocumentProjection)((DocumentProjection)Projections.document().with(Projections.opt((Property)Projections.ALTERNATIVE, (Projection)Projections.alternative().allexcept((Property)Projections.BYTESTREAM, (Property[])new PropertyTypes.AlternativeProperty[0])), (Property[])new PropertyTypes.DocumentProperty[0])).with(Projections.opt((Property)Projections.ANNOTATION, (Projection)Projections.annotation().allexcept((Property)Projections.BYTESTREAM, (Property[])new PropertyTypes.AnnotationProperty[0])), (Property[])new PropertyTypes.DocumentProperty[0])).with(Projections.opt((Property)Projections.METADATA, (Projection)Projections.metadata().allexcept((Property)Projections.BYTESTREAM, (Property[])new PropertyTypes.MetadataProperty[0])), (Property[])new PropertyTypes.DocumentProperty[0])).with(Projections.opt((Property)Projections.PART, (Projection)Projections.part().allexcept((Property)Projections.BYTESTREAM, (Property[])new PropertyTypes.PartProperty[0])), (Property[])new PropertyTypes.DocumentProperty[0])).allexcept((Property)Projections.BYTESTREAM, (Property[])new PropertyTypes.DocumentProperty[0]);
    protected static final DocumentProjection DOCUMENT_WITH_CONTENT_PROJECTION = (DocumentProjection)((DocumentProjection)((DocumentProjection)((DocumentProjection)Projections.document().with(Projections.opt((Property)Projections.ALTERNATIVE, (Projection)Projections.alternative().allexcept((Property)Projections.BYTESTREAM, (Property[])new PropertyTypes.AlternativeProperty[0])), (Property[])new PropertyTypes.DocumentProperty[0])).with(Projections.opt((Property)Projections.ANNOTATION, (Projection)Projections.annotation().allexcept((Property)Projections.BYTESTREAM, (Property[])new PropertyTypes.AnnotationProperty[0])), (Property[])new PropertyTypes.DocumentProperty[0])).with(Projections.opt((Property)Projections.PART, (Projection)Projections.part().allexcept((Property)Projections.BYTESTREAM, (Property[])new PropertyTypes.PartProperty[0])), (Property[])new PropertyTypes.DocumentProperty[0])).etc();
    private List<ImportContentManagerItemRequest> contentItemRequests;
    private List<ImportUrlRequest> urlRequests;
    private List<ImportQueryRequest> queryRequests;
    private Map<String, DocumentReader> readersCache;
    private Map<String, Collection> collectionsCache;
    private List<MetadataView> metadataViewsCache;
    private final JCRRepository contentManager;
    private final String folderBulkCreatorId;
    private final GCUBEScope scope;
    private final JCRFolderBulkCreatorManager manager;
    private final String STATUS = "hl:status";
    private final String FAILURES = "hl:failures";
    private int failures;
    private int status;
    private final int totalRequests;
    private final JCRWorkspaceFolder folder;
    private GCUBEClientLog logger = new GCUBEClientLog((Object)this, new Properties[0]);

    public JCRWorkspaceFolderItemImporter(JCRFolderBulkCreatorManager manager, String folderBulkCreatorId, List<ImportRequest> requests, JCRWorkspaceFolder folder) throws InternalErrorException {
        this.manager = manager;
        this.folderBulkCreatorId = folderBulkCreatorId;
        this.contentManager = folder.getWorkspace().getRepository();
        this.scope = folder.getWorkspace().getOwner().getScope();
        this.folder = folder;
        this.status = 0;
        this.failures = 0;
        this.contentItemRequests = new LinkedList<ImportContentManagerItemRequest>();
        this.urlRequests = new LinkedList<ImportUrlRequest>();
        this.queryRequests = new LinkedList<ImportQueryRequest>();
        this.collectionsCache = new LinkedHashMap<String, Collection>();
        this.readersCache = new HashMap<String, DocumentReader>();
        this.totalRequests = requests.size();
        for (ImportRequest request : requests) {
            switch (request.getType()) {
                case CONTENT_MANAGER_ITEM: {
                    this.contentItemRequests.add((ImportContentManagerItemRequest)request);
                    break;
                }
                case URL: {
                    this.urlRequests.add((ImportUrlRequest)request);
                    break;
                }
                case QUERY: {
                    this.queryRequests.add((ImportQueryRequest)request);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeStatus() {
        Session session = null;
        try {
            session = JCRRepository.getSession();
            Node node = this.contentManager.getRootFolderBulkCreators(session).getNode(this.folderBulkCreatorId);
            node.setProperty("hl:status", (long)(++this.status));
            session.save();
        }
        catch (Exception e) {
            this.logger.error((Object)"Status not set", (Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeFailures() {
        Session session = null;
        try {
            session = JCRRepository.getSession();
            Node node = this.contentManager.getRootFolderBulkCreators(session).getNode(this.folderBulkCreatorId);
            node.setProperty("hl:failures", (long)(++this.failures));
            session.save();
        }
        catch (Exception e) {
            this.logger.error((Object)"Failure not set", (Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    @Override
    public void run() {
        String name;
        ExecutorService executorService = Executors.newFixedThreadPool(5);
        for (ImportContentManagerItemRequest importContentManagerItemRequest : this.contentItemRequests) {
            GCubeDocument element;
            URI uri = importContentManagerItemRequest.getUri();
            boolean contentIsLocal = this.contentIsLocal(uri);
            if (importContentManagerItemRequest.getItemType() == ContentManagerItemType.METADATA) {
                contentIsLocal = false;
            }
            try {
                DocumentProjection projection;
                String collectionId = URIs.collectionID((URI)uri);
                DocumentReader reader = this.getReader(collectionId);
                if (importContentManagerItemRequest.getItemType() != ContentManagerItemType.DOCUMENT) {
                    projection = null;
                    switch (importContentManagerItemRequest.getItemType()) {
                        case ALTERNATIVE: {
                            projection = contentIsLocal ? ALTERNATIVE_PROJECTION : ALTERNATIVE_WITH_CONTENT_PROJECTION;
                            break;
                        }
                        case ANNOTATION: {
                            projection = contentIsLocal ? ANNOTATION_PROJECTION : ANNOTATION_WITH_CONTENT_PROJECTION;
                            break;
                        }
                        case METADATA: {
                            projection = contentIsLocal ? METADATA_PROJECTION : METADATA_WITH_CONTENT_PROJECTION;
                            break;
                        }
                        case PART: {
                            projection = contentIsLocal ? PART_PROJECTION : PART_WITH_CONTENT_PROJECTION;
                        }
                    }
                    element = reader.resolve(uri, (Projection)projection);
                } else {
                    projection = contentIsLocal ? DOCUMENT_PROJECTION : DOCUMENT_WITH_CONTENT_PROJECTION;
                    element = reader.get(URIs.documentID((URI)uri), (Projection)projection);
                    this.logger.debug((Object)("Document uri: " + element.uri()));
                }
            }
            catch (Exception e) {
                this.upgradeFailures();
                this.logger.error((Object)"Reader exception", (Throwable)e);
                continue;
            }
            if (contentIsLocal) {
                this.importGCubeElement(uri, (GCubeElement)element, null);
                continue;
            }
            if (element.bytestream() != null) {
                this.importGCubeElement(uri, (GCubeElement)element, new ByteArrayInputStream(element.bytestream()));
                continue;
            }
            if (element.bytestreamURI() == null) continue;
            executorService.execute(new Runnable((GCubeElement)element, uri){
                final /* synthetic */ GCubeElement val$element;
                final /* synthetic */ URI val$uri;
                {
                    this.val$element = gCubeElement;
                    this.val$uri = uRI;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    InputStream inputStream = null;
                    try {
                        URLConnection connection = this.val$element.bytestreamURI().toURL().openConnection();
                        inputStream = connection.getInputStream();
                        JCRWorkspaceFolderItemImporter.this.importGCubeElement(this.val$uri, this.val$element, inputStream);
                    }
                    catch (IOException e) {
                        JCRWorkspaceFolderItemImporter.this.upgradeFailures();
                        JCRWorkspaceFolderItemImporter.this.logger.error((Object)"Content retrieving failed", (Throwable)e);
                        return;
                    }
                    finally {
                        try {
                            inputStream.close();
                        }
                        catch (Exception e) {
                            JCRWorkspaceFolderItemImporter.this.logger.error((Object)"InputStream not closed");
                        }
                    }
                }
            });
        }
        executorService.shutdown();
        for (ImportUrlRequest importUrlRequest : this.urlRequests) {
            name = importUrlRequest.getUrl();
            name = Text.escapeIllegalJcrChars((String)name);
            try {
                name = WorkspaceUtil.getUniqueName((String)name, (WorkspaceFolder)this.folder);
                ExternalUrl externalUrl = this.folder.createExternalUrlItem(name, "", importUrlRequest.getUrl());
                this.folder.getWorkspace().fireItemImportedEvent((WorkspaceItem)externalUrl);
                this.upgradeStatus();
            }
            catch (Exception e) {
                this.upgradeFailures();
            }
        }
        for (ImportQueryRequest importQueryRequest : this.queryRequests) {
            name = importQueryRequest.getName();
            name = Text.escapeIllegalJcrChars((String)name);
            try {
                name = WorkspaceUtil.getUniqueName((String)importQueryRequest.getName(), (WorkspaceFolder)this.folder);
                Query query = this.folder.createQueryItem(name, "", importQueryRequest.getQuery(), importQueryRequest.getQueryType());
                this.folder.getWorkspace().fireItemImportedEvent((WorkspaceItem)query);
                this.upgradeStatus();
            }
            catch (Exception e) {
                this.upgradeFailures();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean contentIsLocal(URI uri) {
        Session session = null;
        JCRFile file = null;
        try {
            session = JCRRepository.getSession();
            file = this.folder.getWorkspace().getGCUBEDocumentContent(session, uri.toString(), ContentType.GENERAL);
        }
        catch (RepositoryException e) {
            this.logger.error((Object)"GCUBE element root node not exist", (Throwable)e);
        }
        catch (InternalErrorException e) {
            this.logger.error((Object)"Session refused");
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        this.logger.debug((Object)("-------------- content " + uri.toString() + " is local " + (file != null)));
        return file != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importGCubeElement(URI uri, GCubeElement element, InputStream inputStream) {
        try {
            if (element instanceof GCubeDocument) {
                this.logger.debug((Object)("The GCubeElement " + element + "is a GCubeDocument"));
                HashMap<String, String> mapMetadata = new HashMap<String, String>();
                for (GCubeMetadata metadata : ((GCubeDocument)element).metadata()) {
                    String schemaName = metadata.schemaName();
                    String language = metadata.language();
                    byte[] bytes = metadata.bytestream();
                    if (schemaName == null || language == null || bytes == null) continue;
                    String data = new String(bytes);
                    mapMetadata.put(schemaName + "_" + language, data);
                }
                JCRDocument document = (JCRDocument)this.importGCubeDocument(uri.toString(), element, mapMetadata, inputStream);
                this.upgradeStatus();
                List<DocumentAlternativeLink> alternatives = this.getDocumentAlternativeLinks(((GCubeDocument)element).uri().toString(), (InnerElements<GCubeAlternative>)((GCubeDocument)element).alternatives());
                List<DocumentPartLink> parts = this.getDocumentPartLinks(((GCubeDocument)element).id(), (InnerElements<GCubePart>)((GCubeDocument)element).parts());
                Session session = null;
                try {
                    session = JCRRepository.getSession();
                    document.setAlternatives(session, alternatives);
                    document.setParts(session, parts);
                }
                finally {
                    session.logout();
                }
            } else if (element instanceof GCubeAlternative || element instanceof GCubePart) {
                this.importGCubeDocument(uri.toString(), element, new HashMap<String, String>(), inputStream);
                this.upgradeStatus();
            } else if (element instanceof GCubeMetadata) {
                this.importGCubeMetadata((GCubeMetadata)element, inputStream);
                this.upgradeStatus();
            } else if (element instanceof GCubeAnnotation) {
                this.upgradeStatus();
            }
            return;
        }
        catch (Exception e) {
            this.upgradeFailures();
            this.logger.error((Object)e);
            return;
        }
    }

    private void importGCubeMetadata(GCubeMetadata metadata, InputStream inputStream) throws Exception {
        String oid = metadata.uri().toString();
        String name = metadata.name();
        String schema = metadata.schemaName();
        String language = metadata.language();
        String collectionName = this.getMetadataViewName(schema, metadata.schemaURI(), language, metadata.uri());
        if (collectionName == null) {
            collectionName = "unknown";
        }
        StringWriter sw = new StringWriter();
        IOUtils.copy((InputStream)inputStream, (Writer)sw);
        String data = sw.toString();
        name = Text.escapeIllegalJcrChars((String)name);
        name = WorkspaceUtil.getUniqueName((String)name, (WorkspaceFolder)this.folder);
        Metadata importedMetaData = this.folder.createMetadataItem(name, "", oid, schema, language, data, collectionName);
        this.folder.getWorkspace().fireItemImportedEvent((WorkspaceItem)importedMetaData);
    }

    private Document importGCubeDocument(String oid, GCubeElement document, HashMap<String, String> metadata, InputStream documentData) throws Exception {
        this.logger.debug((Object)("Import GCubeDocument " + document.uri()));
        String name = document.name();
        String mimeType = document.mimeType();
        String collectionName = this.getCollectionName(document.uri()) == null ? "Unknown" : this.getCollectionName(document.uri());
        name = Text.escapeIllegalJcrChars((String)name);
        name = WorkspaceUtil.getUniqueName((String)name, (WorkspaceFolder)this.folder);
        Document importedDocument = null;
        if (mimeType != null) {
            if (mimeType.startsWith("image")) {
                this.logger.debug((Object)"Import GCubeImageDocument");
                importedDocument = this.folder.createImageDocumentItem(name, "", oid, mimeType, documentData, metadata, new LinkedHashMap<String, String>(), collectionName);
            } else if (mimeType.equals("application/pdf")) {
                this.logger.debug((Object)"Import GCubePdfDocument");
                importedDocument = this.folder.createPDFDocumentItem(name, "", oid, mimeType, documentData, metadata, new LinkedHashMap<String, String>(), collectionName);
            } else if (mimeType.equals("text/uri-list")) {
                this.logger.debug((Object)"Import GCubeUrlDocument");
                importedDocument = this.folder.createUrlDocumentItem(name, "", oid, mimeType, documentData, metadata, new LinkedHashMap<String, String>(), collectionName);
            } else {
                this.logger.debug((Object)"Import GCubeDocument");
                importedDocument = this.folder.createDocumentItem(name, "", oid, mimeType, documentData, metadata, new LinkedHashMap<String, String>(), collectionName);
            }
        } else {
            importedDocument = this.folder.createDocumentItem(collectionName, "", oid, "n/a", documentData, metadata, new LinkedHashMap<String, String>(), collectionName);
        }
        this.folder.getWorkspace().fireItemImportedEvent((WorkspaceItem)importedDocument);
        return importedDocument;
    }

    private List<DocumentAlternativeLink> getDocumentAlternativeLinks(String parentId, InnerElements<GCubeAlternative> alternatives) throws IllegalStateException, URISyntaxException {
        LinkedList<DocumentAlternativeLink> alternativeLinks = new LinkedList<DocumentAlternativeLink>();
        for (GCubeAlternative alternative : alternatives) {
            JCRDocumentAlternativeLink alternativeLink = new JCRDocumentAlternativeLink(parentId, alternative.uri().toString(), alternative.name(), alternative.mimeType());
            alternativeLinks.add(alternativeLink);
        }
        return alternativeLinks;
    }

    private List<DocumentPartLink> getDocumentPartLinks(String parentId, InnerElements<GCubePart> parts) throws IllegalStateException, URISyntaxException {
        LinkedList<DocumentPartLink> partLinks = new LinkedList<DocumentPartLink>();
        for (GCubePart part : parts) {
            JCRDocumentPartLink partLink = new JCRDocumentPartLink(parentId, part.uri().toString(), part.name(), part.mimeType());
            partLinks.add(partLink);
        }
        return partLinks;
    }

    private String getCollectionName(URI uri) throws Exception {
        String collectionId = URIs.collectionID((URI)uri);
        Collection collection = this.collectionsCache.get(collectionId);
        if (collection != null) {
            this.logger.debug((Object)("Collection name = " + collection.getName()));
            return collection.getName();
        }
        try {
            this.logger.debug((Object)"Retrieve collection Name");
            List foundCollections = Collections.findById((GCUBEScope)this.scope, (String)collectionId);
            if (foundCollections.size() == 1) {
                this.logger.debug((Object)"Collection found");
                collection = (Collection)foundCollections.get(0);
                this.collectionsCache.put(collection.getId(), collection);
                this.logger.debug((Object)("Collection name = " + collection.getName()));
                return collection.getName();
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    private String getMetadataViewName(String schemaName, URI schemaUri, String language, URI uri) throws URISyntaxException {
        String collectionId = URIs.collectionID((URI)uri);
        MetadataView metadataView = this.findView(collectionId, schemaName, schemaUri, language);
        if (metadataView != null) {
            return metadataView.name();
        }
        return null;
    }

    private MetadataView findView(String collectionId, String schemaName, URI schemaUri, String language) {
        for (MetadataView view : this.metadataViewsCache) {
            if (!view.collectionId().equals(collectionId) || !view.schemaName().equals(schemaName) || !view.schemaURI().equals(schemaUri) || !view.language().equals(language)) continue;
            return view;
        }
        MetadataView metadataView = new MetadataView(this.scope);
        metadataView.setCollectionId(collectionId);
        metadataView.setSchemaName(schemaName);
        metadataView.setSchemaURI(schemaUri);
        metadataView.setLanguage(new Locale(language));
        try {
            List foundViews = metadataView.findSimilar();
            if (foundViews.size() == 1) {
                MetadataView view = (MetadataView)foundViews.get(0);
                this.metadataViewsCache.add(view);
                return view;
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    private DocumentReader getReader(String collectionId) throws Exception {
        DocumentReader reader = this.readersCache.get(collectionId);
        if (reader == null) {
            this.logger.debug((Object)("Return a new reader for scope " + this.scope));
            reader = new DocumentReader(collectionId, this.scope);
            this.readersCache.put(collectionId, reader);
        }
        return reader;
    }
}

