package org.gcube.portlets.user.homelibrary.jcr.home;

import java.io.File;
import java.util.List;

import javax.jcr.RepositoryException;
import javax.jcr.Session;

import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBEClientLog;
import org.gcube.portlets.user.homelibrary.home.Home;
import org.gcube.portlets.user.homelibrary.home.HomeManager;
import org.gcube.portlets.user.homelibrary.home.User;
import org.gcube.portlets.user.homelibrary.home.data.DataArea;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.Workspace;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.portlets.user.homelibrary.jcr.JCRUser;
import org.gcube.portlets.user.homelibrary.jcr.content.JCRRepository;
import org.gcube.portlets.user.homelibrary.jcr.data.JCRDataArea;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspace;



public class JCRHome implements Home {

	private final HomeManager homeManager;
	private final JCRUser owner;

	private final File persistenceFolder;
	private final JCRRepository repository;
	private final Workspace workspace; 
	
	private GCUBEClientLog logger;
	
	public JCRHome(HomeManager homeManager, JCRUser user, File persistenceFolder) throws Exception {
		super();
		
		setupLogger();
		
		this.owner = user;
		this.persistenceFolder = persistenceFolder;
		this.homeManager = homeManager;
		this.repository = new JCRRepository(user);
		this.workspace = new JCRWorkspace(this, repository);
		
	}
	
	public JCRHome(JCRUser user) {
		this.owner = user;
		this.persistenceFolder = null;
		this.homeManager = null;
		this.repository = null;
		this.workspace = null;
	}
	
	private void setupLogger() {
				
		logger = new GCUBEClientLog(this);
		
/*		File userLogFolder = new File(persistenceFolder,owner.getPortalLogin());
		if(!userLogFolder.exists()){
			userLogFolder.mkdir();
		}
		
		logger = LogManager.exists(user.getPortalLogin());
		
		if (logger == null){
			
			logger = Logger.getLogger(user.getPortalLogin());
			logger.setLevel(Level.ALL);
			
			logger.debug("Logger not exist");
			
			String loggerTraceFileName = userLogFolder.getAbsolutePath() + File.separator + "trace.log";
			String loggerInfoFileName = userLogFolder.getAbsolutePath() + File.separator + "info.log";
			String loggerErrorFileName = userLogFolder.getAbsolutePath() + File.separator + "error.log";
			PatternLayout loggerLayout = new PatternLayout("[%d{ISO8601}] [%-5p] - %l - %m%n");
			ConsoleAppender consoleAppender = new ConsoleAppender(loggerLayout);
			logger.addAppender(consoleAppender);
			
			try {
				
				FileAppender faTrace = new FileAppender(loggerLayout, loggerTraceFileName);
				faTrace.setThreshold(Level.ALL);
				faTrace.activateOptions();
				logger.addAppender(faTrace);

				FileAppender faInfo = new FileAppender(loggerLayout, loggerInfoFileName);
				faInfo.setThreshold(Level.INFO);
				faInfo.activateOptions();
				logger.addAppender(faInfo);
				
				FileAppender faError = new FileAppender(loggerLayout, loggerErrorFileName);
				faError.setThreshold(Level.ERROR);
				faError.activateOptions();
				logger.addAppender(faError);

			} catch (IOException e) {
				logger.error("Error during file appender initialization", e);
				e.printStackTrace();
			}
		}*/
	}

	public void setScope(GCUBEScope scope) throws InternalErrorException {
		owner.setScope(scope);
		
		Session session = JCRRepository.getSession();
		try {
			repository.setScope(session, scope.toString());
			session.save();
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}
		
	}
	
	@Override
	public HomeManager getHomeManager() {
		return homeManager;
	}
	

	@Override
	public User getOwner() {
		return owner;
	}

	@Override
	public Workspace getWorkspace() throws WorkspaceFolderNotFoundException,
			InternalErrorException {
		return workspace;
	}

	@Override
	public DataArea getDataArea() throws InternalErrorException {
		//TODO
		return  new JCRDataArea(null);
	}

	@Override
	public List<String> listScopes() throws  InternalErrorException {
		
		try {
			return repository.listScopes();
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		}
	}

}
