package org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

import javax.jcr.Node;
import javax.jcr.RepositoryException;

import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItemType;
import org.gcube.portlets.user.homelibrary.jcr.workspace.util.WorkspaceItemUtil;

public class JCRPDFFile extends JCRFile {
	
	private static final String NUMBER_OF_PAGES = "hl:numberOfPages";
	private static final String VERSION = "hl:version";
	private static final String AUTHOR = "hl:author";
	private static final String TITLE = "hl:title";
	private static final String PRODUCER = "hl:producer";
	
	private final int numberOfPages;
	private final String version;
	private final String author;
	private final String title;
	private final String producer;
	
	public JCRPDFFile(Node node) throws RepositoryException   {
		super(node);

		this.numberOfPages = (int) node.getProperty(NUMBER_OF_PAGES).getLong();
		this.version = node.getProperty(VERSION).getString();
		this.author = node.getProperty(AUTHOR).getString();
		this.title = node.getProperty(TITLE).getString();
		this.producer = node.getProperty(PRODUCER).getString();

	}
	
	public JCRPDFFile(Node node, String mimeType,InputStream data) throws RepositoryException,
	IOException {
		super(node,new BufferedInputStream(data));
		
		InputStream dataPdf =  node.getProperty(DATA).getBinary().getStream();
		Map<String,String> infoPDF = WorkspaceItemUtil.getPDFInfo(dataPdf);
		this.numberOfPages = Integer.parseInt(infoPDF.get(WorkspaceItemUtil.NUMBER_OF_PAGES));
		this.version = infoPDF.get(WorkspaceItemUtil.VERSION);
		this.author = infoPDF.get(WorkspaceItemUtil.AUTHOR);
		this.title = infoPDF.get(WorkspaceItemUtil.TITLE);
		this.producer = infoPDF.get(WorkspaceItemUtil.PRODUCER);
		
		node.setProperty(NUMBER_OF_PAGES, numberOfPages);
		node.setProperty(VERSION, version);
		node.setProperty(AUTHOR, author);
		node.setProperty(TITLE, title);
		node.setProperty(PRODUCER, producer);

		dataPdf.close();
	}
	
	public FolderItemType getFolderItemType() {
		return FolderItemType.EXTERNAL_PDF_FILE;	
	}

	public int getNumberOfPages() {	
		return numberOfPages;
	}

	public String getVersion() {
		return version;
	}

	public String getAuthor() {
		return author;
	}

	public String getTitle() {
		return title;
	}

	public String getProducer() {
		return producer;
	}

}
