/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItemType;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRFile;
import org.gcube.portlets.user.homelibrary.jcr.workspace.util.WorkspaceItemUtil;

public class JCRPDFFile
extends JCRFile {
    private static final String NUMBER_OF_PAGES = "hl:numberOfPages";
    private static final String VERSION = "hl:version";
    private static final String AUTHOR = "hl:author";
    private static final String TITLE = "hl:title";
    private static final String PRODUCER = "hl:producer";
    private final int numberOfPages;
    private final String version;
    private final String author;
    private final String title;
    private final String producer;

    public JCRPDFFile(Node node) throws RepositoryException {
        super(node);
        this.numberOfPages = (int)node.getProperty(NUMBER_OF_PAGES).getLong();
        this.version = node.getProperty(VERSION).getString();
        this.author = node.getProperty(AUTHOR).getString();
        this.title = node.getProperty(TITLE).getString();
        this.producer = node.getProperty(PRODUCER).getString();
    }

    public JCRPDFFile(Node node, String mimeType, InputStream data) throws RepositoryException, IOException {
        super(node, new BufferedInputStream(data));
        InputStream dataPdf = node.getProperty("jcr:data").getBinary().getStream();
        HashMap<String, String> infoPDF = WorkspaceItemUtil.getPDFInfo(dataPdf);
        this.numberOfPages = Integer.parseInt((String)infoPDF.get("hl-numberOfPages"));
        this.version = (String)infoPDF.get("hl-version");
        this.author = (String)infoPDF.get("Author");
        this.title = (String)infoPDF.get("Title");
        this.producer = (String)infoPDF.get("Producer");
        node.setProperty(NUMBER_OF_PAGES, (long)this.numberOfPages);
        node.setProperty(VERSION, this.version);
        node.setProperty(AUTHOR, this.author);
        node.setProperty(TITLE, this.title);
        node.setProperty(PRODUCER, this.producer);
        dataPdf.close();
    }

    public FolderItemType getFolderItemType() {
        return FolderItemType.EXTERNAL_PDF_FILE;
    }

    public int getNumberOfPages() {
        return this.numberOfPages;
    }

    public String getVersion() {
        return this.version;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getTitle() {
        return this.title;
    }

    public String getProducer() {
        return this.producer;
    }
}

