package org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.gcube;

import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;


import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;

import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItemType;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.Annotation;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items.JCRWorkspaceFolderItem;

public class JCRAnnotation  extends JCRWorkspaceFolderItem implements Annotation {

	private static final String OID				= "hl:oid";
	private static final String ANNOTATIONS		= "hl:annotations";
	private static final String CONTENT			= "jcr:content";
	
	private static final String NT_CONTENT 		= "nthl:annotationItemContet";
	
	private final String oid;
	private final Map<String,String> data;
	
	public JCRAnnotation(JCRWorkspace workspace, Node node) throws RepositoryException, InternalErrorException {
		super(workspace, node);
		
		Node contentNode = node.getNode(CONTENT);
		this.oid = contentNode.getProperty(OID).getString();
		this.data = deserializeAnnotations(contentNode);
	}
	
	public JCRAnnotation(JCRWorkspace workspace, Node node, String name,
			String description, String oid, Map<String, String> data) throws RepositoryException {
		super(workspace, node, name, description);
		
		this.oid = oid;
		this.data = data;
				
		Node contentNode = node.addNode(CONTENT,NT_CONTENT);
		node.setProperty(FOLDER_ITEM_TYPE, FolderItemType.ANNOTATION.toString());
		contentNode.setProperty(OID, oid);
		serializeAnnotations(contentNode, data);

	}
	
	private void serializeAnnotations(Node contentNode, Map<String,String> map) throws RepositoryException {
		Node annotationsNode = contentNode.getNode(ANNOTATIONS);
		for(Entry<String,String> entry : map.entrySet()) {
			annotationsNode.setProperty(entry.getKey(),entry.getValue());
		}
	}
	
	private Map<String,String> deserializeAnnotations(Node contentNode) throws RepositoryException {
		Node annotationsNode = contentNode.getNode(ANNOTATIONS);
		
		Map<String,String> map = new HashMap<String,String>();
		PropertyIterator iterator = annotationsNode.getProperties();
		for(Property p = iterator.nextProperty(); iterator.hasNext();) {
			map.put(p.getName(),p.getValue().getString());
		}
		return map;
	}

	@Override
	public String getURI() {
		return oid;
	}

	@Override
	public Map<String, String> getData() {
		return data;
	}

	@Override
	public FolderItemType getFolderItemType() {
		return FolderItemType.ANNOTATION;
	}

	@Override
	public long getLength() throws InternalErrorException {
		return 0;
	}

	@Override
	public void saveContent(Node node) throws RepositoryException {
		
	}

}
