/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.jcr.home;

import java.io.File;
import java.util.List;
import java.util.Properties;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBEClientLog;
import org.gcube.portlets.user.homelibrary.home.Home;
import org.gcube.portlets.user.homelibrary.home.HomeManager;
import org.gcube.portlets.user.homelibrary.home.User;
import org.gcube.portlets.user.homelibrary.home.data.DataArea;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.Workspace;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.portlets.user.homelibrary.jcr.JCRUser;
import org.gcube.portlets.user.homelibrary.jcr.content.JCRRepository;
import org.gcube.portlets.user.homelibrary.jcr.data.JCRDataArea;
import org.gcube.portlets.user.homelibrary.jcr.workspace.JCRWorkspace;

public class JCRHome
implements Home {
    private final HomeManager homeManager;
    private final JCRUser owner;
    private final File persistenceFolder;
    private final JCRRepository repository;
    private final Workspace workspace;
    private GCUBEClientLog logger;

    public JCRHome(HomeManager homeManager, JCRUser user, File persistenceFolder) throws Exception {
        this.setupLogger();
        this.owner = user;
        this.persistenceFolder = persistenceFolder;
        this.homeManager = homeManager;
        this.repository = new JCRRepository(user);
        this.workspace = new JCRWorkspace(this, this.repository);
    }

    private void setupLogger() {
        this.logger = new GCUBEClientLog((Object)this, new Properties[0]);
    }

    public void setScope(GCUBEScope scope) throws InternalErrorException {
        this.owner.setScope(scope);
        Session session = JCRRepository.getSession();
        try {
            this.repository.setScope(session, scope.toString());
            session.save();
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public HomeManager getHomeManager() {
        return this.homeManager;
    }

    public User getOwner() {
        return this.owner;
    }

    public Workspace getWorkspace() throws WorkspaceFolderNotFoundException, InternalErrorException {
        return this.workspace;
    }

    public DataArea getDataArea() throws InternalErrorException {
        return new JCRDataArea(null);
    }

    public List<String> listScopes() throws InternalErrorException {
        try {
            return this.repository.listScopes();
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }
}

