/**
 * 
 */
package org.gcube.portlets.user.homelibrary.home.workspace;

import java.util.List;

import org.gcube.portlets.user.homelibrary.home.User;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;

/**
 * @author gioia
 *
 */
public interface WorkspaceSharedFolder extends WorkspaceFolder {
	
	/**
	 * @return the list of users
	 * @throws InternalErrorException
	 */
	List<String> getUsers() throws InternalErrorException;
	
	/**
	 * @param user
	 * @throws InsufficientPrivilegesException
	 * @throws InternalErrorException
	 */
	void addUser(String user) throws InsufficientPrivilegesException,
	InternalErrorException;
	
	/**
	 * @return a new {@link WorkspaceFolder}
	 * @throws InternalErrorException
	 */
	WorkspaceFolder unShare() throws InternalErrorException;

	
}
