/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.util.logging;

import java.io.File;
import java.io.IOException;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.gcube.portlets.user.homelibrary.util.logging.MultiLoggerFileAppender;

public class LoggingUtil {
    protected static Appender errorAppender;

    public static synchronized void setupErrorAppender(File loggerFolder, String fileName) {
        File logFile = new File(loggerFolder, fileName);
        try {
            FileAppender faTrace = new FileAppender((Layout)new PatternLayout("%d{yyyy.MM.dd HH:mm:ss} %-5p [%c] [%t] - %m%n"), logFile.getAbsolutePath());
            faTrace.setThreshold((Priority)Level.ERROR);
            faTrace.activateOptions();
            errorAppender = faTrace;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static synchronized void addErrorAppender(Logger logger) {
        if (errorAppender != null) {
            logger.addAppender(errorAppender);
        }
    }

    public static Logger getLogger(File loggerFolder, String loggerName) {
        Logger logger = Logger.getLogger((String)loggerName);
        logger.setLevel(Level.ALL);
        File logFile = new File(loggerFolder, loggerName + ".log");
        try {
            FileAppender faTrace = new FileAppender(LoggingUtil.getSimpleLayout(), logFile.getAbsolutePath());
            faTrace.setThreshold((Priority)Level.ALL);
            faTrace.activateOptions();
            logger.addAppender((Appender)faTrace);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return logger;
    }

    public static Logger getLoggerMultiAppender(File loggerFolder, String fileName, String loggerName) {
        Logger logger = Logger.getLogger((String)loggerName);
        logger.setLevel(Level.ALL);
        File logFile = new File(loggerFolder, fileName + ".log");
        try {
            MultiLoggerFileAppender faTrace = new MultiLoggerFileAppender((Layout)new PatternLayout("[%t] %d{yyyy.MM.dd HH:mm:ss} %-5p - %m%n"), logFile.getAbsolutePath());
            faTrace.setThreshold((Priority)Level.ALL);
            faTrace.activateOptions();
            logger.addAppender((Appender)faTrace);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return logger;
    }

    public static Logger getLoggerThread(File loggerFolder, String loggerName) {
        Logger logger = Logger.getLogger((String)loggerName);
        logger.setLevel(Level.ALL);
        File logFile = new File(loggerFolder, loggerName + ".log");
        try {
            FileAppender faTrace = new FileAppender((Layout)new PatternLayout("%t %d{yyyy.MM.dd HH:mm:ss} %-5p - %m%n"), logFile.getAbsolutePath());
            faTrace.setThreshold((Priority)Level.ALL);
            faTrace.activateOptions();
            logger.addAppender((Appender)faTrace);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return logger;
    }

    public static Logger getSimpleUniqueFileLogger(File loggerFolder, String loggerName) throws IOException {
        Logger logger = LogManager.exists((String)loggerName);
        if (logger == null) {
            logger = Logger.getLogger((String)loggerName);
            logger.setLevel(Level.ALL);
            File loggingFile = new File(loggerFolder, loggerName + ".log");
            FileAppender fa = new FileAppender(LoggingUtil.getSimpleLayout(), loggingFile.getAbsolutePath());
            fa.setThreshold((Priority)Level.ALL);
            logger.addAppender((Appender)fa);
            return logger;
        }
        return logger;
    }

    public static Layout getSimpleLayout() {
        return new PatternLayout("%d{yyyy.MM.dd HH:mm:ss} %-5p - %m%n");
    }

    public static void reconfigureLogging() {
        ConsoleAppender ca = new ConsoleAppender((Layout)new PatternLayout());
        ca.setThreshold((Priority)Level.ERROR);
        ca.activateOptions();
        BasicConfigurator.resetConfiguration();
        BasicConfigurator.configure((Appender)ca);
    }
}

