/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.util.config.easyconf;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gcube.portlets.user.homelibrary.util.config.easyconf.ComponentProperties;
import org.gcube.portlets.user.homelibrary.util.config.easyconf.ConfigurationLoader;
import org.gcube.portlets.user.homelibrary.util.config.easyconf.ConfigurationNotFoundException;

public class ComponentConfiguration {
    private static final Log log = LogFactory.getLog(ComponentConfiguration.class);
    private ComponentProperties properties;
    private String componentName;
    private ConfigurationLoader confManager = new ConfigurationLoader();
    private String companyId;
    private Map confObjectsCache = new HashMap();

    public ComponentConfiguration(String componentName) {
        this(null, componentName);
    }

    public ComponentConfiguration(String companyId, String componentName) {
        this.companyId = companyId;
        this.componentName = componentName;
    }

    public String getComponentName() {
        return this.componentName;
    }

    private ConfigurationLoader getConfigurationManager() {
        return this.confManager;
    }

    public ComponentProperties getProperties() {
        ComponentProperties properties = this.getAvailableProperties();
        if (!properties.hasBaseConfiguration()) {
            String msg = "The base properties file was not found";
            throw new ConfigurationNotFoundException(this.componentName, msg);
        }
        return properties;
    }

    private ComponentProperties getAvailableProperties() {
        if (this.properties != null) {
            return this.properties;
        }
        this.properties = this.getConfigurationManager().readPropertiesConfiguration(this.companyId, this.componentName);
        return this.properties;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ComponentConfiguration)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ComponentConfiguration cconf = (ComponentConfiguration)obj;
        return this.componentName.equals(cconf.getComponentName());
    }

    public int hashCode() {
        return this.componentName.hashCode();
    }
}

