/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.util;

import java.io.PrintStream;
import java.util.List;
import org.apache.log4j.Logger;
import org.gcube.portlets.user.homelibrary.home.User;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItem;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.AquaMapsItem;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ExternalFile;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ExternalImage;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ExternalPDFFile;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ExternalUrl;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.Image;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.PDF;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.Query;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.Report;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ReportTemplate;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.WorkflowReport;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.WorkflowTemplate;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.Document;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.ImageDocument;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.InfoObject;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.Metadata;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.PDFDocument;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.UrlDocument;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.link.DocumentAlternativeLink;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.link.DocumentPartLink;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ts.TimeSeries;
import org.gcube.portlets.user.homelibrary.util.IndentedVisitor;

public class WorkspaceTreeVisitor
extends IndentedVisitor {
    public WorkspaceTreeVisitor() {
    }

    public WorkspaceTreeVisitor(String indentationLevel, String indentationChar, PrintStream os, Logger logger) {
        super(indentationLevel, indentationChar, os, logger);
    }

    public void visitVerbose(WorkspaceFolder folder) throws InternalErrorException {
        this.reset();
        this.visitWorkspaceItem(folder);
    }

    protected void visitWorkspaceItem(WorkspaceItem item) throws InternalErrorException {
        this.println();
        switch (item.getType()) {
            case FOLDER: {
                this.visitWorkspaceFolder((WorkspaceFolder)item);
                break;
            }
            case FOLDER_ITEM: {
                this.visitFolderItem((FolderItem)item);
            }
        }
    }

    protected void visitWorkspaceFolder(WorkspaceFolder folder) throws InternalErrorException {
        this.println("/FOLDER/");
        this.printWorkspaceItem(folder);
        this.indent();
        for (WorkspaceItem child : folder.getChildren()) {
            this.visitWorkspaceItem(child);
        }
        this.outdent();
    }

    public void visitFolderItem(FolderItem item) throws InternalErrorException {
        this.println();
        this.println("/ITEM/");
        switch (item.getFolderItemType()) {
            case EXTERNAL_IMAGE: {
                this.visitExternalImage((ExternalImage)item);
                break;
            }
            case EXTERNAL_FILE: {
                this.visitExternalFile((ExternalFile)item);
                break;
            }
            case EXTERNAL_PDF_FILE: {
                this.visitExternalPDFFile((ExternalPDFFile)item);
                break;
            }
            case EXTERNAL_URL: {
                this.visitExternalURL((ExternalUrl)item);
                break;
            }
            case QUERY: {
                this.visitQuery((Query)item);
                break;
            }
            case REPORT: {
                this.visitReport((Report)item);
                break;
            }
            case REPORT_TEMPLATE: {
                this.visitReportTemplate((ReportTemplate)item);
                break;
            }
            case TIME_SERIES: {
                this.visitTimeSeries((TimeSeries)item);
                break;
            }
            case AQUAMAPS_ITEM: {
                this.visitAquaMapsItem((AquaMapsItem)item);
                break;
            }
            case DOCUMENT: {
                this.visitDocument((Document)item);
                break;
            }
            case PDF_DOCUMENT: {
                this.visitPDFDocument((PDFDocument)item);
                break;
            }
            case IMAGE_DOCUMENT: {
                this.visitImageDocument((ImageDocument)item);
                break;
            }
            case METADATA: {
                this.visitMetadata((Metadata)item);
                break;
            }
            case URL_DOCUMENT: {
                this.visitUrlDocument((UrlDocument)item);
                break;
            }
            case WORKFLOW_REPORT: {
                this.visitWorkflowReport((WorkflowReport)item);
                break;
            }
            case WORKFLOW_TEMPLATE: {
                this.visitWorkflowTemplate((WorkflowTemplate)item);
                break;
            }
            default: {
                this.printWorkspaceItem(item);
                this.println("UNSUPPORTED TYPE: " + (Object)((Object)item.getFolderItemType()));
            }
        }
    }

    protected void visitImage(Image img) throws InternalErrorException {
        this.println("MimeType " + img.getMimeType());
        this.println("Width " + img.getWidth());
        this.println("Height " + img.getHeight());
        this.println("Length " + img.getLength());
    }

    protected void visitPDF(PDF pdf) throws InternalErrorException {
        this.println("Number Of Pages " + pdf.getNumberOfPages());
        this.println("Version " + pdf.getVersion());
        this.println("Author " + pdf.getAuthor());
        this.println("Title " + pdf.getTitle());
        this.println("Producer " + pdf.getProducer());
    }

    protected void visitExternalImage(ExternalImage img) throws InternalErrorException {
        this.println("[ExternalImage]");
        this.printFolderItem(img);
        this.visitImage(img);
    }

    protected void visitExternalFile(ExternalFile file) throws InternalErrorException {
        this.println("[ExternalFile]");
        this.printFolderItem(file);
        this.println("MimeType " + file.getMimeType());
        this.println("Length " + file.getLength());
    }

    protected void visitAquaMapsItem(AquaMapsItem aquamapsitem) throws InternalErrorException {
        this.println("[AquaMapsItem]");
        this.printFolderItem(aquamapsitem);
        this.println("Author " + aquamapsitem.getAuthor());
        this.println("MapName " + aquamapsitem.getMapName());
        this.println("NumberOfSpecies " + aquamapsitem.getNumberOfSpecies());
        this.println("BoundingBox " + aquamapsitem.getBoundingBox());
        this.println("PsoThreshold " + aquamapsitem.getPsoThreshold());
        this.println("NumberOfGeneratedImages " + aquamapsitem.getNumberOfGeneratedImages());
        this.println("images:");
        this.indent();
        for (Image image : aquamapsitem.getImages()) {
            this.visitImageH(image);
        }
        this.outdent();
        this.println("Length " + aquamapsitem.getLength());
    }

    protected void visitImageH(Image img) throws InternalErrorException {
        this.println("MimeType: " + img.getMimeType() + ", Width: " + img.getWidth() + ", Height: " + img.getHeight() + ", Length: " + img.getLength());
    }

    protected void visitTimeSeries(TimeSeries timeseries) throws InternalErrorException {
        this.println("[TimeSeries]");
        this.printFolderItem(timeseries);
        this.println("id " + timeseries.getTimeSeriesInfo().getId());
        this.println("creationDate " + timeseries.getTimeSeriesInfo().getCreationDate());
        this.println("creator " + timeseries.getTimeSeriesInfo().getCreator());
        this.println("description " + timeseries.getTimeSeriesInfo().getDescription());
        this.println("dimension " + timeseries.getTimeSeriesInfo().getDimension());
        this.println("publisher " + timeseries.getTimeSeriesInfo().getPublisher());
        this.println("rights " + timeseries.getTimeSeriesInfo().getRights());
        this.println("sourceId " + timeseries.getTimeSeriesInfo().getSourceId());
        this.println("sourceName " + timeseries.getTimeSeriesInfo().getSourceName());
        this.println("title " + timeseries.getTimeSeriesInfo().getTitle());
        this.println("Length " + timeseries.getLength());
        this.println("NumberOfColumns " + timeseries.getNumberOfColumns());
        this.println("HeadersLabel " + timeseries.getHeaderLabels());
    }

    protected void visitExternalPDFFile(ExternalPDFFile pdf) throws InternalErrorException {
        this.println("[ExternalPDFFile]");
        this.printFolderItem(pdf);
        this.println("MimeType " + pdf.getMimeType());
        this.visitPDF(pdf);
        this.println("Length " + pdf.getLength());
    }

    protected void visitExternalURL(ExternalUrl url) throws InternalErrorException {
        this.println("[ExternalUrl]");
        this.printFolderItem(url);
        this.println("Url " + url.getUrl());
        this.println("Length " + url.getLength());
    }

    protected void visitQuery(Query query) throws InternalErrorException {
        this.println("[Query]");
        this.printFolderItem(query);
        this.println("Query " + query.getQuery());
        this.println("Query type " + (Object)((Object)query.getQueryType()));
        this.println("Length " + query.getLength());
    }

    protected void visitReport(Report report) throws InternalErrorException {
        this.println("[Report]");
        this.printFolderItem(report);
        this.println("Author " + report.getAuthor());
        this.println("LastEditBy " + report.getLastEditBy());
        this.println("TemplateName " + report.getTemplateName());
        this.println("NumberOfSections " + report.getNumberOfSections());
        this.println("Created " + this.sdf.format(report.getCreated().getTime()));
        this.println("LastEdit " + this.sdf.format(report.getLastEdit().getTime()));
        this.println("Status " + report.getStatus());
        this.println("Length " + report.getLength());
    }

    protected void visitReportTemplate(ReportTemplate reportTemplate) throws InternalErrorException {
        this.println("[ReportTemplate]");
        this.printFolderItem(reportTemplate);
        this.println("Author " + reportTemplate.getAuthor());
        this.println("LastEditBy " + reportTemplate.getLastEditBy());
        this.println("NumberOfSections " + reportTemplate.getNumberOfSections());
        this.println("Created " + this.sdf.format(reportTemplate.getCreated().getTime()));
        this.println("LastEdit " + this.sdf.format(reportTemplate.getLastEdit().getTime()));
        this.println("Status " + reportTemplate.getStatus());
        this.println("Length " + reportTemplate.getLength());
    }

    protected void visitWorkflowReport(WorkflowReport report) throws InternalErrorException {
        this.println("[WorkflowReport]");
        this.printFolderItem(report);
    }

    protected void visitWorkflowTemplate(WorkflowTemplate template) throws InternalErrorException {
        this.println("[WorkflowTemplate]");
        this.printFolderItem(template);
    }

    protected void printInfoObject(InfoObject infoObject) throws InternalErrorException {
        this.println("OID: " + infoObject.getURI());
    }

    protected void visitDocument(Document document) throws InternalErrorException {
        this.println("{Document}");
        this.printInfoObject(document);
        this.println("N. Metadata " + document.getMetadata().size());
        this.println("N. Annotations " + document.getAnnotation().size());
        this.println("MimeType " + document.getMimeType());
        this.visitAlternativeLinks(document.getAlternatives());
        this.visitPartLinks(document.getParts());
    }

    protected void visitPDFDocument(PDFDocument document) throws InternalErrorException {
        this.println("{PDFDocument}");
        this.printInfoObject(document);
        this.println("N. Metadata " + document.getMetadata().size());
        this.println("N. Annotations " + document.getAnnotation().size());
        this.println("MimeType " + document.getMimeType());
        this.visitPDF(document);
        this.visitAlternativeLinks(document.getAlternatives());
        this.visitPartLinks(document.getParts());
    }

    protected void visitImageDocument(ImageDocument document) throws InternalErrorException {
        this.println("{ImageDocument}");
        this.printInfoObject(document);
        this.println("N. Metadata " + document.getMetadata().size());
        this.println("N. Annotations " + document.getAnnotation().size());
        this.visitImage(document);
        this.visitAlternativeLinks(document.getAlternatives());
        this.visitPartLinks(document.getParts());
    }

    protected void visitUrlDocument(UrlDocument document) throws InternalErrorException {
        this.println("{UrlDocument}");
        this.printInfoObject(document);
        this.println("Url: " + document.getUrl());
        this.println("MimeType " + document.getMimeType());
        this.visitAlternativeLinks(document.getAlternatives());
        this.visitPartLinks(document.getParts());
    }

    protected void visitAlternativeLinks(List<DocumentAlternativeLink> alternatives) throws InternalErrorException {
        this.println("{Alternatives}");
        for (DocumentAlternativeLink alternative : alternatives) {
            this.visitAlternativeLink(alternative);
        }
    }

    protected void visitAlternativeLink(DocumentAlternativeLink alternative) throws InternalErrorException {
        this.println("OID: " + alternative.getURI() + " name: " + alternative.getName() + " mimeType: " + alternative.getMimeType());
    }

    protected void visitPartLinks(List<DocumentPartLink> parts) throws InternalErrorException {
        this.println("{Parts}");
        for (DocumentPartLink part : parts) {
            this.visitPartLink(part);
        }
    }

    protected void visitPartLink(DocumentPartLink part) throws InternalErrorException {
        this.println("OID: " + part.getURI() + " name: " + part.getName() + " mimeType: " + part.getMimeType());
    }

    protected void visitMetadata(Metadata metadata) throws InternalErrorException {
        this.println("{Metadata}");
        this.printInfoObject(metadata);
        this.println("Schema " + metadata.getSchema());
    }

    protected void printWorkspaceItem(WorkspaceItem item) throws InternalErrorException {
        this.println("ID: " + item.getId());
        this.println("NAME: " + item.getName());
        this.println("DESCRIPTION: " + item.getDescription());
        this.println("CREATION TIME: " + this.sdf.format(item.getCreationTime().getTime()));
        this.println("OWNER: " + item.getOwner());
    }

    protected void printFolderItem(FolderItem item) throws InternalErrorException {
        this.printWorkspaceItem(item);
        this.println("WorkflowId: " + item.getWorkflowId());
        this.println("WorkflowStatus: " + item.getWorkflowStatus());
        this.println("WorkflowData (length): " + (item.getWorkflowData() == null ? "null" : Integer.valueOf(item.getWorkflowData().length())));
    }

    protected void visitUser(User user) throws InternalErrorException {
        this.println("ID: " + user.getId());
        this.println("LOGIN: " + user.getPortalLogin());
    }

    public void visitSimple(WorkspaceItem item) throws InternalErrorException {
        this.reset();
        this.visitItem(item);
    }

    protected void visitItem(WorkspaceItem item) throws InternalErrorException {
        switch (item.getType()) {
            case FOLDER: {
                this.println("/[" + item.getName() + "]");
                break;
            }
            case FOLDER_ITEM: {
                this.println("/" + item.getName());
            }
        }
        this.indent();
        for (WorkspaceItem workspaceItem : item.getChildren()) {
            this.visitItem(workspaceItem);
        }
        this.outdent();
    }
}

