/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.jcr.data;

import java.util.List;
import org.apache.log4j.Logger;
import org.gcube.portlets.user.homelibrary.home.data.DataArea;
import org.gcube.portlets.user.homelibrary.home.data.application.ApplicationDataArea;
import org.gcube.portlets.user.homelibrary.home.data.fs.DataFolder;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.jcr.content.JCRRepository;
import org.gcube.portlets.user.homelibrary.jcr.data.application.JCRApplicationDataArea;

public class JCRDataArea
implements DataArea {
    private JCRRepository contentManager;
    private Logger logger = Logger.getLogger((String)JCRDataArea.class.getName());
    private static final String DATA_FOLDER = "ApplicationData";

    public JCRDataArea(JCRRepository contentManager) {
        this.contentManager = contentManager;
    }

    public ApplicationDataArea getApplicationDataArea(String applicationName) throws InternalErrorException {
        if (applicationName == null) {
            this.logger.error((Object)"application name parameter null");
            throw new IllegalArgumentException("The applicationName can't be null");
        }
        return new JCRApplicationDataArea(applicationName, this.contentManager);
    }

    public ApplicationDataArea getApplicationDataArea(Class<?> applicationClass) throws InternalErrorException {
        this.logger.info((Object)("getApplicationDataArea applicationClass: " + applicationClass));
        if (applicationClass == null) {
            this.logger.error((Object)"application class parameter null");
            throw new IllegalArgumentException("The applicationClass can't be null");
        }
        String applicationName = applicationClass.getCanonicalName();
        this.logger.trace((Object)("Application name: " + applicationName));
        return this.getApplicationDataArea(applicationName);
    }

    public List<String> listApplicationNames() throws InternalErrorException {
        return null;
    }

    public DataFolder getDataFolderRoot() throws InternalErrorException {
        return null;
    }

    public DataFolder getRelativeFolder(String relPath) throws InternalErrorException {
        return null;
    }
}

