/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.jcr.content;

import java.util.LinkedList;
import java.util.List;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.Value;
import org.apache.jackrabbit.rmi.repository.URLRemoteRepository;
import org.apache.log4j.Logger;
import org.gcube.portlets.user.homelibrary.home.User;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;

public class JCRRepository {
    public static final String PATH_SEPARATOR = "/";
    public static final String ROOT_WEBDAV = "/repository/default/";
    private static final String HL_NAMESPACE = "";
    private static final String DOWNLOADS = "Downloads";
    private static final String HOME_FOLDER = "Home";
    private static final String SMART_FOLDER = "Folders";
    private static final String GCUBE_FOLDER = "GCube";
    private static final String IN_BOX_FOLDER = "InBox";
    private static final String OUT_BOX_FOLDER = "OutBox";
    private static final String SHARED_FOLDER = "Share";
    private static final String NT_FOLDER = "nt:folder";
    private static final String NT_HOME = "nthl:home";
    private static final String NT_ROOT_ITEM_SENT = "nthl:rootItemSentRequest";
    private static final String NT_ROOT_FOLDER_BULK_CREATOR = "nthl:rootFolderBulkCreator";
    private static final String SCOPES = "hl:scopes";
    private static final String nameResource = "HomeLibraryRepository";
    private static Repository repository;
    private static String gcubeRootId;
    private static String sharedRootId;
    private String userHomeId;
    private String smartFoldersId;
    private String downloadsId;
    private String inBoxId;
    private String outBoxId;
    private static String user;
    private static String pass;
    private static String url;
    private static Logger logger;

    private static synchronized void setRepository() throws InternalErrorException {
        if (repository != null) {
            return;
        }
        try {
            user = "admin";
            pass = "admin";
            url = "http://127.0.0.1:8080";
            repository = new URLRemoteRepository(url + "/rmi");
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public static void addUserToJCRUserManager(String userId, String userHome) {
    }

    public static Session getSession() throws InternalErrorException {
        JCRRepository.setRepository();
        Repository repository = JCRRepository.repository;
        synchronized (repository) {
            try {
                Session session = JCRRepository.repository.login((Credentials)new SimpleCredentials(user, pass.toCharArray()));
                return session;
            }
            catch (Exception e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
    }

    public static synchronized void Initialize() throws InternalErrorException {
        logger.debug((Object)"Initialize repository");
        Session session = JCRRepository.getSession();
        try {
            Node root = session.getRootNode();
            if (!JCRRepository.exist(root, HOME_FOLDER)) {
                root.addNode(HOME_FOLDER, NT_FOLDER);
            }
            if (!JCRRepository.exist(root, GCUBE_FOLDER)) {
                root.addNode(GCUBE_FOLDER, NT_FOLDER);
            }
            if (!JCRRepository.exist(root, SHARED_FOLDER)) {
                root.addNode(SHARED_FOLDER, NT_FOLDER);
            }
            sharedRootId = root.getNode(SHARED_FOLDER).getIdentifier();
            gcubeRootId = root.getNode(GCUBE_FOLDER).getIdentifier();
            session.save();
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public JCRRepository(User user) throws InternalErrorException {
        Session session = JCRRepository.getSession();
        String userHomePath = null;
        try {
            Node root = session.getRootNode();
            Node home = root.getNode(HOME_FOLDER);
            Node userHome = !JCRRepository.exist(home, HL_NAMESPACE + user.getPortalLogin()) ? home.addNode(HL_NAMESPACE + user.getPortalLogin(), NT_HOME) : home.getNode(HL_NAMESPACE + user.getPortalLogin());
            session.save();
            this.userHomeId = userHome.getIdentifier();
            JCRRepository.addUserToJCRUserManager(user.getPortalLogin(), userHome.getPath());
            userHomePath = userHome.getPath();
            Node smartFolders = !JCRRepository.exist(userHome, SMART_FOLDER) ? userHome.addNode(SMART_FOLDER, NT_FOLDER) : userHome.getNode(SMART_FOLDER);
            Node inBoxNode = !JCRRepository.exist(userHome, IN_BOX_FOLDER) ? userHome.addNode(IN_BOX_FOLDER, NT_ROOT_ITEM_SENT) : userHome.getNode(IN_BOX_FOLDER);
            Node outBoxNode = !JCRRepository.exist(userHome, OUT_BOX_FOLDER) ? userHome.addNode(OUT_BOX_FOLDER, NT_ROOT_ITEM_SENT) : userHome.getNode(OUT_BOX_FOLDER);
            Node downloads = null;
            downloads = !JCRRepository.exist(userHome, DOWNLOADS) ? userHome.addNode(DOWNLOADS, NT_ROOT_FOLDER_BULK_CREATOR) : userHome.getNode(DOWNLOADS);
            session.save();
            this.smartFoldersId = smartFolders.getIdentifier();
            this.inBoxId = inBoxNode.getIdentifier();
            this.outBoxId = outBoxNode.getIdentifier();
            this.downloadsId = downloads.getIdentifier();
        }
        catch (RepositoryException e) {
            logger.error((Object)"Repository not instantiated", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public static void removeUser(User user) throws Exception {
        Session session = JCRRepository.getSession();
        Node node = session.getRootNode().getNode(HOME_FOLDER).getNode(user.getPortalLogin());
        node.remove();
        session.save();
    }

    public static void setACL(String portalLogin, String userHome) throws InternalErrorException {
    }

    public void setScope(Session session, String scope) throws RepositoryException {
        Property scopes;
        Node userHome = this.getUserHome(session);
        try {
            scopes = userHome.getProperty(SCOPES);
        }
        catch (PathNotFoundException e) {
            String[] values = new String[]{scope};
            userHome.setProperty(SCOPES, values);
            return;
        }
        for (Value value : scopes.getValues()) {
            if (!value.getString().equals(scope)) continue;
            return;
        }
        String[] newScopes = new String[scopes.getValues().length + 1];
        newScopes[0] = scope;
        for (int i = 1; i < newScopes.length; ++i) {
            newScopes[i] = scopes.getValues()[i - 1].getString();
        }
        userHome.setProperty(SCOPES, newScopes);
    }

    private static boolean exist(Node parent, String childName) throws RepositoryException {
        try {
            parent.getNode(childName);
        }
        catch (PathNotFoundException e) {
            return false;
        }
        return true;
    }

    public boolean existChild(Node father, String child) {
        try {
            father.getNode(child);
        }
        catch (RepositoryException e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> listScopes() throws RepositoryException, InternalErrorException {
        LinkedList<String> list = new LinkedList<String>();
        Session session = JCRRepository.getSession();
        try {
            Node userHome = session.getNodeByIdentifier(this.userHomeId);
            Property scopes = userHome.getProperty(SCOPES);
            for (Value value : scopes.getValues()) {
                list.add(value.getString());
            }
            LinkedList<String> linkedList = list;
            return linkedList;
        }
        catch (PathNotFoundException e) {
            LinkedList<String> linkedList = new LinkedList<String>();
            return linkedList;
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    public static Node getGCubeRoot(Session session) throws RepositoryException {
        return session.getNodeByIdentifier(gcubeRootId);
    }

    public static Node getSharedRoot(Session session) throws RepositoryException {
        return session.getNodeByIdentifier(sharedRootId);
    }

    public Node getUserHome(Session session) throws RepositoryException {
        return session.getNodeByIdentifier(this.userHomeId);
    }

    public Node getRootSmartFolders(Session session) throws RepositoryException {
        return session.getNodeByIdentifier(this.smartFoldersId);
    }

    public Node getOwnInBoxFolder(Session session) throws RepositoryException {
        return session.getNodeByIdentifier(this.inBoxId);
    }

    public Node getRootFolderBulkCreators(Session session) throws RepositoryException {
        return session.getNodeByIdentifier(this.downloadsId);
    }

    public Node getOutBoxFolder(Session session) throws RepositoryException {
        return session.getNodeByIdentifier(this.outBoxId);
    }

    public Node getInBoxFolder(Session session, String user) throws RepositoryException, InternalErrorException {
        return session.getRootNode().getNode("Home/" + user + PATH_SEPARATOR + IN_BOX_FOLDER);
    }

    public String getUserHomeUrl(String portalLogin) {
        return url + ROOT_WEBDAV + HOME_FOLDER + PATH_SEPARATOR + portalLogin;
    }

    static {
        logger = Logger.getLogger((String)JCRRepository.class.getName());
    }
}

