package org.gcube.portlets.user.homelibrary.jcr.workspace.folder.items;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;

import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItemType;
import org.gcube.portlets.user.homelibrary.jcr.content.JCRRepository;
import org.gcube.portlets.user.homelibrary.jcr.workspace.util.WorkspaceItemUtil;

public class JCRPDFFile extends JCRFile {
	
	private static final String NUMBER_OF_PAGES = "hl:numberOfPages";
	private static final String VERSION = "hl:version";
	private static final String AUTHOR = "hl:author";
	private static final String TITLE = "hl:title";
	private static final String PRODUCER = "hl:producer";
	

	
	public JCRPDFFile(Node node) throws RepositoryException   {
		super(node);
	}
	
	public JCRPDFFile(Node node, String mimeType,InputStream data) throws RepositoryException,
	IOException {
		super(node,new BufferedInputStream(data));
		
		InputStream dataPdf =  node.getProperty(DATA).getBinary().getStream();
		Map<String,String> infoPDF = WorkspaceItemUtil.getPDFInfo(dataPdf);
		int numberOfPages = Integer.parseInt(infoPDF.get(WorkspaceItemUtil.NUMBER_OF_PAGES));
		String version = infoPDF.get(WorkspaceItemUtil.VERSION);
		String author = infoPDF.get(WorkspaceItemUtil.AUTHOR);
		String title = infoPDF.get(WorkspaceItemUtil.TITLE);
		String producer = infoPDF.get(WorkspaceItemUtil.PRODUCER);
		
		node.setProperty(NUMBER_OF_PAGES, numberOfPages);
		node.setProperty(VERSION, version);
		node.setProperty(AUTHOR, author);
		node.setProperty(TITLE, title);
		node.setProperty(PRODUCER, producer);

		dataPdf.close();
	}
	
	public FolderItemType getFolderItemType() {
		return FolderItemType.EXTERNAL_PDF_FILE;	
	}

	public int getNumberOfPages() {	
		
		Session session = null;
		try {
			session = JCRRepository.getSession();
			Node node = session.getNodeByIdentifier(nodeId);
			return (int) node.getProperty(NUMBER_OF_PAGES).getLong();
		} catch (Exception e) {
			throw new RuntimeException(e) ;
		} finally {
			session.logout();
		}	
	}

	public String getVersion() {
		
		Session session = null;
		try {
			session = JCRRepository.getSession();
			Node node = session.getNodeByIdentifier(nodeId);
			return node.getProperty(VERSION).getString();
		} catch (Exception e) {
			throw new RuntimeException(e) ;
		} finally {
			session.logout();
		}	
	}

	public String getAuthor() {
		
		Session session = null;
		try {
			session = JCRRepository.getSession();
			Node node = session.getNodeByIdentifier(nodeId);
			return node.getProperty(AUTHOR).getString();
		} catch (Exception e) {
			throw new RuntimeException(e) ;
		} finally {
			session.logout();
		}	
		
	}

	public String getTitle() {
		
		Session session = null;
		try {
			session = JCRRepository.getSession();
			Node node = session.getNodeByIdentifier(nodeId);
			return node.getProperty(TITLE).getString();
		} catch (Exception e) {
			throw new RuntimeException(e) ;
		} finally {
			session.logout();
		}	
		
	}

	public String getProducer() {
		
		Session session = null;
		try {
			session = JCRRepository.getSession();
			Node node = session.getNodeByIdentifier(nodeId);
			return  node.getProperty(PRODUCER).getString();
		} catch (Exception e) {
			throw new RuntimeException(e) ;
		} finally {
			session.logout();
		}	
	}

}
