package org.gcube.portlets.user.guidedtour.server;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.gcube.portal.custom.communitymanager.OrganizationsUtil;
import org.gcube.portal.custom.scopemanager.scopehelper.ScopeHelper;

import com.liferay.portal.model.User;
import com.liferay.portlet.expando.model.ExpandoTableConstants;
import com.liferay.portlet.expando.service.ExpandoValueLocalServiceUtil;

/**
 * Servlet implementation class ShowTourCheckServlet
 */

@SuppressWarnings("serial")
public class ShowTourCheckServlet extends HttpServlet {

	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

		String toReturn = "";
		String className = request.getParameter("className");

		User currUser;
		String username = null;
		boolean show = false;
		if (request.getSession().getAttribute(ScopeHelper.USERNAME_ATTRIBUTE) == null) { //if running into eclipse always shows the popup	
			show = true; 
		}
		else {
			username = (String) request.getSession().getAttribute(ScopeHelper.USERNAME_ATTRIBUTE);
			String attrToCheck = TourServiceImpl.getUniqueIdentifier(username, className);
			
			try {
				currUser = OrganizationsUtil.validateUser(username);

				show =  (ExpandoValueLocalServiceUtil.getValue(
						OrganizationsUtil.getCompany().getCompanyId(), 
						User.class.getName(),  
						ExpandoTableConstants.DEFAULT_TABLE_NAME, attrToCheck, currUser.getUserId()) == null);

			} catch (Exception e) { 
				e.printStackTrace();
			}
		}
		System.out.println("CheckServlet: user=" + request.getSession().getAttribute(ScopeHelper.USERNAME_ATTRIBUTE) + " toShow="+show);
		toReturn += show;
		response.setContentType("text/plain");  
		response.setCharacterEncoding("UTF-8"); 
		response.getWriter().write(toReturn); 
	}


	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		// TODO Auto-generated method stub

	}
}