package org.gcube.portlets.user.gisviewer.client;


import java.util.List;

import org.gcube.portlets.user.gisviewer.client.commons.beans.DataResult;
import org.gcube.portlets.user.gisviewer.client.commons.beans.GisViewerBaseLayerInterface;
import org.gcube.portlets.user.gisviewer.client.commons.beans.LayerItem;
import org.gcube.portlets.user.gisviewer.client.commons.beans.LayerItemsResult;
import org.gcube.portlets.user.gisviewer.client.commons.beans.Property;
import org.gcube.portlets.user.gisviewer.client.commons.beans.TransectParameters;
import org.gcube.portlets.user.gisviewer.client.commons.beans.WfsTable;
import org.gcube.portlets.user.gisviewer.client.commons.beans.WmsRequest;

import com.google.gwt.user.client.rpc.AsyncCallback;

/**
 * The async counterpart of <code>GreetingService</code>.
 */
public interface GisViewerServiceAsync {

	public void getDataResult(List<String> urls, AsyncCallback<List<DataResult>> callback);

	public void getGroupsInfo(String groupName, AsyncCallback<LayerItemsResult> callback);

	public void getLayersInfo(List<String> layersName, AsyncCallback<LayerItemsResult> callback);

	public void getLayersInfoByLayerItems(List<LayerItem> layerItems, AsyncCallback<LayerItemsResult> asyncCallback);

	void getTransectParameters(AsyncCallback<TransectParameters> callback);

	public void getDataResult(List<LayerItem> layerItems, String bbox, AsyncCallback<List<WfsTable>> asyncCallback);

	void getListProperty(String geoserverUrl, LayerItem layer,
			AsyncCallback<List<Property>> callback);

	void getDataResult(List<LayerItem> layerItems, String bbox,
			int maxWFSFeature, AsyncCallback<List<WfsTable>> callback);

	void getBaseLayersToGisViewer(AsyncCallback<List<? extends GisViewerBaseLayerInterface>> callback);

	void parseWmsRequest(WmsRequest request, AsyncCallback<String> callback);

//	public void getLayersInfoByLayerConfigurations(List<LayerConfiguration> layerConfigurations, AsyncCallback<LayerItemsResult> asyncCallback);

}
