package org.gcube.portlets.user.gisviewer.server.baselayer;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import org.apache.log4j.Logger;

public class BaseLayerPropertyReader {

	protected static final String BASE_LAYER_FILE = "baselayer.properties";
	protected static final String BASELAYER_WMS_SERVER = "BASELAYER_WMS_SERVER";
	protected static final String BASELAYER_LAYERS = "BASELAYER_LAYERS";
	protected static final String BASELAYER_TITLE = "BASELAYER_TITLE";

	private String layerName;
	private String layerTitle;
	private String layerWmsUrl;

	public static Logger logger = Logger
			.getLogger(BaseLayerPropertyReader.class);

	public BaseLayerPropertyReader() throws PropertyFileNotFoundException {

		Properties prop = new Properties();

		try {

			InputStream in = (InputStream) BaseLayerPropertyReader.class
					.getResourceAsStream(BASE_LAYER_FILE);

			// load a properties file
			prop.load(in);

			// get the property value - the application Id
			this.layerWmsUrl = prop.getProperty(BASELAYER_WMS_SERVER);

			this.layerTitle = prop.getProperty(BASELAYER_TITLE);
			this.layerName = prop.getProperty(BASELAYER_LAYERS);

		} catch (IOException e) {
			logger.error("An error occurred on read property file " + e, e);
			throw new PropertyFileNotFoundException(
					"An error occurred on read property file " + e);
		}
	}

	public static String getBaseLayerFile() {
		return BASE_LAYER_FILE;
	}

	public static String getBaselayerWmsServer() {
		return BASELAYER_WMS_SERVER;
	}

	public static String getBaselayerLayers() {
		return BASELAYER_LAYERS;
	}

	public static String getBaselayerTitle() {
		return BASELAYER_TITLE;
	}

	public String getLayerName() {
		return layerName;
	}

	public String getLayerTitle() {
		return layerTitle;
	}

	public String getLayerWmsUrl() {
		return layerWmsUrl;
	}

	public void setLayerName(String layerName) {
		this.layerName = layerName;
	}

	public void setLayerTitle(String layerTitle) {
		this.layerTitle = layerTitle;
	}

	public void setLayerWmsUrl(String layerWmsUrl) {
		this.layerWmsUrl = layerWmsUrl;
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("BaseLayerPropertyReader [layerName=");
		builder.append(layerName);
		builder.append(", layerTitle=");
		builder.append(layerTitle);
		builder.append(", layerWmsUrl=");
		builder.append(layerWmsUrl);
		builder.append("]");
		return builder.toString();
	}

	public static void main(String[] args) {
		BaseLayerPropertyReader gr;
		try {
			gr = new BaseLayerPropertyReader();
			System.out.println(gr);
		} catch (PropertyFileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}

}
