package org.gcube.portlets.user.gisviewer.client.layerspanel;

import org.gcube.portlets.user.gisviewer.client.commons.beans.LayerItem;

public interface LayersPanelHandler {
	
	public void activateTransect(LayerItem layerItem, String table, String field);
	
	public void openBrowserLayerImage(LayerItem layerItem, String format, boolean isWMS);
	public void saveLayerImage(LayerItem layerItem, String format, boolean isWMS);

	public void showLegend(LayerItem layerItem, int left, int top);
	public void changeLegend(LayerItem layerItem, String style);

	public void setOpacityLayer(LayerItem layerItem, double value);

	public void showLayer(LayerItem layerItem);
	public void hideLayer(LayerItem layerItem);
	
	public boolean showFilterQuery(LayerItem layerItem, int left, int top);
	public void removeFilterQuery(LayerItem layerItem);

	public void updateLayersOrder();
	
	public boolean isSaveSupported();

	public void deactivateTransect(LayerItem layerItem);

	/**
	 * @param layerItem
	 */
	public void removeLayer(LayerItem layerItem);

}
