package org.gcube.portlets.user.gisviewer.client.layerspanel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.gcube.portlets.user.gisviewer.client.Constants;
import org.gcube.portlets.user.gisviewer.client.commons.beans.LayerItem;

import com.extjs.gxt.ui.client.core.El;
import com.extjs.gxt.ui.client.dnd.DragSource;
import com.extjs.gxt.ui.client.dnd.DropTarget;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.DNDEvent;
import com.extjs.gxt.ui.client.event.DomEvent;
import com.extjs.gxt.ui.client.event.EventType;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Info;
import com.extjs.gxt.ui.client.widget.Label;
import com.extjs.gxt.ui.client.widget.VerticalPanel;
import com.extjs.gxt.ui.client.widget.layout.TableData;


public class LayersPanel extends VerticalPanel {
	List<LayerItem> layerItems = new ArrayList<LayerItem>();
	Map<LayerItem, LayerToolsPanel> map = new HashMap<LayerItem, LayerToolsPanel>();
	static final int spacing = 3;
	private LayersPanelHandler layersPanelHandler;
	private boolean isEmpty = true;
	private LayerItem layerItemTransect;
	private boolean firstTimeOver = true;

	public LayersPanel(LayersPanelHandler layersPanelHandler) {
		super();
		this.layersPanelHandler = layersPanelHandler;

		this.setSpacing(spacing);

		if (Constants.layersDragEnabled) {
			DropTarget target = new LayersDropTarget(this);
			target.setGroup("layersPanel");
		}

		setTableWidth("100%");

		this.addListener(Events.OnMouseOver, new Listener<DomEvent>(){
			@Override
			public void handleEvent(DomEvent be) {
				if (firstTimeOver) {
					Info.display("Layers Panel", "Now it's possible to move layers to ordering change.");
					firstTimeOver = false;
				}
			}
		});
	}

	public void showEmptyMessage() {
		this.removeAll();
		Label l = new Label("No layers");
		l.setStyleAttribute("font-size", "12px");
		this.add(l);
		this.layout();
	}

	public void addLayer(LayerItem layerItem, boolean toTop) {
		// add layer item object
		if (toTop)
			this.layerItems.add(0, layerItem);
		else
			this.layerItems.add(layerItem);

		final LayerToolsPanel layerToolsPanel = new LayerToolsPanel(layerItem, layersPanelHandler);

		if (Constants.layersDragEnabled) {
			DragSource source = new DragSource(layerToolsPanel) {
				@Override
				protected void onDragStart(DNDEvent event) {
					if (event.getClientY()<layerToolsPanel.getAbsoluteTop()+20) {
						event.setData(layerToolsPanel);
						event.getStatus().update(El.fly(layerToolsPanel.getElement()).cloneNode(true));
					} else
						event.setData(null);
				}
			};
			source.setGroup("layersPanel");
		}

		if (isEmpty) {
			this.removeAll();
			isEmpty = false;
		}
		map.put(layerItem, layerToolsPanel);

		if (toTop)
			this.insert(layerToolsPanel, 0, new TableData("100%", ""));
		else
			this.add(layerToolsPanel, new TableData("100%", ""));
	}

	public void addLayerItems(List<LayerItem> layers, boolean toTop) {
		for (LayerItem layerItem : layers)
			this.addLayer(layerItem, toTop);
		this.layout();
	}

	public List<LayerItem> getVisibleLayers() {
		List<LayerItem> layerItems = new ArrayList<LayerItem>();
		for (LayerItem layerItem : this.layerItems)
			if (layerItem.isVisible())
				layerItems.add(layerItem);
		return layerItems;
	}

	public void updateLayersOrder() {
		//		System.out.println("LAYERS ORDER");
		int i=0;
		for (Component c : this.getItems()) {
			LayerToolsPanel layerToolPanel = (LayerToolsPanel)c;
			LayerItem layerItem = layerToolPanel.getLayerItem();
			layerItem.setOrder(++i);
			//			System.out.println(""+(++i)+") " + layerItem.getLayer() + " ("+layerItem.getId()+")");			
		}
		this.layersPanelHandler.updateLayersOrder();
	}

	public void setCqlTip(LayerItem layerItem, boolean show) {
		LayerToolsPanel layerToolsPanel = map.get(layerItem);
		layerToolsPanel.setCqlTip(show);
	}

	public void setTransectTip(LayerItem layerItem, boolean show) {
		// delete previous transet tip
		if (show && this.layerItemTransect!=null) {
			LayerToolsPanel layerToolsPanelTransect = map.get(layerItemTransect);
			if (layerToolsPanelTransect!=null)
				layerToolsPanelTransect.setTransectTip(false);
		}

		LayerToolsPanel layerToolsPanel = map.get(layerItem);
		if (layerToolsPanel!=null) {
			layerToolsPanel.setTransectTip(show);
			this.layerItemTransect = show ? layerItem : null;
		}
	}

	/**
	 * @param layerItem
	 */
	public void removeLayer(LayerItem layerItem) {
		LayerToolsPanel layertoolsPanel = map.get(layerItem);
		map.remove(layerItem);
		layerItems.remove(layerItem);
		this.remove(layertoolsPanel);
		this.layout();
	}

	/**
	 * @return
	 */
	public List<LayerItem> getLayerItems() {
		return this.layerItems;
	}
	
	public void setLayerVisible(LayerItem layerItem, boolean isVisible) {
		LayerToolsPanel layertoolsPanel = map.get(layerItem);
		if (layertoolsPanel!=null)
			layertoolsPanel.setCheckVisible(isVisible);
	}
}

