/**
 * 
 */
package org.gcube.portlets.user.gisviewerapp.client;

import java.util.logging.Level;

import org.gcube.portlets.user.gisviewer.client.Constants;
import org.gcube.portlets.user.gisviewer.client.DataPanelOpenListener;
import org.gcube.portlets.user.gisviewer.client.GisViewerPanel;
import org.gcube.portlets.user.gisviewer.client.GisViewerParameters;

import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.fx.Resizable;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.google.gwt.core.shared.GWT;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.RootPanel;

/**
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 * @Oct 8, 2014
 *
 */
public class ApplicationController implements WmsDialogHandler{

	/**
	 * 
	 */
	private GisViewerPanel gisViewerPanel; // for normal mode
//	private GCubeGisViewerPanel gisViewerPanel; // for gcube mode
	private ContentPanel gisViewerContentPanel;
	private LayoutContainer mainPanel;
	private GisViewerParameters gisViewerParameters;
	private BaloonPanel baloonWMS;
	private LayoutContainer lcWMS = new LayoutContainer();
	private WmsRequestConverter wmsRequestConverter;
	private final ApplicationController INSTANCE = this;
	/**
	 * 
	 */
	public ApplicationController() {
		mainPanel = new LayoutContainer();
		mainPanel.setLayout(new FitLayout());
		initGisViewerParameters();
//		gisViewerPanel = new GCubeGisViewerPanel(gisViewerParameters);
		gisViewerPanel = new GisViewerPanel(gisViewerParameters);
		initGisViewerContentPanel();
		gisViewerContentPanel.add(gisViewerPanel);
		wmsRequestConverter = new WmsRequestConverter(gisViewerPanel);
		mainPanel.add(gisViewerContentPanel);
	}
	
	private void initGisViewerParameters(){
		
		gisViewerParameters = new GisViewerParameters();
		gisViewerParameters.setProjection("");
		gisViewerParameters.setOpenDataPanelAtStart(false);
		
		gisViewerParameters.setDataPanelOpenListener(new DataPanelOpenListener() {
			@Override
			public void dataPanelOpen(boolean isOpen, int panelHeight) {
//				OLD CODE
//				int gisViewerHeight = gisViewerContentPanel.getHeight()+ (isOpen ? panelHeight-24 : -panelHeight+24);
//				ConstantGisViewerApp.logger.log(Level.INFO, "Set heigth: "+gisViewerHeight);
//				gisViewerContentPanel.setHeight(gisViewerHeight);
				
				int dataPanelHeight = isOpen ? panelHeight+24 : 24;
				int gisViewerHeight;
				
				if(gisViewerContentPanel.getHeight()>Constants.minGisViewerHeight)
					gisViewerHeight = gisViewerContentPanel.getHeight();
				else
					gisViewerHeight = Constants.minGisViewerHeight+dataPanelHeight;

				gisViewerContentPanel.setHeight(gisViewerHeight);
				
	
			}
		});
		
	}
	
	private void initGisViewerContentPanel(){
		
		gisViewerContentPanel = new ContentPanel() {

			@Override
			protected void onExpand() {
				super.onExpand();
				if (gisViewerPanel!=null)
					gisViewerPanel.updateOpenLayersSize();
//				resizeBar.show();
			}
			
			@Override
			protected void onCollapse() {
				super.onCollapse();
//				resizeBar.hide();
			}
		};
		
		gisViewerContentPanel.setLayout(new FitLayout());
		gisViewerContentPanel.setHeading(ConstantGisViewerApp.GIS_VIEWER_APP);
		gisViewerContentPanel.setHeaderVisible(false);
		gisViewerContentPanel.setCollapsible(true);

		@SuppressWarnings("unused")
		Resizable r = new Resizable(gisViewerContentPanel, "s");
	}
	/**
	 * @param rootPanel
	 */
	public void go(final RootPanel rootPanel) {
		rootPanel.add(mainPanel);
		
		String wmsRequest = Window.Location.getParameter(ConstantGisViewerApp.GET_WMS_PARAMETER);
		ConstantGisViewerApp.logger.log(Level.INFO, ConstantGisViewerApp.GET_WMS_PARAMETER+ " is "+wmsRequest);
//		String replacement = Window.Location.getParameter(ConstantGisViewerApp.WMS_PARAM_SEPARATOR_REPLACEMENT_KEY);
//		ConstantGisViewerApp.logger.log(Level.INFO, ConstantGisViewerApp.WMS_PARAM_SEPARATOR_REPLACEMENT_KEY+ " is "+replacement);
		
		if(wmsRequest!=null && !wmsRequest.isEmpty()){
			
//			if(replacement!=null && !replacement.isEmpty()){
//				ConstantGisViewerApp.logger.log(Level.INFO, "Replacing all "+replacement);
//				wmsRequest = wmsRequest.replaceAll(replacement, wmsRequest);
//			}
			
			
			
			try {
				wmsRequestConverter.parseRequest(wmsRequest,null);
				wmsRequestConverter.addRequestToGisViewer();
			} catch (Exception e) {
				ConstantGisViewerApp.logger.log(Level.INFO, "An error occurred on adding wmsrequest :"+wmsRequest);
				e.printStackTrace();
			}
		}
		
		rootPanel.add(lcWMS);
		
		lcWMS.setId("WMS");
		
		Command cmd = new Command() {
			
			@Override
			public void execute() {
				WmsDialog win = new WmsDialog(INSTANCE);
				win.show();
				
			}
		};
		baloonWMS =  new BaloonPanel("+WMS", false, cmd);
		
		lcWMS.addListener(Events.Render, new Listener<BaseEvent>() {

			@Override
			public void handleEvent(BaseEvent be) {
				Timer tm = new Timer() {
					
					@Override
					public void run() {
					
						String zi = rootPanel.getElement().getStyle().getZIndex();
						GWT.log("zindex "+zi);
						int zIndex = 50;
						try{
							zIndex += Integer.parseInt(zi);
						}catch(NumberFormatException e){
							
						}
						baloonWMS.getElement().getStyle().setZIndex(zIndex);
					}
				};
				
				tm.schedule(1000);
			}
		});
	}
	
	
	/**
	 * 
	 * @param wmsRequest
	 * @return
	 */
	private String decodeURLWithParamDelimiter(String wmsRequest, String delimiter){
		return wmsRequest.replaceAll(delimiter, "&");
	}
	/**
	 * @return
	 */
	public LayoutContainer getMainPanel() {
		return mainPanel;
	}

	public GisViewerPanel getGisViewerPanel() {
		return gisViewerPanel;
	}

	/**
	 * 
	 */
	public void moveWMSBalloon() {
		baloonWMS.showRelativeTo(lcWMS);
	}

	/* (non-Javadoc)
	 * @see org.gcube.portlets.user.gisviewerapp.client.WmsDialogHandler#addWmsLayer(java.lang.String, java.lang.String, java.lang.String)
	 */
	@Override
	public void addWmsLayer(String displayName, String url) {
		try {
			wmsRequestConverter.parseRequest(url, displayName);
			wmsRequestConverter.addRequestToGisViewer();
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

}
