/**
 * 
 */
package org.gcube.portlets.user.gisviewerapp.client;

import java.util.ArrayList;
import java.util.logging.Level;

import org.gcube.portlets.user.gisviewer.client.GisViewerPanel;
import org.gcube.portlets.user.gisviewer.client.GisViewerPanel.LayerType;
import org.gcube.portlets.user.gisviewerapp.shared.WmsParameters;

/**
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 * @Oct 9, 2014
 *
 */
public class WmsRequestConverter {
	
	private GisViewerPanel gisViewer;
	
	private LayerType layerType = LayerType.FEATURETYPE;
	private String title;
	private String layerName;
	private String url; 
	private boolean isExternal = false;
	private boolean isBase = false;
	private boolean displayInLayerSwitcher = false;
	private ArrayList<String> styles;
	private boolean onTop = true;
	private ArrayList<String> listStyles;
	private String wmsRequest;
	/**
	 * 
	 */
	public WmsRequestConverter(GisViewerPanel gisViewerPanel) {
		this.gisViewer = gisViewerPanel;
	}
	
	public void parseRequest(String wmsRequest) throws Exception{
		this.wmsRequest = wmsRequest;
		
		//FIND BASE URL
		int indexStart = wmsRequest.indexOf("?");
		if(indexStart>=0){
			url = wmsRequest.substring(0, indexStart); //get only parameters
			url = url.trim(); //string trim
		}else{
			throw new Exception("Bad server request '?' not found!");
		}
		
		//FIND LAYERS NAME (AND TITLE)
		String value = getValueOfParameter(WmsParameters.LAYERS, wmsRequest);
		if(value==null || value.isEmpty()){
			throw new Exception("Layer name not found!");
		}else{
			layerName = value;
			title = value;
		}
		
		//FIND STILE
		listStyles = new ArrayList<String>();
		String style = getValueOfParameter(WmsParameters.STYLES, wmsRequest);
		listStyles.add(style);
	}
	
	public void addRequestToGisViewer(){
		gisViewer.addLayerByWms(GisViewerPanel.LayerType.FEATURETYPE, layerName, title, url, isExternal, isBase, displayInLayerSwitcher, listStyles, wmsRequest, onTop);
	}
	
	private String getValueOfParameter(WmsParameters wmsParam, String url){
		ConstantGisViewerApp.logger.log(Level.INFO, "finding: "+wmsParam +" into "+url);
		
		String urlLower = url.toLowerCase();
		int index = urlLower.indexOf(wmsParam.getParameter().toLowerCase());
//		logger.trace("start index of "+wmsParam+ " is: "+index);
		String value = "";
		if(index > -1){
			
			int start = index + wmsParam.getParameter().length()+1; //add +1 for char '='
			
			String sub = url.substring(start, url.length()); 
			
			int indexOfSeparator = sub.indexOf("&");
			
			int end = indexOfSeparator!=-1?indexOfSeparator:sub.length();
			
			value = sub.substring(0, end);
		}
		ConstantGisViewerApp.logger.log(Level.INFO, "return value: "+value);
		
		return value;
		
	}

	public LayerType getLayerType() {
		return layerType;
	}

	public String getTitle() {
		return title;
	}

	public String getLayerName() {
		return layerName;
	}

	public String getUrl() {
		return url;
	}

	public boolean isExternal() {
		return isExternal;
	}

	public boolean isBase() {
		return isBase;
	}

	public boolean isDisplayInLayerSwitcher() {
		return displayInLayerSwitcher;
	}

	public ArrayList<String> getStyles() {
		return styles;
	}

	public boolean isOnTop() {
		return onTop;
	}

	public ArrayList<String> getListStyles() {
		return listStyles;
	}

	public void setLayerType(LayerType layerType) {
		this.layerType = layerType;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public void setLayerName(String layerName) {
		this.layerName = layerName;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public void setExternal(boolean isExternal) {
		this.isExternal = isExternal;
	}

	public void setBase(boolean isBase) {
		this.isBase = isBase;
	}

	public void setDisplayInLayerSwitcher(boolean displayInLayerSwitcher) {
		this.displayInLayerSwitcher = displayInLayerSwitcher;
	}

	public void setStyles(ArrayList<String> styles) {
		this.styles = styles;
	}

	public void setOnTop(boolean onTop) {
		this.onTop = onTop;
	}

	public void setListStyles(ArrayList<String> listStyles) {
		this.listStyles = listStyles;
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("WmsRequestConverter [gisViewer=");
		builder.append(gisViewer);
		builder.append(", layerType=");
		builder.append(layerType);
		builder.append(", title=");
		builder.append(title);
		builder.append(", layerName=");
		builder.append(layerName);
		builder.append(", url=");
		builder.append(url);
		builder.append(", isExternal=");
		builder.append(isExternal);
		builder.append(", isBase=");
		builder.append(isBase);
		builder.append(", displayInLayerSwitcher=");
		builder.append(displayInLayerSwitcher);
		builder.append(", styles=");
		builder.append(styles);
		builder.append(", onTop=");
		builder.append(onTop);
		builder.append(", listStyles=");
		builder.append(listStyles);
		builder.append("]");
		return builder.toString();
	}

}
