/**
 * 
 */
package org.gcube.portlets.user.gisviewerapp.client;

import java.util.logging.Level;

import org.gcube.portlets.user.gisviewer.client.DataPanelOpenListener;
import org.gcube.portlets.user.gisviewer.client.GisViewerPanel;
import org.gcube.portlets.user.gisviewer.client.GisViewerParameters;

import com.extjs.gxt.ui.client.fx.Resizable;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.RootPanel;

/**
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 * @Oct 8, 2014
 *
 */
public class ApplicationController {

	/**
	 * 
	 */
	private GisViewerPanel gisViewerPanel; // for normal mode
//	private GCubeGisViewerPanel gisViewerPanel; // for gcube mode
	private ContentPanel gisViewerContentPanel;
	private LayoutContainer mainPanel;
	private GisViewerParameters gisViewerParameters;
	/**
	 * 
	 */
	public ApplicationController() {
		mainPanel = new LayoutContainer();
		mainPanel.setLayout(new FitLayout());
		initGisViewerParameters();
//		gisViewerPanel = new GCubeGisViewerPanel(gisViewerParameters);
		gisViewerPanel = new GisViewerPanel(gisViewerParameters);
		initGisViewerContentPanel();
		gisViewerContentPanel.add(gisViewerPanel);
		mainPanel.add(gisViewerContentPanel);
	}
	
	private void initGisViewerParameters(){
		
		gisViewerParameters = new GisViewerParameters();
		gisViewerParameters.setProjection("");
		gisViewerParameters.setOpenDataPanelAtStart(false);
		
		gisViewerParameters.setDataPanelOpenListener(new DataPanelOpenListener() {
			@Override
			public void dataPanelOpen(boolean isOpen, int panelHeight) {
				int gisViewerHeight = gisViewerContentPanel.getHeight()+ (isOpen ? panelHeight-24 : -panelHeight+24);
				ConstantGisViewerApp.logger.log(Level.INFO, "Set heigth: "+gisViewerHeight);
				gisViewerContentPanel.setHeight(gisViewerHeight);
			}
		});
		
	}
	
	private void initGisViewerContentPanel(){
		
		gisViewerContentPanel = new ContentPanel() {

			@Override
			protected void onExpand() {
				super.onExpand();
				if (gisViewerPanel!=null)
					gisViewerPanel.updateOpenLayersSize();
//				resizeBar.show();
			}
			
			@Override
			protected void onCollapse() {
				super.onCollapse();
//				resizeBar.hide();
			}
		};
		
		gisViewerContentPanel.setLayout(new FitLayout());
		gisViewerContentPanel.setHeading(ConstantGisViewerApp.GIS_VIEWER_APP);
		gisViewerContentPanel.setHeaderVisible(false);
		gisViewerContentPanel.setCollapsible(true);

		@SuppressWarnings("unused")
		Resizable r = new Resizable(gisViewerContentPanel, "s");
	}
	/**
	 * @param rootPanel
	 */
	public void go(RootPanel rootPanel) {
		rootPanel.add(mainPanel);
		
		String wmsRequest = Window.Location.getParameter(ConstantGisViewerApp.GET_WMS_PARAMETER);
		ConstantGisViewerApp.logger.log(Level.INFO, ConstantGisViewerApp.GET_WMS_PARAMETER+ " is "+wmsRequest);
//		String replacement = Window.Location.getParameter(ConstantGisViewerApp.WMS_PARAM_SEPARATOR_REPLACEMENT_KEY);
//		ConstantGisViewerApp.logger.log(Level.INFO, ConstantGisViewerApp.WMS_PARAM_SEPARATOR_REPLACEMENT_KEY+ " is "+replacement);
		
		if(wmsRequest!=null && !wmsRequest.isEmpty()){
			
//			if(replacement!=null && !replacement.isEmpty()){
//				ConstantGisViewerApp.logger.log(Level.INFO, "Replacing all "+replacement);
//				wmsRequest = wmsRequest.replaceAll(replacement, wmsRequest);
//			}
			
			WmsRequestConverter convert = new WmsRequestConverter(gisViewerPanel);
			try {
				convert.parseRequest(wmsRequest);
				convert.addRequestToGisViewer();
			} catch (Exception e) {
				ConstantGisViewerApp.logger.log(Level.INFO, "An error occurred on adding wmsrequest :"+wmsRequest);
				e.printStackTrace();
			}
		}
	}
	
	/**
	 * 
	 * @param wmsRequest
	 * @return
	 */
	private String decodeURLWithParamDelimiter(String wmsRequest, String delimiter){
		return wmsRequest.replaceAll(delimiter, "&");
	}
	/**
	 * @return
	 */
	public LayoutContainer getMainPanel() {
		return mainPanel;
	}

}
