/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.gcubeloggedin.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.portlets.user.gcubeloggedin.client.LoggedinService;
import org.gcube.portlets.user.gcubeloggedin.shared.VObject;
import org.gcube.portlets.user.gcubeloggedin.shared.VREClient;
import org.gcube.portlets.user.gcubewidgets.server.ScopeServiceImpl;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayRoleManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.GCubeGroup;
import org.gcube.vomanagement.usermanagement.model.GCubeRole;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggedinServiceImpl
extends RemoteServiceServlet
implements LoggedinService {
    private static final Logger _log = LoggerFactory.getLogger(LoggedinServiceImpl.class);
    private static final String VRE_MANAGER_ROLE = "VRE-Manager";

    private ASLSession getASLSession() {
        String sessionID = this.getThreadLocalRequest().getSession().getId();
        String user = (String)this.getThreadLocalRequest().getSession().getAttribute("username");
        if (user == null) {
            _log.warn("LOGGEDIN PORTLET: USER IS NULL \n\n SESSION ID READ: " + sessionID);
            user = "test.user";
            _log.warn("session ID= *" + sessionID + "*  user= *" + user + "*");
        }
        return SessionManager.getInstance().getASLSession(sessionID, user);
    }

    public VObject getSelectedRE(String portalURL) {
        ASLSession aslSession = this.getASLSession();
        String friendlyURL = ScopeServiceImpl.extractOrgFriendlyURL((String)portalURL);
        if (friendlyURL == null) {
            return new VREClient("Test VRE Name", "", "Fishery and Aquaculture Resources Management (FARM) Virtual Organisation</b>    The FARM Virtual Organisation is the <b><i>dynamic group of individuals</i></b> and/or <b><i>institutions</i></b>             defined around a set of <b><i>sharing rules</i></b> in which <b><i>resource providers</i></b> and <b><i>consumers</i></b>     specify clearly and carefully just what is shared, who is allowed to share, and the conditions under which sharing occurs to serve the needs of the     <b><i>Fisheries and Aquaculture Resources Management</i></b>.             This VO is conceived to support various application scenarios arising in the FARM Community including the production of Fisheries and Aquaculture Country Profiles, the management of catch statistics    including harmonisation, the dynamic generation of biodiversity maps and species distribution maps.            This Virtual Organisation currently consists of:<ul>                <li> approximately <b><i>13 gCube nodes</i></b>, i.e. machines dedicated to run the gCube system;</li>        <li> approximately <b><i>89 running instances</i></b>, i.e. running gCube services supporting the operation of the infrastructure;</li>        <li> approximately <b><i>25 collections</i></b>, i.e. set of D4Science Information Objects including Earth images, AquaMaps, Graphs on catch statistics;</li>        <li> approximately <b><i>66 metadata collections</i></b>, i.e. set of Metadata Objects describing the Information Objects through various features and schemas;</li>        <li> approximately <b><i>58 other resources</i></b> including transformation programs, index types, etc.</li></ul></div>", "http://placehold.it/300x200", "", VObject.UserBelongingClient.BELONGING, false, true, true);
        }
        _log.trace("getting Selected Research Environment");
        LiferayGroupManager gm = new LiferayGroupManager();
        GCubeGroup currSite = null;
        try {
            List groups = gm.listGroups();
            for (GCubeGroup g : groups) {
                if (g.getFriendlyURL().compareTo(friendlyURL) != 0) continue;
                long groupId = g.getGroupId();
                String scopeToSet = gm.getInfrastructureScope(groupId);
                this.getASLSession().setScope(scopeToSet);
                _log.info("GOT Selected Research Environment: " + scopeToSet);
                currSite = g;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        aslSession.setAttribute("CURR_RE_NAME", currSite);
        aslSession.setGroupModelInfos(currSite.getGroupName(), currSite.getGroupId());
        _log.trace("CURRENT ORG SET IN SESSION: " + currSite.getGroupName());
        String name = currSite.getGroupName();
        String logoURL = "/image/layout_set_logo?img_id=" + currSite.getLogoId();
        String desc = "";
        if (currSite.getDescription() != null) {
            desc = currSite.getDescription();
        }
        return new VREClient(name, "", desc, logoURL, "", VObject.UserBelongingClient.BELONGING, false, false, this.isCurrUserVREManager());
    }

    private boolean isCurrUserVREManager() {
        ASLSession session = this.getASLSession();
        try {
            long userId = new LiferayUserManager().getUserId(session.getUsername());
            long groupId = new LiferayGroupManager().getGroupIdFromInfrastructureScope(session.getScope());
            LiferayRoleManager rm = new LiferayRoleManager();
            long roleId = rm.getRoleIdByName(VRE_MANAGER_ROLE);
            boolean toReturn = rm.hasRole(userId, groupId, roleId);
            _log.debug("User " + session.getUsername() + " is " + VRE_MANAGER_ROLE + " for " + session.getScope() + "? -> " + toReturn);
            return toReturn;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    protected static ArrayList<String> getAdministratorsEmails(String scope) {
        LiferayUserManager userManager = new LiferayUserManager();
        LiferayGroupManager groupManager = new LiferayGroupManager();
        long groupId = -1L;
        try {
            List allGroups = groupManager.listGroups();
            _log.debug("Number of groups retrieved: " + allGroups.size());
            for (int i = 0; i < allGroups.size(); ++i) {
                long grId = ((GCubeGroup)allGroups.get(i)).getGroupId();
                String groupScope = groupManager.getInfrastructureScope(grId);
                _log.debug("Comparing: " + groupScope + " " + scope);
                if (!groupScope.equals(scope)) continue;
                groupId = ((GCubeGroup)allGroups.get(i)).getGroupId();
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Map usersAndRoles = null;
        try {
            usersAndRoles = userManager.listUsersAndRolesByGroup(groupId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Set users = usersAndRoles.keySet();
        ArrayList<String> adminEmailsList = new ArrayList<String>();
        block5: for (GCubeUser usr : users) {
            List roles = (List)usersAndRoles.get(usr);
            for (int i = 0; i < roles.size(); ++i) {
                if (!((GCubeRole)roles.get(i)).getRoleName().equals("VO-Admin") && !((GCubeRole)roles.get(i)).getRoleName().equals(VRE_MANAGER_ROLE)) continue;
                adminEmailsList.add(usr.getEmail());
                _log.debug("Admin: " + usr.getFullname());
                continue block5;
            }
        }
        return adminEmailsList;
    }

    public String saveVREDescription(String toSave) {
        try {
            String scope = this.getASLSession().getScope();
            LiferayGroupManager gm = new LiferayGroupManager();
            long groupId = gm.getGroupIdFromInfrastructureScope(scope);
            return gm.updateGroupDescription(groupId, toSave);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

