package org.gcube.portlets.user.gcubeloggedin.client;

import org.gcube.portal.custom.communitymanager.OrganizationsUtil;
import org.gcube.portal.custom.scopemanager.scopehelper.ScopeHelper;
import org.gcube.portlets.user.gcubeloggedin.client.ui.AboutView;
import org.gcube.portlets.user.gcubeloggedin.shared.VObject;
import org.gcube.portlets.user.gcubeloggedin.shared.VREClient;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.liferay.portal.model.User;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.UserLocalServiceUtil;

/**
 * Entry point classes define <code>onModuleLoad()</code>.
 */
public class GCubeLoggedin implements EntryPoint {
	

	/**
	 * Create a remote service proxy to talk to the server-side Greeting service.
	 */
	private final LoggedinServiceAsync loggedinService = GWT.create(LoggedinService.class);
	private ServiceDefTarget endpoint = (ServiceDefTarget) loggedinService;
	private VerticalPanel main_panel = new VerticalPanel();
	/**
	 * This is the entry point method.
	 */
	public void onModuleLoad() {
		main_panel.setWidth("100%");

		endpoint.setServiceEntryPoint(GWT.getModuleBaseURL()+"LoggedinServiceImpl");
		main_panel.add(new HTML("<div style=\"height: 450px; text-align:center; vertical-align:text-top;\"><p><br /><br />Loading Environment please wait ...</p><p><br /><br /> " + getLoadingHTML() + "</p></div>" ));

		// Associate the new panel with the HTML host page.
		RootPanel.get("LoggedinDiv").add(main_panel);
		
		loggedinService.getSelectedRE(new AsyncCallback<VObject>() {
			public void onFailure(Throwable caught) { }

			public void onSuccess(VObject result) {
			
				main_panel.clear();
				main_panel.add(new AboutView(result, loggedinService));
			}			
		});
	}
	/**
	 * 
	 * @return
	 */
	private  String getLoadingHTML() {
		return 
		"<center><table border='0'>"+
		"<tr>"+
		"<td>"+
		"<img src='" + UIConstants.LOADING_IMAGE + "'>"+
		"</td></tr>"+
		"</table></center>" ;
	}
	
	
}
