/**
 * 
 */
package org.gcube.portlets.user.gcubegisviewer.client;

import java.util.Map;

import org.gcube.portlets.user.gisviewer.client.GisViewerService;

import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;


/**
 * The Interface GCubeGisViewerService.
 * @author "Federico De Faveri defaveri@isti.cnr.it"
 * @author updated by Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 * Nov 27, 2015
 */
@RemoteServiceRelativePath("GisViewerService")
public interface GCubeGisViewerService extends GisViewerService {
	
	/**
	 * Save layer item.
	 *
	 * @param name the name
	 * @param mimeType the mime type
	 * @param url the url
	 * @param destinationFolderId the destination folder id
	 * @throws Exception the exception
	 */
	public void saveLayerItem(String name, String mimeType, String url, String destinationFolderId) throws Exception;

//	/**
//	 * Save map image item.
//	 *
//	 * @param name the name
//	 * @param mimeType the mime type
//	 * @param bbox the bbox
//	 * @param width the width
//	 * @param height the height
//	 * @param geoservers the geoservers
//	 * @param layers the layers
//	 * @param styles the styles
//	 * @param opacities the opacities
//	 * @param cqlfilters the cqlfilters
//	 * @param gsrefs the gsrefs
//	 * @param destinationFolderId the destination folder id
//	 * @throws Exception the exception
//	 */
//	void saveMapImageItem(String name, String mimeType, String bbox,
//			String width, String height, String[] geoservers, String[] layers,
//			String[] styles, String[] opacities, String[] cqlfilters,
//			String[] gsrefs, String destinationFolderId) throws Exception;

	/**
	 * Save map image item.
	 *
	 * @param name the name
	 * @param outputFormat the output format
	 * @param parameters the parameters
	 * @param folderId the folder id
	 * @throws GCubeGisViewerServiceException the g cube gis viewer service exception
	 */
	void saveMapImageItem(String name, String outputFormat,
			Map<String, String> parameters, String folderId) throws GCubeGisViewerServiceException;

}
