/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.dataminermanager.client.experiments;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.sencha.gxt.core.client.dom.ScrollSupport;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.widget.core.client.FramedPanel;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.container.SimpleContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.toolbar.LabelToolItem;
import com.sencha.gxt.widget.core.client.toolbar.ToolBar;
import java.util.ArrayList;
import java.util.List;
import org.gcube.data.analysis.dataminermanagercl.shared.process.Operator;
import org.gcube.portlets.user.dataminermanager.client.DataMinerManager;
import org.gcube.portlets.user.dataminermanager.client.common.EventBusProvider;
import org.gcube.portlets.user.dataminermanager.client.events.ResubmitComputationExecutionEvent;
import org.gcube.portlets.user.dataminermanager.client.events.StartComputationExecutionEvent;
import org.gcube.portlets.user.dataminermanager.client.events.StartComputationExecutionRequestEvent;
import org.gcube.portlets.user.dataminermanager.client.experiments.ComputationStatusPanel;

public class ComputationExecutionPanel
extends FramedPanel {
    private List<ComputationStatusPanel> computationStatusPanels = new ArrayList();
    private static final String DELETE_ALL_BUTTON_TOOLTIP = "Remove Computations Log";
    private TextButton removeAllButton;
    private VerticalLayoutContainer v;
    private ToolBar toolBar;
    private VerticalLayoutContainer topV;

    public ComputationExecutionPanel() {
        Log.debug((String)"Computation Execution Panel");
        this.init();
        this.create();
        this.bind();
    }

    private void init() {
        this.setHeaderVisible(false);
        this.addStyleName("computationExcecutionPanel");
        this.setBodyStyle("backgroundColor:white;");
    }

    private void create() {
        this.topV = new VerticalLayoutContainer();
        this.setToolBar();
        this.topV.add((IsWidget)this.toolBar, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0)));
        SimpleContainer computations = new SimpleContainer();
        this.v = new VerticalLayoutContainer();
        this.v.setScrollMode(ScrollSupport.ScrollMode.AUTO);
        computations.add((Widget)this.v);
        this.topV.add((IsWidget)computations, new VerticalLayoutContainer.VerticalLayoutData(1.0, 1.0, new Margins(0)));
        this.add((Widget)this.topV);
    }

    private void bind() {
        EventBusProvider.INSTANCE.addHandler(ResubmitComputationExecutionEvent.getType(), (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        EventBusProvider.INSTANCE.addHandler(StartComputationExecutionEvent.getType(), (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void startNewComputation(Operator operator) {
        Log.debug((String)"Computation Panel: start new computation ");
        ComputationStatusPanel statusPanel = new ComputationStatusPanel(operator.getName());
        this.computationStatusPanels.add(statusPanel);
        int index = this.computationStatusPanels.indexOf(statusPanel);
        statusPanel.setItemId("ComputationStatusPanel" + String.valueOf(index));
        Log.debug((String)"Added status bar");
        this.v.insert((IsWidget)statusPanel, 0, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(20)));
        this.removeAllButton.setEnabled(true);
        this.forceLayout();
        StartComputationExecutionRequestEvent event = new StartComputationExecutionRequestEvent(operator, index);
        EventBusProvider.INSTANCE.fireEvent((GwtEvent)event);
    }

    private void startComputation(StartComputationExecutionEvent event) {
        try {
            ComputationStatusPanel statusPanel = null;
            try {
                statusPanel = (ComputationStatusPanel)this.computationStatusPanels.get(event.getComputationStatusPanelIndex());
            }
            catch (IndexOutOfBoundsException e) {
                Log.debug((String)"No ComputationStatusPanel retrieved!");
                Log.debug((String)e.getLocalizedMessage());
            }
            if (statusPanel != null) {
                statusPanel.computationStarted(event.getComputationId());
                this.forceLayout();
            }
        }
        catch (Throwable e) {
            Log.error((String)e.getLocalizedMessage());
            e.printStackTrace();
        }
    }

    private void resubmitComputation(ResubmitComputationExecutionEvent event) {
        ComputationStatusPanel statusPanel = new ComputationStatusPanel(event.getComputationId().getOperatorName());
        this.computationStatusPanels.add(statusPanel);
        if (this.v.getWidgetCount() == 0) {
            this.v.add((IsWidget)statusPanel, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(20)));
        } else {
            this.v.insert((IsWidget)statusPanel, 0, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(20)));
        }
        this.removeAllButton.setEnabled(true);
        statusPanel.computationStarted(event.getComputationId());
        this.forceLayout();
    }

    private void emptyPanel() {
        for (ComputationStatusPanel statusPanel : this.computationStatusPanels) {
            statusPanel.stopTimer();
        }
        this.removeAllButton.setEnabled(false);
        this.v.clear();
        this.computationStatusPanels.clear();
        this.forceLayout();
    }

    private void setToolBar() {
        this.toolBar = new ToolBar();
        this.removeAllButton = new TextButton("Remove All");
        this.removeAllButton.addSelectHandler((SelectEvent.SelectHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.removeAllButton.setIcon(DataMinerManager.resources.removeAll());
        this.removeAllButton.setToolTip(DELETE_ALL_BUTTON_TOOLTIP);
        this.removeAllButton.setEnabled(false);
        this.toolBar.add((Widget)new LabelToolItem("Tools:"));
        this.toolBar.add((Widget)this.removeAllButton);
    }

    static /* synthetic */ void access$000(ComputationExecutionPanel x0, ResubmitComputationExecutionEvent x1) {
        x0.resubmitComputation(x1);
    }

    static /* synthetic */ void access$100(ComputationExecutionPanel x0, StartComputationExecutionEvent x1) {
        x0.startComputation(x1);
    }

    static /* synthetic */ void access$200(ComputationExecutionPanel x0) {
        x0.emptyPanel();
    }
}

