/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.dataminermanager.client.parametersfield;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.user.client.ui.IsWidget;
import com.sencha.gxt.widget.core.client.form.FieldLabel;
import org.gcube.data.analysis.dataminermanagercl.shared.parameters.ListParameter;
import org.gcube.data.analysis.dataminermanagercl.shared.parameters.ObjectParameter;
import org.gcube.data.analysis.dataminermanagercl.shared.parameters.Parameter;
import org.gcube.portlets.user.dataminermanager.client.parametersfield.AbstractFld;
import org.gcube.portlets.user.dataminermanager.client.parametersfield.BooleanFld;
import org.gcube.portlets.user.dataminermanager.client.parametersfield.ColumnFld;
import org.gcube.portlets.user.dataminermanager.client.parametersfield.ColumnListFld;
import org.gcube.portlets.user.dataminermanager.client.parametersfield.DateFld;
import org.gcube.portlets.user.dataminermanager.client.parametersfield.DoubleFld;
import org.gcube.portlets.user.dataminermanager.client.parametersfield.EnumFld;
import org.gcube.portlets.user.dataminermanager.client.parametersfield.FileFld;
import org.gcube.portlets.user.dataminermanager.client.parametersfield.FloatFld;
import org.gcube.portlets.user.dataminermanager.client.parametersfield.IntFld;
import org.gcube.portlets.user.dataminermanager.client.parametersfield.ItemIdFld;
import org.gcube.portlets.user.dataminermanager.client.parametersfield.ListIntFld;
import org.gcube.portlets.user.dataminermanager.client.parametersfield.ListStringFld;
import org.gcube.portlets.user.dataminermanager.client.parametersfield.OperatorFieldWidget;
import org.gcube.portlets.user.dataminermanager.client.parametersfield.StringFld;
import org.gcube.portlets.user.dataminermanager.client.parametersfield.TabularFld;
import org.gcube.portlets.user.dataminermanager.client.parametersfield.TabularListFld;
import org.gcube.portlets.user.dataminermanager.client.parametersfield.TimeFld;
import org.gcube.portlets.user.dataminermanager.client.parametersfield.WKTFld;

public class OperatorFieldWidget {
    private Parameter parameter;
    private AbstractFld field;
    private FieldLabel parameterLabel;

    public OperatorFieldWidget(Parameter parameter) {
        this.parameter = parameter;
        try {
            if (parameter.getTypology() != null) {
                switch (1.$SwitchMap$org$gcube$data$analysis$dataminermanagercl$shared$parameters$ParameterType[parameter.getTypology().ordinal()]) {
                    case 1: {
                        this.field = new ColumnFld(parameter);
                        break;
                    }
                    case 2: {
                        this.field = new ColumnListFld(parameter);
                        break;
                    }
                    case 3: {
                        this.field = new EnumFld(parameter);
                        break;
                    }
                    case 4: {
                        this.field = new FileFld(parameter);
                        break;
                    }
                    case 5: {
                        this.field = new ItemIdFld(parameter);
                        break;
                    }
                    case 6: {
                        this.field = this.createListField(parameter);
                        break;
                    }
                    case 7: {
                        this.field = this.createObjectField(parameter);
                        break;
                    }
                    case 8: {
                        this.field = new TabularFld(parameter);
                        break;
                    }
                    case 9: {
                        this.field = new TabularListFld(parameter);
                        break;
                    }
                    case 10: {
                        this.field = new WKTFld(parameter);
                        break;
                    }
                    case 11: {
                        this.field = new DateFld(parameter);
                        break;
                    }
                    case 12: {
                        this.field = new TimeFld(parameter);
                        break;
                    }
                }
            }
            if (this.field == null) {
                this.parameterLabel = new FieldLabel(null, parameter.getName());
                this.parameterLabel.setLabelWidth(200);
                this.parameterLabel.setLabelWordWrap(true);
            } else {
                this.parameterLabel = new FieldLabel((IsWidget)this.field.getWidget(), parameter.getName());
                this.parameterLabel.setLabelWidth(200);
                this.parameterLabel.setLabelWordWrap(true);
            }
        }
        catch (Throwable e) {
            Log.error((String)("Error: " + e.getLocalizedMessage()));
            e.printStackTrace();
        }
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    public String getFieldValue() {
        return this.field.getValue();
    }

    public String getValue() {
        return this.getFieldValue();
    }

    public FieldLabel getParameterLabel() {
        return this.parameterLabel;
    }

    private AbstractFld createObjectField(Parameter parameter) {
        ObjectParameter objectParameter = (ObjectParameter)parameter;
        String type = objectParameter.getType();
        if (type.contentEquals(Integer.class.getName())) {
            return new IntFld((Parameter)objectParameter);
        }
        if (type.contentEquals(String.class.getName())) {
            return new StringFld((Parameter)objectParameter);
        }
        if (type.contentEquals(Boolean.class.getName())) {
            return new BooleanFld((Parameter)objectParameter);
        }
        if (type.contentEquals(Double.class.getName())) {
            return new DoubleFld((Parameter)objectParameter);
        }
        if (type.contentEquals(Float.class.getName())) {
            return new FloatFld((Parameter)objectParameter);
        }
        return null;
    }

    private AbstractFld createListField(Parameter p) {
        ListParameter listParameter = (ListParameter)p;
        String type = listParameter.getType();
        if (type.contentEquals(String.class.getName()) || type.contentEquals("STRING")) {
            return new ListStringFld((Parameter)listParameter);
        }
        if (type.contentEquals(Integer.class.getName()) || type.contentEquals("NUMBER")) {
            return new ListIntFld((Parameter)listParameter);
        }
        return null;
    }

    public void updateOperatorParameterValue() {
        this.parameter.setValue(this.getFieldValue());
    }

    public AbstractFld getField() {
        return this.field;
    }

    public boolean isValid() {
        if (this.field != null) {
            return this.field.isValid();
        }
        return false;
    }
}

