/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.dataminermanager.client.experiments;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.sencha.gxt.core.client.Style;
import com.sencha.gxt.core.client.util.Format;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.widget.core.client.container.SimpleContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.tips.ToolTipConfig;
import org.gcube.data.analysis.dataminermanagercl.shared.process.Operator;
import org.gcube.portlets.user.dataminermanager.client.experiments.OperatorsPanelHandler;

public class OperatorPanel
extends SimpleContainer {
    private static final int TOOLTIP_DESCRIPTION_LENGHT = 435;
    private static final int OPERATOR_BRIEF_DESCRIPTION_LENGHT = 160;
    private static final int TOOLTIP_WIDTH = 500;
    private VerticalLayoutContainer vert;
    private Operator operator;
    private OperatorsPanelHandler handler;
    private HTML titleHtml;

    public OperatorPanel(Operator operator, OperatorsPanelHandler handler) {
        this.operator = operator;
        this.handler = handler;
        this.init();
    }

    private void init() {
        this.addStyleName("operatorPanel");
        this.addStyleName("opePanel");
        this.addDomHandler((EventHandler)new /* Unavailable Anonymous Inner Class!! */, ClickEvent.getType());
        this.titleHtml = new HTML(this.operator.getName());
        this.titleHtml.addStyleName("operatorPanel-title");
        HTML descriptionHtml = new HTML(Format.ellipse((String)this.operator.getBriefDescription(), (int)160));
        descriptionHtml.addStyleName("operatorPanel-briefDescription");
        this.vert = new VerticalLayoutContainer();
        this.vert.add((IsWidget)this.titleHtml, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0)));
        this.vert.add((IsWidget)descriptionHtml, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0)));
        this.add((Widget)this.vert);
        ToolTipConfig tooltipConfig = this.createToolTip(this.operator);
        this.setToolTipConfig(tooltipConfig);
    }

    public Operator getOperator() {
        return this.operator;
    }

    private ToolTipConfig createToolTip(Operator op) {
        ToolTipConfig tooltipConfig = new ToolTipConfig();
        tooltipConfig.setTitleHtml("<br>&nbsp;&nbsp;" + op.getName());
        tooltipConfig.setMouseOffsetX(0);
        tooltipConfig.setMouseOffsetY(0);
        tooltipConfig.setAnchor(Style.Side.LEFT);
        tooltipConfig.setDismissDelay(5000);
        tooltipConfig.setBodyHtml(this.getTooltipTemplate(GWT.getModuleBaseURL(), op.getId(), op.hasImage(), op.getDescription()));
        tooltipConfig.setMaxWidth(500);
        return tooltipConfig;
    }

    private String getTooltipTemplate(String base, String id, boolean hasImage, String description) {
        String template = "<div class='categoryItemTooltip'><img src='" + base + "../images/operators/" + (hasImage ? id : "DEFAULT_IMAGE") + ".png' >" + Format.ellipse((String)description, (int)435) + "</div>";
        return template;
    }

    public void toggleSelected(boolean isSelect) {
        if (isSelect) {
            this.addStyleName("operatorPanel-selected");
        } else {
            this.removeStyleName("operatorPanel-selected");
        }
    }

    public void setAsTheDefaultOperator() {
        this.handler.addOperator(this, this.operator);
    }

    static /* synthetic */ Operator access$000(OperatorPanel x0) {
        return x0.operator;
    }

    static /* synthetic */ OperatorsPanelHandler access$100(OperatorPanel x0) {
        return x0.handler;
    }
}

