/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.dataminermanager.client;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.List;
import org.gcube.data.analysis.dataminermanagercl.shared.data.OutputData;
import org.gcube.data.analysis.dataminermanagercl.shared.data.computations.ComputationData;
import org.gcube.data.analysis.dataminermanagercl.shared.data.computations.ComputationId;
import org.gcube.data.analysis.dataminermanagercl.shared.perspective.PerspectiveType;
import org.gcube.data.analysis.dataminermanagercl.shared.process.OperatorsClassification;
import org.gcube.data.analysis.dataminermanagercl.shared.workspace.DataMinerWorkArea;
import org.gcube.data.analysis.dataminermanagercl.shared.workspace.ItemDescription;
import org.gcube.portlets.user.dataminermanager.client.DataMinerManagerController;
import org.gcube.portlets.user.dataminermanager.client.common.EventBusProvider;
import org.gcube.portlets.user.dataminermanager.client.events.CancelComputationExecutionRequestEvent;
import org.gcube.portlets.user.dataminermanager.client.events.CancelExecutionFromComputationsRequestEvent;
import org.gcube.portlets.user.dataminermanager.client.events.ComputationDataEvent;
import org.gcube.portlets.user.dataminermanager.client.events.ComputationDataRequestEvent;
import org.gcube.portlets.user.dataminermanager.client.events.DataMinerWorkAreaEvent;
import org.gcube.portlets.user.dataminermanager.client.events.DataMinerWorkAreaRequestEvent;
import org.gcube.portlets.user.dataminermanager.client.events.DeleteItemRequestEvent;
import org.gcube.portlets.user.dataminermanager.client.events.MenuEvent;
import org.gcube.portlets.user.dataminermanager.client.events.MenuSwitchEvent;
import org.gcube.portlets.user.dataminermanager.client.events.OperatorsClassificationEvent;
import org.gcube.portlets.user.dataminermanager.client.events.OperatorsClassificationRequestEvent;
import org.gcube.portlets.user.dataminermanager.client.events.OutputDataEvent;
import org.gcube.portlets.user.dataminermanager.client.events.OutputDataRequestEvent;
import org.gcube.portlets.user.dataminermanager.client.events.RefreshDataMinerWorkAreaEvent;
import org.gcube.portlets.user.dataminermanager.client.events.RemoveSelectedOperatorEvent;
import org.gcube.portlets.user.dataminermanager.client.events.ResubmitComputationExecutionEvent;
import org.gcube.portlets.user.dataminermanager.client.events.ResubmitComputationExecutionRequestEvent;
import org.gcube.portlets.user.dataminermanager.client.events.ServiceInfoRequestEvent;
import org.gcube.portlets.user.dataminermanager.client.events.SessionExpiredEvent;
import org.gcube.portlets.user.dataminermanager.client.events.StartComputationExecutionEvent;
import org.gcube.portlets.user.dataminermanager.client.events.StartComputationExecutionRequestEvent;
import org.gcube.portlets.user.dataminermanager.client.monitor.StatusMonitor;
import org.gcube.portlets.user.dataminermanager.client.rpc.DataMinerPortletServiceAsync;
import org.gcube.portlets.user.dataminermanager.client.type.DataMinerWorkAreaElementType;
import org.gcube.portlets.user.dataminermanager.client.type.DataMinerWorkAreaEventType;
import org.gcube.portlets.user.dataminermanager.client.type.MenuType;
import org.gcube.portlets.user.dataminermanager.client.util.UtilsGXT3;
import org.gcube.portlets.user.dataminermanager.shared.session.UserInfo;

public class DataMinerManagerController {
    private UserInfo userInfo;
    private DataMinerWorkArea dataMinerWorkArea;
    private List<OperatorsClassification> operatorsClassifications;
    private MenuType currentVisualization;
    private String operatorId;

    public DataMinerManagerController() {
        this.init();
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    public DataMinerWorkArea getDataMinerWorkArea() {
        return this.dataMinerWorkArea;
    }

    public String getOperatorId() {
        return this.operatorId;
    }

    private void init() {
        this.currentVisualization = MenuType.HOME;
        this.restoreUISession();
        this.bind();
        this.callHello();
        this.checkSession();
    }

    private void checkSession() {
    }

    private void sessionExpiredShow() {
    }

    private void bind() {
        EventBusProvider.INSTANCE.addHandler(SessionExpiredEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        EventBusProvider.INSTANCE.addHandler(MenuEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        EventBusProvider.INSTANCE.addHandler(StartComputationExecutionRequestEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        EventBusProvider.INSTANCE.addHandler(CancelComputationExecutionRequestEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        EventBusProvider.INSTANCE.addHandler(CancelExecutionFromComputationsRequestEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        EventBusProvider.INSTANCE.addHandler(ResubmitComputationExecutionRequestEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        EventBusProvider.INSTANCE.addHandler(OutputDataRequestEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        EventBusProvider.INSTANCE.addHandler(ComputationDataRequestEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        EventBusProvider.INSTANCE.addHandler(OperatorsClassificationRequestEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        EventBusProvider.INSTANCE.addHandler(DeleteItemRequestEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        EventBusProvider.INSTANCE.addHandler(DataMinerWorkAreaRequestEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        EventBusProvider.INSTANCE.addHandler(ServiceInfoRequestEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void restoreUISession() {
        this.operatorId = Window.Location.getParameter((String)"OperatorId");
    }

    private void callHello() {
        DataMinerPortletServiceAsync.INSTANCE.hello((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void manageMenuEvent(MenuEvent event) {
        Log.debug((String)("CurrentVisualization=" + this.currentVisualization));
        if (event == null || event.getMenuType() == null || this.currentVisualization == null && event.getMenuType().compareTo((Enum)MenuType.HOME) == 0 || this.currentVisualization != null && event.getMenuType().compareTo((Enum)this.currentVisualization) == 0) {
            return;
        }
        this.currentVisualization = event.getMenuType();
        MenuSwitchEvent menuSwitchEvent = new MenuSwitchEvent(event.getMenuType());
        EventBusProvider.INSTANCE.fireEvent((GwtEvent)menuSwitchEvent);
    }

    private void startComputationRequest(StartComputationExecutionRequestEvent event) {
        DataMinerPortletServiceAsync.INSTANCE.startComputation(event.getOp(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void startComputation(ComputationId computationId, int computationStatusPanelIndex) {
        StartComputationExecutionEvent event = new StartComputationExecutionEvent(computationId, computationStatusPanelIndex);
        EventBusProvider.INSTANCE.fireEvent((GwtEvent)event);
    }

    private void cancelExecutionFromComputationsRequest(CancelExecutionFromComputationsRequestEvent event) {
        ItemDescription itemDescription = event.getItemDescription();
        DataMinerPortletServiceAsync.INSTANCE.cancelComputation(itemDescription, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void cancelComputationRequest(CancelComputationExecutionRequestEvent event) {
        ComputationId computationId = event.getComputationId();
        DataMinerPortletServiceAsync.INSTANCE.cancelComputation(computationId, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void resubmitComputationRequest(ResubmitComputationExecutionRequestEvent event) {
        this.currentVisualization = MenuType.EXPERIMENT;
        MenuSwitchEvent menuSwitchEvent = new MenuSwitchEvent(MenuType.EXPERIMENT);
        EventBusProvider.INSTANCE.fireEvent((GwtEvent)menuSwitchEvent);
        DataMinerPortletServiceAsync.INSTANCE.resubmit(event.getItemDescription(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void resubmitComputation(ComputationId computationId) {
        ResubmitComputationExecutionEvent event = new ResubmitComputationExecutionEvent(computationId);
        EventBusProvider.INSTANCE.fireEvent((GwtEvent)event);
    }

    private void operatorsClassificationRequest(OperatorsClassificationRequestEvent event) {
        if (this.operatorsClassifications == null) {
            this.getOperatorsClassifications(event);
        } else if (event.isRefresh()) {
            RemoveSelectedOperatorEvent rEvent = new RemoveSelectedOperatorEvent();
            EventBusProvider.INSTANCE.fireEvent((GwtEvent)rEvent);
            this.getOperatorsClassifications(event);
        } else {
            this.organizesOperatorsClassification(event);
        }
    }

    private void organizesOperatorsClassification(OperatorsClassificationRequestEvent event) {
        if (event.getOperatorsClassificationRequestType() == null) {
            return;
        }
        switch (24.$SwitchMap$org$gcube$portlets$user$dataminermanager$client$type$OperatorsClassificationRequestType[event.getOperatorsClassificationRequestType().ordinal()]) {
            case 1: {
                this.getOperatorsClassificationByName(event);
                break;
            }
            case 2: {
                this.getOperatorsClassificationDefault(event);
                break;
            }
        }
    }

    private void getOperatorsClassifications(OperatorsClassificationRequestEvent event) {
        DataMinerPortletServiceAsync.INSTANCE.getOperatorsClassifications(event.isRefresh(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void getOperatorsClassificationDefault(OperatorsClassificationRequestEvent event) {
        OperatorsClassification find = null;
        for (OperatorsClassification oc : this.operatorsClassifications) {
            if (!oc.getName().equals(PerspectiveType.User.getPerspective())) continue;
            find = oc;
            break;
        }
        OperatorsClassificationEvent ocEvent = event.isOperatorId() ? new OperatorsClassificationEvent(find, this.operatorId, event.isRefresh()) : new OperatorsClassificationEvent(find, event.isRefresh());
        EventBusProvider.INSTANCE.fireEvent((GwtEvent)ocEvent);
    }

    private void getOperatorsClassificationByName(OperatorsClassificationRequestEvent event) {
        OperatorsClassification find = null;
        for (OperatorsClassification oc : this.operatorsClassifications) {
            if (!oc.getName().equals(event.getPerspectiveType().getPerspective())) continue;
            find = oc;
            break;
        }
        if (find == null) {
            for (OperatorsClassification oc : this.operatorsClassifications) {
                if (!oc.getName().equals(PerspectiveType.User.getPerspective())) continue;
                find = oc;
                break;
            }
        }
        OperatorsClassificationEvent ocEvent = event.isOperatorId() ? new OperatorsClassificationEvent(event.getPerspectiveType(), find, this.operatorId, event.isRefresh()) : new OperatorsClassificationEvent(event.getPerspectiveType(), find, event.isRefresh());
        EventBusProvider.INSTANCE.fireEvent((GwtEvent)ocEvent);
    }

    private void retrieveDataMinerWorkArea(DataMinerWorkAreaRequestEvent event) {
        StatusMonitor monitor = new StatusMonitor();
        DataMinerPortletServiceAsync.INSTANCE.getDataMinerWorkArea((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void retrieveEnvironment(ServiceInfoRequestEvent event) {
        DataMinerPortletServiceAsync.INSTANCE.getServiceInfo((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void fireDataMinerWorkAreaEventRetrieved(DataMinerWorkAreaRequestEvent event, DataMinerWorkArea result) {
        this.dataMinerWorkArea = result;
        DataMinerWorkAreaEvent dataMinerWorkAreaEvent = new DataMinerWorkAreaEvent(DataMinerWorkAreaEventType.OPEN, event.getDataMinerWorkAreaRegionType(), result);
        EventBusProvider.INSTANCE.fireEvent((GwtEvent)dataMinerWorkAreaEvent);
    }

    private void deleteItemRequest(DeleteItemRequestEvent event) {
        StatusMonitor monitor = new StatusMonitor();
        DataMinerPortletServiceAsync.INSTANCE.deleteItem(event.getItemDescription(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void fireRefreshDataMinerWorkAreaEvent(DataMinerWorkAreaElementType dataMinerWorkAreaElementType) {
        RefreshDataMinerWorkAreaEvent refreshEvent = new RefreshDataMinerWorkAreaEvent(dataMinerWorkAreaElementType);
        EventBusProvider.INSTANCE.fireEvent((GwtEvent)refreshEvent);
    }

    private void manageOutputDataRequestEvent(OutputDataRequestEvent event) {
        if (event == null) {
            UtilsGXT3.alert((String)"Error", (String)"Invalid output request!");
        } else if (event.getComputationId() == null || event.getComputationId().getId() == null || event.getComputationId().getId().isEmpty()) {
            UtilsGXT3.alert((String)"Error", (String)("Invalid output request, computation id: " + event.getComputationId()));
        } else {
            StatusMonitor monitor = new StatusMonitor();
            DataMinerPortletServiceAsync.INSTANCE.getOutputDataByComputationId(event.getComputationId(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void fireOutputDataEvent(OutputData outputData) {
        OutputDataEvent event = new OutputDataEvent(outputData);
        EventBusProvider.INSTANCE.fireEvent((GwtEvent)event);
    }

    private void manageComputationDataRequestEvent(ComputationDataRequestEvent event) {
        if (event == null) {
            UtilsGXT3.alert((String)"Error", (String)"Invalid computation info request!");
        } else if (event.getItemDescription() == null || event.getItemDescription().getId() == null || event.getItemDescription().getId().isEmpty()) {
            UtilsGXT3.alert((String)"Error", (String)("Invalid computation info request, item description: " + event.getItemDescription()));
        } else {
            StatusMonitor monitor = new StatusMonitor();
            DataMinerPortletServiceAsync.INSTANCE.getComputationData(event.getItemDescription(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void fireComputationDataEvent(ComputationData computationData) {
        ComputationDataEvent event = new ComputationDataEvent(computationData);
        EventBusProvider.INSTANCE.fireEvent((GwtEvent)event);
    }

    static /* synthetic */ void access$000(DataMinerManagerController x0) {
        x0.sessionExpiredShow();
    }

    static /* synthetic */ void access$100(DataMinerManagerController x0, MenuEvent x1) {
        x0.manageMenuEvent(x1);
    }

    static /* synthetic */ void access$200(DataMinerManagerController x0, StartComputationExecutionRequestEvent x1) {
        x0.startComputationRequest(x1);
    }

    static /* synthetic */ void access$300(DataMinerManagerController x0, CancelComputationExecutionRequestEvent x1) {
        x0.cancelComputationRequest(x1);
    }

    static /* synthetic */ void access$400(DataMinerManagerController x0, CancelExecutionFromComputationsRequestEvent x1) {
        x0.cancelExecutionFromComputationsRequest(x1);
    }

    static /* synthetic */ void access$500(DataMinerManagerController x0, ResubmitComputationExecutionRequestEvent x1) {
        x0.resubmitComputationRequest(x1);
    }

    static /* synthetic */ void access$600(DataMinerManagerController x0, OutputDataRequestEvent x1) {
        x0.manageOutputDataRequestEvent(x1);
    }

    static /* synthetic */ void access$700(DataMinerManagerController x0, ComputationDataRequestEvent x1) {
        x0.manageComputationDataRequestEvent(x1);
    }

    static /* synthetic */ void access$800(DataMinerManagerController x0, OperatorsClassificationRequestEvent x1) {
        x0.operatorsClassificationRequest(x1);
    }

    static /* synthetic */ void access$900(DataMinerManagerController x0, DeleteItemRequestEvent x1) {
        x0.deleteItemRequest(x1);
    }

    static /* synthetic */ void access$1000(DataMinerManagerController x0, DataMinerWorkAreaRequestEvent x1) {
        x0.retrieveDataMinerWorkArea(x1);
    }

    static /* synthetic */ void access$1100(DataMinerManagerController x0, ServiceInfoRequestEvent x1) {
        x0.retrieveEnvironment(x1);
    }

    static /* synthetic */ UserInfo access$1202(DataMinerManagerController x0, UserInfo x1) {
        x0.userInfo = x1;
        return x0.userInfo;
    }

    static /* synthetic */ UserInfo access$1200(DataMinerManagerController x0) {
        return x0.userInfo;
    }

    static /* synthetic */ void access$1300(DataMinerManagerController x0, ComputationId x1, int x2) {
        x0.startComputation(x1, x2);
    }

    static /* synthetic */ void access$1400(DataMinerManagerController x0, DataMinerWorkAreaElementType x1) {
        x0.fireRefreshDataMinerWorkAreaEvent(x1);
    }

    static /* synthetic */ void access$1500(DataMinerManagerController x0, ComputationId x1) {
        x0.resubmitComputation(x1);
    }

    static /* synthetic */ List access$1602(DataMinerManagerController x0, List x1) {
        x0.operatorsClassifications = x1;
        return x0.operatorsClassifications;
    }

    static /* synthetic */ void access$1700(DataMinerManagerController x0, OperatorsClassificationRequestEvent x1) {
        x0.organizesOperatorsClassification(x1);
    }

    static /* synthetic */ void access$1800(DataMinerManagerController x0, DataMinerWorkAreaRequestEvent x1, DataMinerWorkArea x2) {
        x0.fireDataMinerWorkAreaEventRetrieved(x1, x2);
    }

    static /* synthetic */ void access$1900(DataMinerManagerController x0, OutputData x1) {
        x0.fireOutputDataEvent(x1);
    }

    static /* synthetic */ void access$2000(DataMinerManagerController x0, ComputationData x1) {
        x0.fireComputationDataEvent(x1);
    }
}

