/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.dataminermanager.client.parametersfield;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.user.client.ui.Widget;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.widget.core.client.container.BoxLayoutContainer;
import com.sencha.gxt.widget.core.client.container.HBoxLayoutContainer;
import com.sencha.gxt.widget.core.client.container.HtmlLayoutContainer;
import com.sencha.gxt.widget.core.client.container.MarginData;
import com.sencha.gxt.widget.core.client.container.SimpleContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import java.util.ArrayList;
import java.util.List;
import org.gcube.data.analysis.dataminermanagercl.shared.parameters.Parameter;
import org.gcube.data.analysis.dataminermanagercl.shared.parameters.TabularListParameter;
import org.gcube.data.analysis.dataminermanagercl.shared.parameters.TabularParameter;
import org.gcube.portlets.user.dataminermanager.client.parametersfield.AbstractFld;
import org.gcube.portlets.user.dataminermanager.client.parametersfield.TabItem;

public class TabularListFld
extends AbstractFld {
    private SimpleContainer fieldContainer;
    private HBoxLayoutContainer horiz;
    private SimpleContainer listContainer;
    private List<TabItem> items;
    private VerticalLayoutContainer vp;
    private TabularListParameter tabularListParameter;

    public TabularListFld(Parameter parameter) {
        super(parameter);
        Log.debug((String)"TabularListField");
        try {
            this.tabularListParameter = (TabularListParameter)parameter;
            this.createField();
        }
        catch (Throwable e) {
            Log.error((String)("TabularListField: " + e.getLocalizedMessage()));
            e.printStackTrace();
        }
    }

    private void createField() {
        HtmlLayoutContainer descr;
        this.vp = new VerticalLayoutContainer();
        this.items = new ArrayList();
        this.listContainer = new SimpleContainer();
        this.listContainer.add((Widget)this.vp, new MarginData(new Margins(0)));
        this.fieldContainer = new SimpleContainer();
        this.horiz = new HBoxLayoutContainer();
        this.horiz.setPack(BoxLayoutContainer.BoxLayoutPack.START);
        this.horiz.setEnableOverflow(false);
        if (this.tabularListParameter.getDescription() == null) {
            descr = new HtmlLayoutContainer("<p style='margin-left:5px !important;'></p>");
            descr.addStyleName("workflow-fieldDescription");
        } else {
            descr = new HtmlLayoutContainer("<p style='margin-left:5px !important;'>" + this.tabularListParameter.getDescription() + "</p>");
            descr.addStyleName("workflow-fieldDescription");
        }
        this.horiz.add((Widget)this.listContainer);
        this.horiz.add((Widget)descr);
        this.fieldContainer.add((Widget)this.horiz, new MarginData(new Margins(0)));
        this.fieldContainer.forceLayout();
        this.addField(null);
    }

    protected void addField(TabItem upperItem) {
        try {
            TabularParameter tabPar = new TabularParameter(this.tabularListParameter.getName(), this.tabularListParameter.getDescription(), null, this.tabularListParameter.getTemplates(), this.tabularListParameter.getDefaultMimeType(), this.tabularListParameter.getSupportedMimeTypes());
            if (upperItem == null) {
                TabItem item = new TabItem(this, tabPar, true);
                this.items.add(item);
                this.vp.add((Widget)item);
            } else {
                int pos = this.items.indexOf(upperItem);
                if (pos > -1) {
                    upperItem.showCancelButton();
                    upperItem.forceLayout();
                    TabItem item = new TabItem(this, tabPar, false);
                    this.items.add(pos + 1, item);
                    this.vp.insert((Widget)item, pos + 1);
                } else {
                    upperItem.forceLayout();
                    TabItem item = new TabItem(this, tabPar, true);
                    this.items.add(item);
                    this.vp.add((Widget)item);
                }
            }
            this.forceLayout();
        }
        catch (Throwable e) {
            Log.error((String)e.getLocalizedMessage());
            e.printStackTrace();
        }
    }

    protected void removeField(TabItem item) {
        this.items.remove(item);
        if (this.items.size() == 1) {
            ((TabItem)this.items.get(0)).hideCancelButton();
            ((TabItem)this.items.get(0)).forceLayout();
        }
        this.vp.remove((Widget)item);
        this.forceLayout();
    }

    protected void forceLayout() {
        this.vp.forceLayout();
        this.listContainer.forceLayout();
        this.horiz.forceLayout();
        this.fieldContainer.forceLayout();
    }

    public String getValue() {
        String separator = this.tabularListParameter.getSeparator();
        String value = "";
        boolean first = true;
        for (TabItem item : this.items) {
            String itemValue = item.getValue();
            if (itemValue == null || itemValue.contentEquals("")) continue;
            value = value + (first ? "" : separator) + itemValue;
            first = false;
        }
        return value;
    }

    public Widget getWidget() {
        return this.fieldContainer;
    }

    public boolean isValid() {
        boolean valid = false;
        for (TabItem item : this.items) {
            if (!item.isValid()) continue;
            valid = true;
            break;
        }
        return valid;
    }
}

