/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.dataminermanager.client.experiments;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.widget.core.client.container.HtmlLayoutContainer;
import com.sencha.gxt.widget.core.client.container.SimpleContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gcube.data.analysis.dataminermanagercl.shared.data.computations.ComputationId;
import org.gcube.data.analysis.dataminermanagercl.shared.data.output.FileResource;
import org.gcube.data.analysis.dataminermanagercl.shared.data.output.ImageResource;
import org.gcube.data.analysis.dataminermanagercl.shared.data.output.MapResource;
import org.gcube.data.analysis.dataminermanagercl.shared.data.output.ObjectResource;
import org.gcube.data.analysis.dataminermanagercl.shared.data.output.Resource;
import org.gcube.data.analysis.dataminermanagercl.shared.data.output.TableResource;
import org.gcube.portlets.user.dataminermanager.client.common.EventBusProvider;
import org.gcube.portlets.user.dataminermanager.client.events.OutputDataEvent;
import org.gcube.portlets.user.dataminermanager.client.events.OutputDataRequestEvent;
import org.gcube.portlets.user.dataminermanager.client.experiments.ComputationOutputPanel;
import org.gcube.portlets.user.dataminermanager.client.util.UtilsGXT3;
import org.gcube.portlets.user.dataminermanager.client.widgets.FileViewer;
import org.gcube.portlets.user.dataminermanager.client.widgets.ImageViewer;
import org.gcube.portlets.user.dataminermanager.client.widgets.ResourceViewer;

public class ComputationOutputPanel
extends SimpleContainer {
    private ComputationId computationId;
    private VerticalLayoutContainer v;

    public ComputationOutputPanel(ComputationId computationId) {
        this.computationId = computationId;
        Log.debug((String)("ComputationOutputPanel: " + computationId));
        this.bind();
        this.init();
        OutputDataRequestEvent event = new OutputDataRequestEvent(computationId);
        EventBusProvider.INSTANCE.fireEvent((GwtEvent)event);
    }

    private void init() {
        this.v = new VerticalLayoutContainer();
        this.add((Widget)this.v);
    }

    private void bind() {
        EventBusProvider.INSTANCE.addHandler(OutputDataEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void manageOutputDataEvent(OutputDataEvent event) {
        try {
            if (event == null || event.getOutputData() == null) {
                Log.error((String)"OutputDataEvent is null");
                UtilsGXT3.alert((String)"Error", (String)"Invalid output data!");
                return;
            }
            Resource resource = event.getOutputData().getResource();
            this.showResource(resource);
        }
        catch (Throwable e) {
            Log.error((String)("Error in show output info: " + e.getLocalizedMessage()));
            e.printStackTrace();
        }
    }

    private void showResource(Resource resource) {
        try {
            Log.info((String)("Show Output Info on: " + resource));
            if (resource == null) {
                Log.debug((String)"Output Data hasn't resource!");
                return;
            }
            Resource.ResourceType resourceType = resource.getResourceType();
            switch (2.$SwitchMap$org$gcube$data$analysis$dataminermanagercl$shared$data$output$Resource$ResourceType[resourceType.ordinal()]) {
                case 1: {
                    FileResource fileResource = (FileResource)resource;
                    this.v.add((IsWidget)this.getHtmlTitle("The algorithm produced a", "File"), new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0)));
                    this.v.add((IsWidget)this.getFileResourceOutput(fileResource), new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0)));
                    break;
                }
                case 2: {
                    this.v.add((IsWidget)this.getHtmlTitle("The algorithm produced a", "Table"), new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0)));
                    break;
                }
                case 3: {
                    this.v.add((IsWidget)this.getHtmlTitle("The algorithm produced an", "Set of Images"), new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0)));
                    ImageResource imagesResource = (ImageResource)resource;
                    this.v.add((IsWidget)this.getImagesResourceOutput(imagesResource), new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0)));
                    break;
                }
                case 4: {
                    this.v.add((IsWidget)this.getHtmlTitle("The algorithm produced ", "Multiple Results"), new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0)));
                    MapResource mapResource = (MapResource)resource;
                    this.v.add((IsWidget)this.getMultipleOutput(mapResource), new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0)));
                    break;
                }
                case 5: {
                    break;
                }
            }
            this.forceLayout();
        }
        catch (Throwable e) {
            Log.error((String)("Error in show resource: " + e.getLocalizedMessage()));
            e.printStackTrace();
        }
    }

    private HtmlLayoutContainer getHtmlTitle(String intro, String produced) {
        TitleTemplate templates = (TitleTemplate)GWT.create(TitleTemplate.class);
        HtmlLayoutContainer c = new HtmlLayoutContainer(templates.getTemplate(intro, produced));
        return c;
    }

    private SimpleContainer getImagesResourceOutput(ImageResource imagesResource) {
        return new ImageViewer(this.computationId, imagesResource);
    }

    private SimpleContainer getFileResourceOutput(FileResource fileResource) {
        return new FileViewer(this.computationId, fileResource);
    }

    private SimpleContainer getMultipleOutput(MapResource mapResource) {
        HtmlLayoutContainer html;
        Map map = mapResource.getMap();
        VerticalLayoutContainer vp = new VerticalLayoutContainer();
        SimpleContainer container = new SimpleContainer();
        LinkedHashMap<String, ObjectResource> mapValues = new LinkedHashMap<String, ObjectResource>();
        LinkedHashMap<String, FileResource> mapFiles = new LinkedHashMap<String, FileResource>();
        LinkedHashMap<String, TableResource> mapTabs = new LinkedHashMap<String, TableResource>();
        LinkedHashMap<String, ImageResource> mapImages = new LinkedHashMap<String, ImageResource>();
        for (String key : map.keySet()) {
            Resource resource = (Resource)map.get(key);
            Resource.ResourceType resourceType = resource.getResourceType();
            switch (2.$SwitchMap$org$gcube$data$analysis$dataminermanagercl$shared$data$output$Resource$ResourceType[resourceType.ordinal()]) {
                case 5: {
                    mapValues.put(key, (ObjectResource)resource);
                    break;
                }
                case 1: {
                    mapFiles.put(key, (FileResource)resource);
                    break;
                }
                case 2: {
                    mapTabs.put(key, (TableResource)resource);
                    break;
                }
                case 3: {
                    mapImages.put(key, (ImageResource)resource);
                    break;
                }
                case 4: {
                    break;
                }
            }
        }
        if (mapValues.size() > 0) {
            html = new HtmlLayoutContainer("Output Values");
            html.setStyleName("computation-output-groupTitle");
            vp.add((IsWidget)html, new VerticalLayoutContainer.VerticalLayoutData(-1.0, -1.0, new Margins(0)));
            vp.add((IsWidget)new ResourceViewer(mapValues).getHtml(), new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0)));
            html = new HtmlLayoutContainer("<div class='computation-output-separator'></div>");
            vp.add((IsWidget)html, new VerticalLayoutContainer.VerticalLayoutData(-1.0, -1.0, new Margins(0)));
        }
        if (mapFiles.size() > 0) {
            html = new HtmlLayoutContainer("Files");
            html.setStyleName("computation-output-groupTitle");
            vp.add((IsWidget)html, new VerticalLayoutContainer.VerticalLayoutData(-1.0, -1.0, new Margins(0)));
            for (String fileKey : mapFiles.keySet()) {
                vp.add((IsWidget)this.getFileResourceOutput((FileResource)mapFiles.get(fileKey)), new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0)));
            }
            html = new HtmlLayoutContainer("<div class='computation-output-separator'></div>");
            vp.add((IsWidget)html, new VerticalLayoutContainer.VerticalLayoutData(-1.0, -1.0, new Margins(0)));
        }
        if (mapTabs.size() > 0) {
            html = new HtmlLayoutContainer("Tables");
            html.setStyleName("computation-output-groupTitle");
            vp.add((IsWidget)html, new VerticalLayoutContainer.VerticalLayoutData(-1.0, -1.0, new Margins(0)));
            html = new HtmlLayoutContainer("<div class='computation-output-separator'></div>");
            vp.add((IsWidget)html, new VerticalLayoutContainer.VerticalLayoutData(-1.0, -1.0, new Margins(0)));
        }
        if (mapImages.size() > 0) {
            html = new HtmlLayoutContainer("Images");
            html.setStyleName("computation-output-groupTitle");
            vp.add((IsWidget)html, new VerticalLayoutContainer.VerticalLayoutData(-1.0, -1.0, new Margins(0)));
            for (String imagesKey : mapImages.keySet()) {
                vp.add((IsWidget)this.getImagesResourceOutput((ImageResource)mapImages.get(imagesKey)), new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0)));
            }
            html = new HtmlLayoutContainer("<div class='computation-output-separator'></div>");
            vp.add((IsWidget)html, new VerticalLayoutContainer.VerticalLayoutData(-1.0, -1.0, new Margins(0)));
        }
        container.add((Widget)vp);
        return container;
    }

    static /* synthetic */ ComputationId access$000(ComputationOutputPanel x0) {
        return x0.computationId;
    }

    static /* synthetic */ void access$100(ComputationOutputPanel x0, OutputDataEvent x1) {
        x0.manageOutputDataEvent(x1);
    }
}

