/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.dataminermanager.client.experiments;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.sencha.gxt.core.client.dom.ScrollSupport;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.widget.core.client.FramedPanel;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.container.SimpleContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.menu.Menu;
import com.sencha.gxt.widget.core.client.menu.MenuItem;
import com.sencha.gxt.widget.core.client.toolbar.ToolBar;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.data.analysis.dataminermanagercl.shared.perspective.PerspectiveType;
import org.gcube.data.analysis.dataminermanagercl.shared.process.Operator;
import org.gcube.data.analysis.dataminermanagercl.shared.process.OperatorCategory;
import org.gcube.data.analysis.dataminermanagercl.shared.process.OperatorsClassification;
import org.gcube.portlets.user.dataminermanager.client.DataMinerManager;
import org.gcube.portlets.user.dataminermanager.client.common.EventBusProvider;
import org.gcube.portlets.user.dataminermanager.client.events.OperatorsClassificationEvent;
import org.gcube.portlets.user.dataminermanager.client.events.OperatorsClassificationRequestEvent;
import org.gcube.portlets.user.dataminermanager.client.experiments.OperatorCategoryPanel;
import org.gcube.portlets.user.dataminermanager.client.experiments.OperatorPanel;
import org.gcube.portlets.user.dataminermanager.client.experiments.OperatorsPanel;
import org.gcube.portlets.user.dataminermanager.client.experiments.OperatorsPanelHandler;
import org.gcube.portlets.user.dataminermanager.client.type.OperatorsClassificationRequestType;

public class OperatorsPanel
extends FramedPanel {
    private static final String LOADING_MESSAGE = "Loading Operators...";
    private static final String SHOW_ALL_OPERATORS_TOOLTIP = "Show all Operators without category classification.";
    private static final String SHOW_CATEGORIES_TOOLTIP = "Show Operators by Categories";
    private static final String REFRESH_OPERATORS_TOOLTIP = "Refresh Operators List";
    private OperatorsPanelHandler handler;
    private VerticalLayoutContainer topV;
    private ToolBar toolBar;
    private VerticalLayoutContainer v;
    private OperatorsClassification operatorsClassification;
    private List<Operator> operators;
    private Map<PerspectiveType, List<OperatorCategoryPanel>> mapCategoriesPanels = new HashMap();
    private View view = null;
    private PerspectiveType currentPerspectiveType = PerspectiveType.User;

    public OperatorsPanel(OperatorsPanelHandler handler) {
        this.handler = handler;
        this.operators = new ArrayList();
        this.init();
        this.bind();
        this.create();
    }

    private void init() {
        this.setHeadingText("Operators");
        this.setBodyStyle("backgroundColor:white;");
        this.setCollapsible(true);
    }

    private void bind() {
        EventBusProvider.INSTANCE.addHandler(OperatorsClassificationEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void manageOperatorsClassificationEvent(OperatorsClassificationEvent event) {
        try {
            Log.debug((String)("Manage Operators: " + event));
            if (event.getOperatorsClassificationRequestType().compareTo((Enum)OperatorsClassificationRequestType.ByName) == 0) {
                Log.debug((String)("Current classification name: " + this.currentPerspectiveType));
                if (this.currentPerspectiveType.compareTo((Enum)event.getPerspectiveType()) == 0) {
                    this.waitMessage(false);
                    if (event.getOperatorsClassification() != null) {
                        List<OperatorCategoryPanel> categoryPanels;
                        this.operatorsClassification = event.getOperatorsClassification();
                        this.operators.clear();
                        this.operators.addAll(event.getOperatorsClassification().getOperators());
                        String operatorId = event.getOperatorId();
                        Log.debug((String)"ShowCategoriesList");
                        if (event.isRefresh()) {
                            categoryPanels = new ArrayList();
                            if (this.operatorsClassification != null) {
                                for (OperatorCategory cat : this.operatorsClassification.getOperatorCategories()) {
                                    categoryPanels.add(new OperatorCategoryPanel(this.handler, cat));
                                }
                            }
                            this.mapCategoriesPanels.put(this.currentPerspectiveType, categoryPanels);
                        } else {
                            categoryPanels = (List)this.mapCategoriesPanels.get(this.currentPerspectiveType);
                            if (categoryPanels == null) {
                                categoryPanels = new ArrayList();
                                if (this.operatorsClassification != null) {
                                    for (OperatorCategory cat : this.operatorsClassification.getOperatorCategories()) {
                                        categoryPanels.add(new OperatorCategoryPanel(this.handler, cat));
                                    }
                                }
                                this.mapCategoriesPanels.put(this.currentPerspectiveType, categoryPanels);
                            }
                        }
                        this.v.clear();
                        for (OperatorCategoryPanel panel : categoryPanels) {
                            this.v.add((Widget)panel);
                        }
                        this.view = View.CATEGORIES;
                        if (operatorId != null && !operatorId.isEmpty()) {
                            OperatorCategory operatorCategoryDefault = null;
                            Operator operatorDefault = null;
                            for (Operator op : this.operators) {
                                if (op.getId().compareTo(operatorId) != 0) continue;
                                operatorDefault = op;
                                operatorCategoryDefault = op.getCategory();
                                break;
                            }
                            if (operatorCategoryDefault != null) {
                                for (OperatorCategoryPanel opCategoryPanel : categoryPanels) {
                                    if (opCategoryPanel.getCategory().compareTo(operatorCategoryDefault) != 0) continue;
                                    opCategoryPanel.setOperatorDefault(operatorDefault);
                                    break;
                                }
                            }
                        }
                        Log.debug((String)"Refresh OperatorsPanel");
                        this.forceLayout();
                    }
                }
            }
        }
        catch (Throwable e) {
            Log.error((String)("Error in OperatorsPanel: " + e.getLocalizedMessage()), (Throwable)e);
            e.printStackTrace();
        }
    }

    private void create() {
        this.topV = new VerticalLayoutContainer();
        this.initToolbar();
        this.topV.add((IsWidget)this.toolBar, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0)));
        SimpleContainer operators = new SimpleContainer();
        this.v = new VerticalLayoutContainer();
        this.v.setScrollMode(ScrollSupport.ScrollMode.AUTO);
        operators.add((Widget)this.v);
        this.topV.add((IsWidget)operators, new VerticalLayoutContainer.VerticalLayoutData(1.0, 1.0, new Margins(0)));
        this.add((Widget)this.topV);
        this.waitMessage(true);
        OperatorsClassificationRequestEvent operatorsClassificationRequestEvent = new OperatorsClassificationRequestEvent(OperatorsClassificationRequestType.ByName, this.currentPerspectiveType, true, false);
        Log.debug((String)("OperatorsPanel fire: " + operatorsClassificationRequestEvent));
        EventBusProvider.INSTANCE.fireEvent((GwtEvent)operatorsClassificationRequestEvent);
    }

    private void initToolbar() {
        this.toolBar = new ToolBar();
        2 filterField = new /* Unavailable Anonymous Inner Class!! */;
        filterField.addKeyUpHandler((KeyUpHandler)new /* Unavailable Anonymous Inner Class!! */);
        filterField.setWidth(100);
        TextButton refreshOperatorsButton = new TextButton();
        refreshOperatorsButton.setIcon(DataMinerManager.resources.refresh());
        refreshOperatorsButton.addSelectHandler((SelectEvent.SelectHandler)new /* Unavailable Anonymous Inner Class!! */);
        refreshOperatorsButton.setToolTip(REFRESH_OPERATORS_TOOLTIP);
        TextButton showCategoriesButton = new TextButton();
        showCategoriesButton.setIcon(DataMinerManager.resources.tree());
        showCategoriesButton.addSelectHandler((SelectEvent.SelectHandler)new /* Unavailable Anonymous Inner Class!! */);
        showCategoriesButton.setToolTip(SHOW_CATEGORIES_TOOLTIP);
        TextButton showAllOperatorsButton = new TextButton();
        showAllOperatorsButton.setIcon(DataMinerManager.resources.sortAscending());
        showAllOperatorsButton.addSelectHandler((SelectEvent.SelectHandler)new /* Unavailable Anonymous Inner Class!! */);
        showAllOperatorsButton.setToolTip(SHOW_ALL_OPERATORS_TOOLTIP);
        TextButton btnMenuPerspective = new TextButton(this.currentPerspectiveType.getLabel());
        btnMenuPerspective.setIcon(DataMinerManager.resources.userPerspective());
        btnMenuPerspective.setToolTip(this.currentPerspectiveType.getPerspective());
        Menu menuPerspective = new Menu();
        ImageResource img = DataMinerManager.resources.userPerspective();
        MenuItem perspectiveItem = new MenuItem(PerspectiveType.User.getLabel());
        perspectiveItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        perspectiveItem.setIcon(img);
        perspectiveItem.setToolTip(PerspectiveType.User.getPerspective());
        menuPerspective.add((Widget)perspectiveItem);
        btnMenuPerspective.setMenu(menuPerspective);
        this.toolBar.add((Widget)refreshOperatorsButton);
        this.toolBar.add((Widget)showCategoriesButton);
        this.toolBar.add((Widget)showAllOperatorsButton);
        this.toolBar.add((Widget)filterField);
        this.toolBar.add((Widget)btnMenuPerspective);
    }

    private void waitMessage(boolean show) {
        if (show) {
            this.mask(LOADING_MESSAGE);
        } else {
            this.unmask();
        }
    }

    private void showFilteredList(String searchText) {
        ArrayList<Operator> filteredOperators = new ArrayList<Operator>();
        ArrayList<String> ids = new ArrayList<String>();
        for (Operator op : this.operators) {
            if (!op.getName().toLowerCase().contains(searchText.toLowerCase()) || ids.contains(op.getId())) continue;
            filteredOperators.add(op);
            ids.add(op.getId());
        }
        this.v.clear();
        HTML html = new HTML("Filtered results <span class='counter'>(" + filteredOperators.size() + " item" + (filteredOperators.size() == 1 ? "" : "s") + " found)</span>");
        html.addStyleName("filterResultText");
        this.v.add((Widget)html);
        for (Operator op : filteredOperators) {
            this.v.add((Widget)new OperatorPanel(op, this.handler));
        }
        this.view = View.FILTER;
        this.forceLayout();
    }

    private void refreshOperatorsList() {
        this.waitMessage(true);
        OperatorsClassificationRequestEvent operatorsClassificationRequestEvent = new OperatorsClassificationRequestEvent(OperatorsClassificationRequestType.ByName, this.currentPerspectiveType, true, true);
        Log.debug((String)("OperatorsPanel fire: " + operatorsClassificationRequestEvent));
        EventBusProvider.INSTANCE.fireEvent((GwtEvent)operatorsClassificationRequestEvent);
    }

    private void showCategoriesList(boolean force) {
        try {
            if (force || this.view != View.CATEGORIES) {
                Log.debug((String)"ShowCategoriesList");
                ArrayList<OperatorCategoryPanel> categoryPanels = (ArrayList<OperatorCategoryPanel>)this.mapCategoriesPanels.get(this.currentPerspectiveType);
                if (categoryPanels == null) {
                    categoryPanels = new ArrayList<OperatorCategoryPanel>();
                    if (this.operatorsClassification != null) {
                        for (OperatorCategory cat : this.operatorsClassification.getOperatorCategories()) {
                            categoryPanels.add(new OperatorCategoryPanel(this.handler, cat));
                        }
                    }
                    this.mapCategoriesPanels.put(this.currentPerspectiveType, categoryPanels);
                }
                this.v.clear();
                for (OperatorCategoryPanel panel : categoryPanels) {
                    this.v.add((Widget)panel);
                }
                this.view = View.CATEGORIES;
                this.forceLayout();
            }
        }
        catch (Throwable e) {
            Log.error((String)e.getLocalizedMessage());
            e.printStackTrace();
        }
    }

    private void showAllOperatorsList() {
        if (this.view != View.ALL) {
            this.v.clear();
            HTML html = new HTML("All Operators <span class='counter'>(" + this.operators.size() + " item" + (this.operators.size() == 1 ? "" : "s") + " found)</span>");
            html.addStyleName("filterResultText");
            this.v.add((Widget)html);
            for (Operator op : this.operators) {
                this.v.add((Widget)new OperatorPanel(op, this.handler));
            }
            this.view = View.ALL;
            this.forceLayout();
        }
    }

    static /* synthetic */ void access$000(OperatorsPanel x0, OperatorsClassificationEvent x1) {
        x0.manageOperatorsClassificationEvent(x1);
    }

    static /* synthetic */ void access$100(OperatorsPanel x0, boolean x1) {
        x0.showCategoriesList(x1);
    }

    static /* synthetic */ void access$200(OperatorsPanel x0, String x1) {
        x0.showFilteredList(x1);
    }

    static /* synthetic */ void access$300(OperatorsPanel x0) {
        x0.refreshOperatorsList();
    }

    static /* synthetic */ void access$400(OperatorsPanel x0) {
        x0.showAllOperatorsList();
    }

    static /* synthetic */ PerspectiveType access$502(OperatorsPanel x0, PerspectiveType x1) {
        x0.currentPerspectiveType = x1;
        return x0.currentPerspectiveType;
    }
}

