/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.dataminermanagertester.client.application.testconfig;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.gwtplatform.mvp.client.ViewWithUiHandlers;
import gwt.material.design.client.constants.Color;
import gwt.material.design.client.constants.IconType;
import gwt.material.design.client.ui.MaterialButton;
import gwt.material.design.client.ui.MaterialListBox;
import gwt.material.design.client.ui.MaterialTextArea;
import gwt.material.design.client.ui.MaterialTextBox;
import gwt.material.design.client.ui.animate.MaterialAnimation;
import gwt.material.design.client.ui.animate.Transition;
import javax.inject.Inject;
import org.gcube.portlets.user.dataminermanagertester.client.application.testconfig.TestConfPresenter;
import org.gcube.portlets.user.dataminermanagertester.client.application.testconfig.TestConfUiHandlers;
import org.gcube.portlets.user.dataminermanagertester.client.application.testconfig.TestConfView;
import org.gcube.portlets.user.dataminermanagertester.shared.config.DMConfig;
import org.gcube.portlets.user.dataminermanagertester.shared.config.ProtocolType;
import org.gcube.portlets.user.dataminermanagertester.shared.config.TestType;

class TestConfView
extends ViewWithUiHandlers<TestConfUiHandlers>
implements TestConfPresenter.PresenterView {
    @UiField
    MaterialTextBox dm;
    @UiField
    MaterialTextBox token;
    @UiField
    MaterialListBox protocolType;
    @UiField
    MaterialListBox testType;
    @UiField
    MaterialTextArea result;
    @UiField
    MaterialButton resultIcon;
    @UiField
    MaterialButton run;

    @Inject
    TestConfView(Binder uiBinder) {
        this.initWidget((IsWidget)uiBinder.createAndBindUi((Object)this));
        this.testType.clear();
        for (TestType testType : TestType.values()) {
            this.testType.add((Object)testType.getLabel());
        }
        this.protocolType.clear();
        for (TestType testType : ProtocolType.values()) {
            this.protocolType.add((Object)testType.getLabel());
        }
        this.dm.setAllowBlank(false);
        this.token.setAllowBlank(false);
    }

    @UiHandler(value={"run"})
    void onClick(ClickEvent e) {
        if (!this.dm.validate() || !this.token.validate()) {
            return;
        }
        String dmValue = (String)this.dm.getValue();
        String tokenValue = (String)this.token.getValue();
        String protocolValue = this.protocolType.getValue();
        String testTypeValue = this.testType.getValue();
        this.resultIcon.setVisible(false);
        this.result.setVisible(false);
        DMConfig dmConfig = new DMConfig(dmValue, tokenValue, protocolValue, testTypeValue);
        ((TestConfUiHandlers)this.getUiHandlers()).executeTest(dmConfig);
    }

    public void setResult(String resultValue, boolean success) {
        this.resultIcon.setVisible(true);
        this.result.setVisible(true);
        if (success) {
            this.resultIcon.setIconType(IconType.CHECK_CIRCLE);
            this.resultIcon.setBackgroundColor(Color.GREEN);
            this.resultIcon.setIconFontSize(4.0, Style.Unit.EM);
        } else {
            this.resultIcon.setIconType(IconType.ERROR);
            this.resultIcon.setBackgroundColor(Color.RED);
            this.resultIcon.setIconFontSize(4.0, Style.Unit.EM);
        }
        MaterialAnimation animation = new MaterialAnimation();
        animation.setDelay(0);
        animation.setDuration(1000);
        animation.transition(Transition.FLIPINX);
        animation.animate((Widget)this.resultIcon);
        this.result.setLength(resultValue.length());
        this.result.setValue((Object)resultValue);
    }
}

