package org.gcube.portlets.user.collectionsviewer.client;


import org.gcube.portlets.user.collectionsviewer.client.view.panels.MainPanel;
import org.gcube.portlets.user.gcubewidgets.client.GCubePanel;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.RootPanel;

/**
 * Entry point classes define <code>onModuleLoad()</code>.
 */
public class CollectionsViewer implements EntryPoint {
	public static final String CONTAINER_DIV = "CollectionViewerDIV";

	
	private MainPanel mainContainer;
	/**
	 * This is the entry point method.
	 */
	public void onModuleLoad() {
		
		GCubePanel gcubePanel = new GCubePanel("Collections Viewer","https://gcube.wiki.gcube-system.org/gcube/index.php/Developer%27s_Guide");
		
		mainContainer = new MainPanel();
		gcubePanel.add(mainContainer); 
		RootPanel.get(CONTAINER_DIV).add(gcubePanel);
		
		Window.addResizeHandler(new ResizeHandler() {
			
			public void onResize(ResizeEvent event) {
				updateSize();
				
			}
		});
		updateSize();
	}
	/**
	 * updateSize
	 */
	public void updateSize() {
		RootPanel containerDIV = RootPanel.get(CONTAINER_DIV);
		int topBorder = containerDIV.getAbsoluteTop();
		int leftBorder = containerDIV.getAbsoluteLeft();
		int rightScrollBar = 17;
		int rootHeight = Window.getClientHeight() - topBorder - 4;
		int rootWidth = containerDIV.getOffsetWidth();
		mainContainer.setHeight(rootHeight-30);
		mainContainer.setWidth(rootWidth);

	}
	
}