/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.accountingdashboard.client.application.mainarea.filter;

import com.github.gwtbootstrap.client.ui.ControlGroup;
import com.github.gwtbootstrap.client.ui.ListBox;
import com.github.gwtbootstrap.client.ui.RadioButton;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.cellview.client.CellTree;
import com.google.gwt.user.cellview.client.TreeNode;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.TreeViewModel;
import com.gwtplatform.mvp.client.UiHandlers;
import com.gwtplatform.mvp.client.ViewWithUiHandlers;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.gcube.portlets.user.accountingdashboard.client.application.event.RequestReportEvent;
import org.gcube.portlets.user.accountingdashboard.client.application.mainarea.filter.FilterAreaPresenter;
import org.gcube.portlets.user.accountingdashboard.client.application.mainarea.filter.FilterAreaView;
import org.gcube.portlets.user.accountingdashboard.client.application.mainarea.filter.scopetree.ScopeTreeModel;
import org.gcube.portlets.user.accountingdashboard.client.resources.AppResources;
import org.gcube.portlets.user.accountingdashboard.client.resources.ScopeTreeResources;
import org.gcube.portlets.user.accountingdashboard.shared.data.RequestReportData;
import org.gcube.portlets.user.accountingdashboard.shared.data.ScopeData;
import org.gcube.portlets.user.accountingdashboard.shared.env.EnvironmentData;

public class FilterAreaView
extends ViewWithUiHandlers<FilterAreaPresenter>
implements FilterAreaPresenter.FilterAreaView {
    private static Logger logger = Logger.getLogger("");
    @UiField
    HTMLPanel periodPanel;
    @UiField
    HTMLPanel explorePanel;
    @UiField(provided=true)
    ListBox yearStart;
    @UiField(provided=true)
    ListBox monthStart;
    @UiField(provided=true)
    ListBox yearEnd;
    @UiField(provided=true)
    ListBox monthEnd;
    @UiField(provided=false)
    ControlGroup cgDetachedREs;
    @UiField(provided=true)
    RadioButton btnShowDetachedREs;
    @UiField(provided=true)
    RadioButton btnHideDetachedREs;
    @UiField(provided=true)
    CellTree scopeTree;
    private ListDataProvider<ScopeData> dataProvider;
    private ScopeTreeModel scopeTreeModel;
    private AppResources resources;
    private ScopeData scopeData;

    @Inject
    FilterAreaView(Binder uiBinder, AppResources resources) {
        this.resources = resources;
        this.init();
        this.initWidget((IsWidget)uiBinder.createAndBindUi((Object)this));
    }

    private void init() {
        this.yearStart = new ListBox();
        this.yearStart.setMultipleSelect(false);
        this.yearEnd = new ListBox();
        this.yearEnd.setMultipleSelect(false);
        Date now = new Date();
        String currentYear = DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.YEAR).format(now);
        logger.log(Level.FINE, "Current year: " + currentYear);
        int year = Integer.parseInt(currentYear);
        for (int i = 2015; i <= year; ++i) {
            this.yearStart.addItem(String.valueOf(i));
            this.yearEnd.addItem(String.valueOf(i));
        }
        String yearStartDefaultValue = year == 2015 ? "2015" : String.valueOf(year - 1);
        this.yearStart.setSelectedValue(yearStartDefaultValue);
        this.yearEnd.setSelectedValue(String.valueOf(year));
        this.yearStart.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.yearEnd.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        String[] months = LocaleInfo.getCurrentLocale().getDateTimeFormatInfo().monthsFull();
        logger.log(Level.FINE, "Months: " + months.length);
        this.monthStart = new ListBox();
        this.monthStart.setMultipleSelect(false);
        this.monthEnd = new ListBox();
        this.monthEnd.setMultipleSelect(false);
        for (int i = 0; i < months.length; ++i) {
            this.monthStart.addItem(months[i]);
            this.monthEnd.addItem(months[i]);
        }
        String currentMonth = DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.MONTH).format(now);
        this.monthStart.setSelectedValue(currentMonth);
        this.monthEnd.setSelectedValue(currentMonth);
        this.monthStart.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.monthEnd.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        logger.log(Level.FINE, "Configuring buttons DetachedREs");
        this.btnShowDetachedREs = new RadioButton("radioDetachedREs");
        this.btnShowDetachedREs.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.btnHideDetachedREs = new RadioButton("radioDetachedREs");
        this.btnHideDetachedREs.setValue(Boolean.valueOf(true));
        this.btnHideDetachedREs.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        logger.log(Level.FINE, "Configuring DataProvider");
        this.dataProvider = new ListDataProvider();
        7 handler = new /* Unavailable Anonymous Inner Class!! */;
        this.scopeTreeModel = new ScopeTreeModel(this.dataProvider, (RequestReportEvent.RequestReportEventHandler)handler);
        ScopeTreeResources scopeTreeResources = (ScopeTreeResources)GWT.create(ScopeTreeResources.class);
        this.scopeTree = new CellTree((TreeViewModel)this.scopeTreeModel, null, (CellTree.Resources)scopeTreeResources);
        this.scopeTree.setDefaultNodeSize(500);
        logger.log(Level.FINE, "FilterAreaView init end");
    }

    public void setEnvironment(EnvironmentData environmentData) {
        logger.log(Level.FINE, "displayScopeData()");
        if (environmentData != null && environmentData.getAccountingServiceType() != null) {
            switch (8.$SwitchMap$org$gcube$portlets$user$accountingdashboard$shared$env$AccountingServiceType[environmentData.getAccountingServiceType().ordinal()]) {
                case 1: {
                    this.cgDetachedREs.setVisible(false);
                    break;
                }
                case 2: {
                    this.cgDetachedREs.setVisible(true);
                    break;
                }
                case 3: {
                    this.cgDetachedREs.setVisible(false);
                    break;
                }
                default: {
                    this.cgDetachedREs.setVisible(false);
                    break;
                }
            }
        } else {
            this.cgDetachedREs.setVisible(false);
        }
    }

    public void displayScopeData(ScopeData scopeData) {
        logger.log(Level.FINE, "displayScopeData()");
        ArrayList<ScopeData> scopeDataList = new ArrayList<ScopeData>();
        scopeDataList.add(scopeData);
        this.scopeData = scopeData;
        this.dataProvider.setList(scopeDataList);
        this.dataProvider.refresh();
        this.dataProvider.flush();
        TreeNode root = this.scopeTree.getRootTreeNode();
        root.setChildOpen(root.getIndex(), true);
        this.scopeTreeModel.setSelected(scopeData, true);
        this.requestReport();
    }

    private void requestReport() {
        logger.log(Level.FINE, "requestReport()");
        String[] months = LocaleInfo.getCurrentLocale().getDateTimeFormatInfo().monthsFull();
        logger.log(Level.FINE, "Months: " + months.length);
        String yearS = this.yearStart.getValue();
        String monthS = this.monthStart.getValue();
        String monthSN = null;
        for (int i = 0; i < months.length; ++i) {
            if (months[i].compareTo(monthS) != 0) continue;
            int v = i + 1;
            monthSN = v > 9 ? "" + v : "0" + v;
        }
        String dateStart = yearS + "-" + monthSN + "-01";
        logger.fine("DateStart: " + dateStart);
        String yearE = this.yearEnd.getValue();
        String monthE = this.monthEnd.getValue();
        String monthEN = null;
        for (int i = 0; i < months.length; ++i) {
            if (months[i].compareTo(monthE) != 0) continue;
            int v = i + 1;
            monthEN = v > 9 ? "" + v : "0" + v;
        }
        String dateEnd = yearE + "-" + monthEN + "-01";
        logger.fine("DateEnd: " + dateEnd);
        RequestReportData requestReportData = new RequestReportData(this.scopeData, dateStart, dateEnd);
        ((FilterAreaPresenter)this.getUiHandlers()).getReport(requestReportData);
    }

    static /* synthetic */ void access$000(FilterAreaView x0) {
        x0.requestReport();
    }

    static /* synthetic */ UiHandlers access$100(FilterAreaView x0) {
        return x0.getUiHandlers();
    }

    static /* synthetic */ UiHandlers access$200(FilterAreaView x0) {
        return x0.getUiHandlers();
    }

    static /* synthetic */ ScopeData access$302(FilterAreaView x0, ScopeData x1) {
        x0.scopeData = x1;
        return x0.scopeData;
    }
}

