/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.accountingdashboard.client.application.providers;

import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.Range;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gcube.portlets.user.accountingdashboard.client.application.controller.Controller;
import org.gcube.portlets.user.accountingdashboard.client.application.providers.DeadFishBySpecificDiseasesProvider;
import org.gcube.portlets.user.accountingdashboard.shared.data.ScopeData;

public class DeadFishBySpecificDiseasesProvider
extends AsyncDataProvider<ScopeData> {
    private static Logger logger = Logger.getLogger("");
    private Controller controller;
    private int start;
    private int length;
    private int columnSortIndex;
    private boolean ascending = false;
    private String id;
    private ArrayList<ScopeData> list;

    @Inject
    public DeadFishBySpecificDiseasesProvider(String id, Controller controller) {
        this.id = id;
        this.controller = controller;
        this.list = new ArrayList();
        this.bindEvents();
    }

    private void bindEvents() {
    }

    private void update(ArrayList<ScopeData> list) {
        logger.log(Level.FINE, "Disease Data Display is empty: " + this.getDataDisplays().isEmpty());
        logger.log(Level.FINE, "Show=[Start=" + this.start + ", Length=" + this.length + "]");
        int limits = this.start + this.length;
        if (limits > list.size() && (limits = list.size()) < this.start) {
            this.start = limits;
        }
        List<Object> dataInRange = new ArrayList();
        if (list != null && list.size() > 1) {
            if (this.columnSortIndex > -1) {
                1 comparator;
                logger.log(Level.FINE, "ColumnSortIndex: " + this.columnSortIndex);
                logger.log(Level.FINE, "Ascending: " + this.ascending);
                switch (this.columnSortIndex) {
                    case 0: {
                        comparator = new /* Unavailable Anonymous Inner Class!! */;
                        break;
                    }
                    default: {
                        comparator = new /* Unavailable Anonymous Inner Class!! */;
                    }
                }
                Collections.sort(list, comparator);
            }
            dataInRange = list.subList(this.start, limits);
        } else {
            dataInRange = list;
        }
        this.updateRowCount(list.size(), true);
        this.updateRowData(this.start, dataInRange);
    }

    protected void onRangeChanged(HasData<ScopeData> display) {
        Range range = display.getVisibleRange();
        this.start = range.getStart();
        this.length = range.getLength();
        logger.log(Level.FINE, "Diseases Provider Range Change: [start=" + this.start + ", length=" + this.length + "]");
        this.retrieveData();
    }

    public void onSortChanged(int start, int length, int columnSortIndex, boolean ascending) {
        logger.log(Level.FINE, "Disease Provider Sort: [start=" + start + ", length=" + length + "]");
        this.start = start;
        this.length = length;
        this.columnSortIndex = columnSortIndex;
        this.ascending = ascending;
        this.retrieveData();
    }

    public void onRefreshDiseases() {
        logger.log(Level.FINE, "Disease Provider Refresh");
        this.retrieveData();
    }

    private void retrieveData() {
        logger.log(Level.FINE, "Disease Provider: " + this.id);
        this.update(this.list);
    }

    public void addNewDisease() {
    }

    static /* synthetic */ boolean access$000(DeadFishBySpecificDiseasesProvider x0) {
        return x0.ascending;
    }
}

