/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.accountingdashboard.server.accounting;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.VirtualHost;
import com.liferay.portal.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.service.VirtualHostLocalServiceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.gcube.accounting.accounting.summary.access.impl.ContextTreeProvider;
import org.gcube.accounting.accounting.summary.access.model.ScopeDescriptor;
import org.gcube.common.portal.PortalContext;
import org.gcube.portlets.user.accountingdashboard.server.accounting.AccountingServiceType;
import org.gcube.portlets.user.accountingdashboard.server.accounting.PortalContextTreeProvider;
import org.gcube.vomanagement.usermanagement.GroupManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.model.GCubeGroup;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.gcube.vomanagement.usermanagement.model.VirtualGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class PortalContextTreeProvider
implements ContextTreeProvider {
    private static GroupManager groupsManager;
    private static Logger logger;
    private AccountingServiceType accountingServiceType;

    public PortalContextTreeProvider(AccountingServiceType accountingServiceType) {
        this.accountingServiceType = accountingServiceType;
    }

    public ScopeDescriptor getTree(Object context) throws Exception {
        if (context == null) {
            throw new Exception("Unable to get tree, Request is null.");
        }
        if (!(context instanceof HttpServletRequest)) {
            throw new Exception("Invalid request object : " + context);
        }
        HttpServletRequest request = (HttpServletRequest)context;
        if (this.accountingServiceType == null) {
            logger.error("Invalid AccountingServiceType requested: null");
        }
        ScopeDescriptor root = null;
        switch (1.$SwitchMap$org$gcube$portlets$user$accountingdashboard$server$accounting$AccountingServiceType[this.accountingServiceType.ordinal()]) {
            case 1: {
                logger.debug("AccountingService: CurrentScope");
                break;
            }
            case 2: {
                logger.debug("AccountingService: PortalContext");
                root = this.recreateTreeForPortalContext(request);
                break;
            }
            case 3: {
                logger.debug("AccountingService: Infrastructure");
                root = this.recreateTreeForInfrastructure(request);
                break;
            }
            default: {
                logger.debug("AccountingService: CurrentScope");
            }
        }
        return root;
    }

    private ScopeDescriptor recreateTreeForInfrastructure(HttpServletRequest request) throws Exception, PortalException, SystemException {
        ScopeDescriptor infra = null;
        PortalContext portalContext = PortalContext.getConfiguration();
        String infrastructureName = portalContext.getInfrastructureName();
        String infrastructureScope = portalContext.getCurrentScope(request);
        infra = new ScopeDescriptor(infrastructureName, infrastructureScope);
        LinkedList<ScopeDescriptor> infraChildren = new LinkedList<ScopeDescriptor>();
        PortalContext pContext = PortalContext.getConfiguration();
        GCubeUser currUser = pContext.getCurrentUser(request);
        List theGateways = new LiferayGroupManager().getGateways();
        for (GCubeGroup gCubeGroup : theGateways) {
            logger.debug("Gateway: [id=" + gCubeGroup.getGroupId() + ", name=" + gCubeGroup.getGroupName() + "]");
        }
        for (GCubeGroup gCubeGroup : theGateways) {
            logger.debug("Gateway: [id=" + gCubeGroup.getGroupId() + ", name=" + gCubeGroup.getGroupName() + "]");
            LinkedList gatewayChildren = this.retrieveGatewayChildren(request, gCubeGroup.getGroupId(), currUser);
            ScopeDescriptor gatewayScopeDescriptor = new ScopeDescriptor(gCubeGroup.getGroupName(), gCubeGroup.getGroupId() + "");
            gatewayScopeDescriptor.setChildren(gatewayChildren);
            infraChildren.add(gatewayScopeDescriptor);
        }
        infra.setChildren(infraChildren);
        return infra;
    }

    private ScopeDescriptor recreateTreeForPortalContext(HttpServletRequest request) throws Exception, PortalException, SystemException {
        long currentSiteGroupId = this.getSiteFromServletRequest(request).getGroupId();
        PortalContext pContext = PortalContext.getConfiguration();
        GCubeUser currUser = pContext.getCurrentUser(request);
        LinkedList rootChildren = null;
        rootChildren = this.retrieveGatewayChildren(request, currentSiteGroupId, currUser);
        Group rootGroup = this.getSiteFromServletRequest(request);
        ScopeDescriptor root = new ScopeDescriptor(rootGroup.getDescriptiveName(), rootGroup.getGroupId() + "");
        root.setChildren(rootChildren);
        logger.debug("TREE IS {} ", (Object)root);
        return root;
    }

    private LinkedList<ScopeDescriptor> retrieveGatewayChildren(HttpServletRequest request, long currentSiteGroupId, GCubeUser currUser) throws Exception, PortalException, SystemException {
        LinkedHashMap gatewayTree = this.getPortalSitesMappedToVRE(currUser, currentSiteGroupId);
        logger.debug("Parsing tree from gateway. Size {} ", (Object)gatewayTree.size());
        LinkedList<ScopeDescriptor> rootChildren = new LinkedList<ScopeDescriptor>();
        for (Map.Entry entry : gatewayTree.entrySet()) {
            ScopeDescriptor rootChild = new ScopeDescriptor(VRECategory.access$000((VRECategory)((VRECategory)entry.getKey())), VRECategory.access$100((VRECategory)((VRECategory)entry.getKey())) + "");
            for (VRE vre : (ArrayList)entry.getValue()) {
                rootChild.getChildren().add(new ScopeDescriptor(VRE.access$200((VRE)vre), VRE.access$300((VRE)vre)));
            }
            rootChildren.add(rootChild);
        }
        return rootChildren;
    }

    private LinkedHashMap<VRECategory, ArrayList<VRE>> getPortalSitesMappedToVRE(GCubeUser currUser, long currentSiteGroupId) throws Exception {
        LinkedHashMap<VRECategory, ArrayList<VRE>> toReturn = new LinkedHashMap<VRECategory, ArrayList<VRE>>();
        List currentSiteVGroups = groupsManager.getVirtualGroups(currentSiteGroupId);
        for (VirtualGroup vg : currentSiteVGroups) {
            ArrayList toCreate = new ArrayList();
            VRECategory cat = new VRECategory(this, 1L, vg.getName(), vg.getDescription());
            toReturn.put(cat, toCreate);
        }
        GCubeGroup rootGroupVO = groupsManager.getRootVO();
        try {
            logger.debug("root: " + rootGroupVO.getGroupName());
        }
        catch (NullPointerException e) {
            logger.error("Cannot find root organziation, please check gcube-data.properties file in $CATALINA_HOME/conf folder, unless your installing the Bundle");
            return toReturn;
        }
        List currUserGroups = new ArrayList();
        if (currUser != null) {
            currUserGroups = groupsManager.listGroupsByUser(currUser.getUserId());
        }
        for (GCubeGroup vOrg : rootGroupVO.getChildren()) {
            for (GCubeGroup vreSite : vOrg.getChildren()) {
                long vreID = vreSite.getGroupId();
                String vreName = vreSite.getGroupName();
                String vreDescription = vreSite.getDescription();
                long logoId = vreSite.getLogoId();
                String vreLogoURL = groupsManager.getGroupLogoURL(logoId);
                String infraScope = groupsManager.getInfrastructureScope(vreSite.getGroupId());
                String friendlyURL = "/group" + vreSite.getFriendlyURL();
                List vreGroups = groupsManager.getVirtualGroups(vreID);
                for (VirtualGroup vreGroup : vreGroups) {
                    for (VRECategory vre : toReturn.keySet()) {
                        if (vre.getName().compareTo(vreGroup.getName()) != 0) continue;
                        ArrayList<VRE> toUpdate = toReturn.get(vre);
                        VRE toAdd = new VRE(this, vreName, vreDescription, vreID, friendlyURL, infraScope);
                        toUpdate.add(toAdd);
                    }
                }
            }
        }
        for (VRECategory cat : toReturn.keySet()) {
            ArrayList<VRE> toSort = toReturn.get(cat);
            Collections.sort(toSort);
        }
        return toReturn;
    }

    private Group getSiteFromServletRequest(HttpServletRequest request) throws PortalException, SystemException {
        String serverName = request.getServerName();
        logger.debug("currentHost is " + serverName);
        Group site = null;
        List vHosts = VirtualHostLocalServiceUtil.getVirtualHosts((int)0, (int)VirtualHostLocalServiceUtil.getVirtualHostsCount());
        for (VirtualHost virtualHost : vHosts) {
            logger.debug("Found " + virtualHost.getHostname());
            if (virtualHost.getHostname().compareTo("localhost") == 0 || virtualHost.getLayoutSetId() == 0L || virtualHost.getHostname().compareTo(serverName) != 0) continue;
            long layoutSetId = virtualHost.getLayoutSetId();
            site = LayoutSetLocalServiceUtil.getLayoutSet((long)layoutSetId).getGroup();
            logger.debug("Found match! Your site is " + site.getName());
            return site;
        }
        return null;
    }

    static {
        logger = LoggerFactory.getLogger(PortalContextTreeProvider.class);
        groupsManager = new LiferayGroupManager();
    }
}

