/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.accountingdashboard.client.application.mainarea.filter;

import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.inject.Inject;
import com.google.web.bindery.event.shared.EventBus;
import com.gwtplatform.mvp.client.PresenterWidget;
import com.gwtplatform.mvp.client.UiHandlers;
import com.gwtplatform.mvp.client.View;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gcube.portlets.user.accountingdashboard.client.application.controller.Controller;
import org.gcube.portlets.user.accountingdashboard.client.application.event.ScopeDataEvent;
import org.gcube.portlets.user.accountingdashboard.client.application.mainarea.filter.FilterAreaPresenter;
import org.gcube.portlets.user.accountingdashboard.client.application.mainarea.filter.FilterAreaUiHandlers;
import org.gcube.portlets.user.accountingdashboard.shared.data.RequestReportData;

public class FilterAreaPresenter
extends PresenterWidget<FilterAreaView>
implements FilterAreaUiHandlers {
    private static Logger logger = Logger.getLogger("");
    private EventBus eventBus;
    private Controller controller;

    @Inject
    FilterAreaPresenter(EventBus eventBus, FilterAreaView view, Controller controller) {
        super(eventBus, (View)view);
        this.eventBus = eventBus;
        this.controller = controller;
        ((FilterAreaView)this.getView()).setUiHandlers((UiHandlers)this);
        this.addProviders();
        this.bindToEvent();
    }

    private void addProviders() {
    }

    private void bindToEvent() {
        this.controller.getEventBus().addHandler(ScopeDataEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void onBind() {
        super.onBind();
        this.controller.getTree();
    }

    public void getReport(RequestReportData requestReportData) {
        if (this.checkDate(requestReportData.getDateFrom(), requestReportData.getDateTo())) {
            this.controller.getReport(requestReportData);
        }
    }

    private boolean checkDate(String dateStart, String dateEnd) {
        DateTimeFormat dateTimeFormat = DateTimeFormat.getFormat((String)"yyyy-MM-dd");
        Date dateStartD = null;
        try {
            logger.fine("DateTemp1: " + dateStart);
            dateStartD = dateTimeFormat.parse(dateStart);
            logger.fine("DateStart: " + dateStartD);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error in start date: " + e.getLocalizedMessage(), e);
            return false;
        }
        Date dateEndD = null;
        try {
            logger.fine("DateTemp2: " + dateEnd);
            dateEndD = dateTimeFormat.parse(dateEnd);
            logger.fine("DateEnd: " + dateEndD);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error in end date: " + e.getLocalizedMessage(), e);
            return false;
        }
        if (dateStartD.compareTo(dateEndD) > 0) {
            this.controller.errorShow("Attention the start date must be less than the end date!");
            return false;
        }
        return true;
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }
}

