/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.vredeployer.client.view.panels.builders;

import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.ProgressBar;
import com.extjs.gxt.ui.client.widget.layout.CenterLayout;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Widget;
import org.gcube.portlets.admin.vredeployer.client.view.panels.builders.OverallDeployStatus;
import org.gcube.portlets.admin.vredeployer.shared.deployreport.ClientDeployReport;
import org.gcube.portlets.admin.vredeployer.shared.deployreport.DeployStatus;

public class OverallDeployStatus {
    private ContentPanel cp = new ContentPanel((Layout)new FitLayout());
    boolean barAdded = false;
    ProgressBar bar;

    public OverallDeployStatus() {
        this.cp.setLayout((Layout)new CenterLayout());
    }

    private int getStatusDependingOnOtherSteps(ClientDeployReport report) {
        int cloudStep = 0;
        if (report.getCloudReport().getStatus() != null && (report.getCloudReport().getStatus() == DeployStatus.FINISH || report.getCloudReport().getStatus() == DeployStatus.SKIP)) {
            cloudStep = 25;
        }
        int resourceManagerStep = 0;
        if (report.getResourceManagerReport().getStatus() != null && report.getResourceManagerReport().getStatus() == DeployStatus.FINISH) {
            resourceManagerStep = 25;
        }
        int funcStep = 0;
        if (report.getFunctionalityReport().getStatus() != null && report.getFunctionalityReport().getStatus() == DeployStatus.FINISH) {
            funcStep = 25;
        }
        int genresStep = 0;
        if (report.getResourcesReport().getStatus() != null && report.getResourcesReport().getStatus() == DeployStatus.FINISH) {
            genresStep = 25;
        }
        return cloudStep + resourceManagerStep + funcStep + genresStep;
    }

    public void updateReport(ClientDeployReport report) {
        this.cp.unmask();
        DeployStatus overallStatus = report.getGlobalsStatus();
        GWT.log((String)("overallStatus: " + overallStatus));
        int i = this.getStatusDependingOnOtherSteps(report);
        String label = "% Complete";
        if (!this.barAdded) {
            this.createReport();
            this.barAdded = true;
            this.bar.updateProgress(0.0, " not started yet");
            this.cp.add((Widget)this.bar);
            this.bar.setWidth("90%");
            this.cp.layout();
        } else {
            if (report.getGlobalsStatus() != DeployStatus.FINISH || report.getGlobalsStatus() != DeployStatus.FAIL) {
                this.cp.mask("Retrieving data", "loading-indicator");
                1 delay = new /* Unavailable Anonymous Inner Class!! */;
                delay.start(1500);
            }
            this.bar.setWidth("90%");
            this.bar.updateProgress((double)(i / 100), String.valueOf(i) + label);
            this.cp.layout();
        }
        if (report.getGlobalsStatus() == DeployStatus.FAIL || report.getGlobalsStatus() == DeployStatus.FINISH) {
            Window.alert((String)("VRE Deploying report completed: " + report.getGlobalsStatus()));
            this.bar.setWidth("90%");
            i = 100;
            this.bar.updateProgress((double)(i / 100), String.valueOf(i) + label);
            this.cp.layout();
        }
    }

    public void createReport() {
        this.cp.removeAll();
        this.bar = new ProgressBar();
    }

    public ContentPanel getOverallDeployStatusPanel() {
        this.cp.setHeaderVisible(true);
        this.cp.setHeading("Overall deploying status");
        this.cp.setHeight(250);
        this.cp.setBorders(true);
        this.cp.mask("Retrieving data", "loading-indicator");
        return this.cp;
    }

    static /* synthetic */ ContentPanel access$0(OverallDeployStatus overallDeployStatus) {
        return overallDeployStatus.cp;
    }
}

