/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.vredefinition.client;

import com.github.gwtbootstrap.client.ui.AlertBlock;
import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.Column;
import com.github.gwtbootstrap.client.ui.Row;
import com.github.gwtbootstrap.client.ui.Tab;
import com.github.gwtbootstrap.client.ui.TabPanel;
import com.github.gwtbootstrap.client.ui.constants.AlertType;
import com.github.gwtbootstrap.client.ui.constants.ButtonType;
import com.github.gwtbootstrap.client.ui.resources.Bootstrap;
import com.github.gwtbootstrap.client.ui.resources.ButtonSize;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.gcube.portlets.admin.vredefinition.client.VREDefinitionPanel;
import org.gcube.portlets.admin.vredefinition.client.VREDefinitionService;
import org.gcube.portlets.admin.vredefinition.client.VREDefinitionServiceAsync;
import org.gcube.portlets.admin.vredefinition.client.ui.SummaryPanel;
import org.gcube.portlets.admin.vredefinition.client.ui.VRECreationFormSkeleton;
import org.gcube.portlets.admin.vredefinition.shared.Functionality;
import org.gcube.portlets.admin.vredefinition.shared.Resource;
import org.gcube.portlets.admin.vredefinition.shared.ResourceCategory;
import org.gcube.portlets.admin.vredefinition.shared.VREDescriptionBean;

public class VREDefinitionPanel
extends Composite {
    VREDefinitionServiceAsync rpcService = (VREDefinitionServiceAsync)GWT.create(VREDefinitionService.class);
    private VerticalPanel mainPanel;
    private VRECreationFormSkeleton skeleton = new VRECreationFormSkeleton();
    private SummaryPanel summary = new SummaryPanel();
    private TabPanel mainTabPanel = new TabPanel(Bootstrap.Tabs.LEFT);
    private Tab vreInformationTab = new Tab();
    private Button createVREButton = new Button("Upload");
    private AlertBlock retrievingInformation = new AlertBlock(AlertType.INFO);
    HashMap<String, List<SubFunctionalityClientBean>> subFunctionalityBeansMap = new HashMap();
    private static final String DESIGNER = "Designer";
    private static final String MANAGER = "Manager";
    private static final String VRE_NAME_FIELD = "vreName";
    private static final String VRE_MANAGER_FIELD = "vreManager";
    private static final String VRE_DESIGNER_FIELD = "vreDesigner";
    private static final String VRE_DESCRIPTION_FIELD = "vreDescription";
    private static final String VRE_START_TIME_FIELD = "vreStartTime";
    private static final String VRE_END_TIME_FIELD = "vreEndTime";
    private static final String EDIT_MODE = "edit";

    public VREDefinitionPanel() {
        this.mainPanel = new VerticalPanel();
        this.initWidget((Widget)this.mainPanel);
        this.mainPanel.addStyleName("vre-definition-main-panel");
        this.mainPanel.add((Widget)this.mainTabPanel);
        this.vreInformationTab.setHeading("VRE Information");
        this.vreInformationTab.add((Widget)this.skeleton);
        this.mainTabPanel.add((IsWidget)this.vreInformationTab);
        this.mainTabPanel.selectTab(0);
        this.retrievingInformation.setClose(false);
        this.retrievingInformation.setText("Retrieving information, please wait...");
        this.vreInformationTab.add((Widget)this.retrievingInformation);
        this.rpcService.getVRE((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void requireFunctionalities(boolean isEditMode, TabPanel mainTabPanel) {
        this.rpcService.getFunctionality(isEditMode, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void onGenerateSummarySubmit(ArrayList<Functionality> result, Tab summaryTab) {
        String vreName = this.skeleton.getCurrentVREName();
        String vreDesigner = this.skeleton.getCurrentVREDesigner();
        String vreSelectedManager = this.skeleton.getCurrentVREManager();
        String vreDescription = this.skeleton.getCurrentVREDescription();
        Date vreStartDate = this.skeleton.getCurrentVREStartDate();
        Date vreToDate = this.skeleton.getCurrentVREToDate();
        if (vreName.isEmpty() || vreName.contains(" ")) {
            3 t = new /* Unavailable Anonymous Inner Class!! */;
            t.schedule(100);
            this.skeleton.showAlertBlockVREName();
            return;
        }
        if (vreDescription.isEmpty() || vreDescription.trim().length() == 0) {
            this.skeleton.showAlertBlockVREDescritption();
            4 t = new /* Unavailable Anonymous Inner Class!! */;
            t.schedule(100);
            return;
        }
        this.summary.setVisible(true);
        VREDescriptionBean vreDescriptionBean = new VREDescriptionBean(vreName, vreDescription, vreDesigner, vreSelectedManager, vreStartDate, vreToDate);
        this.summary.clearFunctionalitiesPanel();
        for (Functionality macroFunctionality : result) {
            String name = macroFunctionality.getName();
            Tree t = new Tree();
            TreeItem root = new TreeItem();
            root.setText(name);
            t.addItem(root);
            VerticalPanel partialSummaryFunctionality = new VerticalPanel();
            partialSummaryFunctionality.getElement().getStyle().setMarginBottom(10.0, Style.Unit.PX);
            List subfunctionalities = macroFunctionality.getSubFunctionalities();
            for (Functionality subfunctionality : subfunctionalities) {
                TreeItem subfuncItem = new TreeItem();
                subfuncItem.setText(subfunctionality.getName());
                if (!subfunctionality.isSelected()) continue;
                root.addItem(subfuncItem);
                List categories = subfunctionality.getResources();
                if (categories == null) continue;
                for (ResourceCategory resourceCategory : categories) {
                    ArrayList resources = resourceCategory.getItems();
                    for (Resource resource : resources) {
                        if (!resource.isSelected()) continue;
                        TreeItem resourceItem = new TreeItem();
                        resourceItem.setText(resource.getName());
                        subfuncItem.addItem(resourceItem);
                    }
                }
            }
            partialSummaryFunctionality.add((Widget)t);
            this.summary.addFunctionality((Widget)partialSummaryFunctionality);
        }
        this.summary.setVreMainInformation(vreName, vreSelectedManager, vreDesigner, vreDescription, vreStartDate, vreToDate);
        summaryTab.add((Widget)this.summary);
        FlowPanel summaryButtons = new FlowPanel();
        summaryButtons.addStyleName("summary-buttons-panel");
        summaryButtons.add((Widget)this.createVREButton);
        summaryTab.add((Widget)summaryButtons);
        this.createVREButton.setType(ButtonType.PRIMARY);
        this.createVREButton.setSize(ButtonSize.LARGE);
        this.createVREButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void showErrors(String msg) {
        this.skeleton.removeLoader();
        AlertBlock errorMsg = new AlertBlock();
        errorMsg.setType(AlertType.ERROR);
        errorMsg.setClose(false);
        errorMsg.setText(msg);
        Row errorRow = new Row();
        Column errorCol = new Column(12);
        errorCol.add((Widget)errorMsg);
        errorRow.add((Widget)errorCol);
        this.skeleton.appendRow((Widget)errorRow);
    }

    private void addAlertOnCreation(String vreName, boolean success, Tab summaryTab) {
        String msg = "VRE with name " + vreName;
        msg = success ? msg + " created correctly!" : msg + " not created. Please retry later.";
        AlertBlock confirmation = new AlertBlock(msg);
        if (success) {
            confirmation.setType(AlertType.SUCCESS);
        } else {
            confirmation.setType(AlertType.ERROR);
        }
        summaryTab.add((Widget)confirmation);
        6 t = new /* Unavailable Anonymous Inner Class!! */;
        t.schedule(2000);
    }

    static /* synthetic */ AlertBlock access$000(VREDefinitionPanel x0) {
        return x0.retrievingInformation;
    }

    static /* synthetic */ Tab access$100(VREDefinitionPanel x0) {
        return x0.vreInformationTab;
    }

    static /* synthetic */ VRECreationFormSkeleton access$200(VREDefinitionPanel x0) {
        return x0.skeleton;
    }

    static /* synthetic */ TabPanel access$300(VREDefinitionPanel x0) {
        return x0.mainTabPanel;
    }

    static /* synthetic */ void access$400(VREDefinitionPanel x0, boolean x1, TabPanel x2) {
        x0.requireFunctionalities(x1, x2);
    }

    static /* synthetic */ void access$500(VREDefinitionPanel x0, String x1) {
        x0.showErrors(x1);
    }

    static /* synthetic */ SummaryPanel access$600(VREDefinitionPanel x0) {
        return x0.summary;
    }

    static /* synthetic */ void access$700(VREDefinitionPanel x0, ArrayList x1, Tab x2) {
        x0.onGenerateSummarySubmit(x1, x2);
    }

    static /* synthetic */ Button access$800(VREDefinitionPanel x0) {
        return x0.createVREButton;
    }

    static /* synthetic */ void access$900(VREDefinitionPanel x0, String x1, boolean x2, Tab x3) {
        x0.addAlertOnCreation(x1, x2, x3);
    }
}

