/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.vredefinition.server;

import com.extjs.gxt.ui.client.data.ModelData;
import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpSession;
import org.gcube.application.framework.accesslogger.library.impl.AccessLogger;
import org.gcube.application.framework.accesslogger.model.AccessLogEntry;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.application.framework.vremanagement.vremanagement.impl.VREGeneratorEvo;
import org.gcube.applicationsupportlayer.social.ApplicationNotificationsManager;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.portlets.admin.vredefinition.client.VREDefinitionService;
import org.gcube.portlets.admin.vredefinition.client.model.VREFunctionalityModel;
import org.gcube.portlets.admin.vredefinition.server.loggers.CreatedVRELogEntry;
import org.gcube.portlets.admin.vredefinition.server.loggers.OpenVREWizardLogEntry;
import org.gcube.portlets.admin.vredefinition.shared.ExternalResourceModel;
import org.gcube.portlets.admin.vredefinition.shared.ResourceCategory;
import org.gcube.portlets.admin.vredefinition.shared.ResourceCategoryItem;
import org.gcube.portlets.admin.vredefinition.shared.VRECollectionBean;
import org.gcube.portlets.admin.vredefinition.shared.VREDescriptionBean;
import org.gcube.portlets.admin.vredefinition.shared.exception.VREDefinitionException;
import org.gcube.vomanagement.usermanagement.impl.liferay.LiferayRoleManager;
import org.gcube.vomanagement.usermanagement.impl.liferay.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.UserModel;
import org.gcube.vremanagement.vremodel.cl.stubs.types.FunctionalityItem;
import org.gcube.vremanagement.vremodel.cl.stubs.types.ResourceDescriptionItem;
import org.gcube.vremanagement.vremodel.cl.stubs.types.ResourceItem;
import org.gcube.vremanagement.vremodel.cl.stubs.types.SelectedResourceDescriptionType;
import org.gcube.vremanagement.vremodel.cl.stubs.types.VREDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VREDefinitionServiceImpl
extends RemoteServiceServlet
implements VREDefinitionService {
    private static final long serialVersionUID = -7565518362225100485L;
    private static final Logger _log = LoggerFactory.getLogger(VREDefinitionServiceImpl.class);
    private static final String DESIGNER = "Designer";
    private static final String MANAGER = "Manager";
    private static final String DESCRIPTION = "DESCRIPTION";
    private static String VRE_MANAGER_STRING = "VRE-Manager";
    private static final String VRE_GENERATOR_ATTRIBUTE = "VREGenerator";
    private static final String VRE_DEFINER_GENERATOR_ATTRIBUTE = "VREDefinerGenerator";
    private static final String USERNAME_ATTRIBUTE = "username";
    private static final String HARD_CODED_VO_NAME = "/gcube/devsec";
    private static final String REEDIT_TYPE_ATTRIBUTE = "reeditType";
    private static final String APPROVE_MODE = "approve";
    public static final String EDIT_MODE = "edit";
    private static final String CATEGORIES = "CATEGORIES";
    private boolean withinEclipse = false;

    private ASLSession getASLSession() {
        HttpSession session = this.getThreadLocalRequest().getSession();
        String username = (String)session.getAttribute(USERNAME_ATTRIBUTE);
        if (username == null) {
            username = "massimiliano.assante";
            SessionManager.getInstance().getASLSession(session.getId(), username).setScope(HARD_CODED_VO_NAME);
            SessionManager.getInstance().getASLSession(session.getId(), username).setAttribute(REEDIT_TYPE_ATTRIBUTE, (Object)APPROVE_MODE);
            this.withinEclipse = true;
        }
        return SessionManager.getInstance().getASLSession(session.getId(), username);
    }

    private VREGeneratorEvo getVREGenerator() {
        ASLSession d4ScienceSession = this.getASLSession();
        VREGeneratorEvo vreGenerator = (VREGeneratorEvo)d4ScienceSession.getAttribute(VRE_DEFINER_GENERATOR_ATTRIBUTE);
        if (vreGenerator == null) {
            vreGenerator = new VREGeneratorEvo(d4ScienceSession);
            d4ScienceSession.setAttribute(VRE_DEFINER_GENERATOR_ATTRIBUTE, (Object)vreGenerator);
        }
        AccessLogger log = AccessLogger.getAccessLogger();
        OpenVREWizardLogEntry logEntry = new OpenVREWizardLogEntry();
        log.logEntry(this.getASLSession().getUsername(), this.getASLSession().getScopeName(), (AccessLogEntry)logEntry);
        return vreGenerator;
    }

    private void storeResourceCategoryInSession(HashMap<String, ArrayList<ResourceCategory>> funcCategories) {
        this.getASLSession().setAttribute(CATEGORIES, funcCategories);
    }

    private HashMap<String, ArrayList<ResourceCategory>> getResourceCategoryFromSession() {
        return (HashMap)this.getASLSession().getAttribute(CATEGORIES);
    }

    public ArrayList<ExternalResourceModel> getResourceCategoryByFunctionality(String id) {
        ArrayList toReturn = new ArrayList();
        return this.getResourceCategoryFromSession().containsKey(id) ? this.getExternaleResources(id) : toReturn;
    }

    private ArrayList<ExternalResourceModel> getExternaleResources(String id) {
        ArrayList<ExternalResourceModel> toReturn = new ArrayList<ExternalResourceModel>();
        ArrayList cats = (ArrayList)this.getResourceCategoryFromSession().get(id);
        for (ResourceCategory rc : cats) {
            for (ResourceCategoryItem item : rc.getItems()) {
                toReturn.add(new ExternalResourceModel(item.getId(), item.getName(), item.getDescription(), item.isSelected(), rc.getName(), rc.getId()));
            }
        }
        return toReturn;
    }

    public Map<String, Object> isEditMode() {
        System.out.println("\n\n\n*********************  isEditMode()");
        String reeditType = (String)this.getASLSession().getAttribute(REEDIT_TYPE_ATTRIBUTE);
        ASLSession session = this.getASLSession();
        session.setAttribute(VRE_DEFINER_GENERATOR_ATTRIBUTE, null);
        if (reeditType != null && reeditType.equals(EDIT_MODE)) {
            String vreid = (String)session.getAttribute(VRE_GENERATOR_ATTRIBUTE);
            if (vreid == null) {
                session.setAttribute(VRE_DEFINER_GENERATOR_ATTRIBUTE, null);
            } else {
                VREGeneratorEvo vreGenerator = new VREGeneratorEvo(session, vreid);
                session.setAttribute(VRE_DEFINER_GENERATOR_ATTRIBUTE, (Object)vreGenerator);
            }
            session.setAttribute(REEDIT_TYPE_ATTRIBUTE, null);
            try {
                List collections = this.getCollections();
                VREFunctionalityModel functionalities = this.getFunctionality(true);
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("collections", collections);
                map.put("functionalities", functionalities);
                return map;
            }
            catch (VREDefinitionException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public VREFunctionalityModel getFunctionality(boolean isEdit) throws VREDefinitionException {
        if (!isEdit) {
            Calendar cal = Calendar.getInstance();
            long startTime = cal.getTimeInMillis();
            cal.add(2, 5);
            cal.add(10, 7);
            long endTime = cal.getTimeInMillis();
            try {
                this.getVREGenerator().setVREModel("notCompletedVirtualResearchEnv.", UUID.randomUUID().toString(), UUID.randomUUID().toString(), UUID.randomUUID().toString(), startTime, endTime);
                Thread.sleep(1000L);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        if (!this.getVREGenerator().isVreModelerServiceUp()) {
            return null;
        }
        VREFunctionalityModel toReturn = new VREFunctionalityModel("", "selected functionality", "", "", false);
        try {
            HashMap funCategories = new HashMap();
            List list = this.getVREGenerator().getFunctionality();
            if (list == null) {
                _log.warn("FunctionalityList NULL");
            }
            for (FunctionalityItem fi : list) {
                System.out.println("id:" + fi.id() + " " + fi.name());
                VREFunctionalityModel toAdd = new VREFunctionalityModel(Integer.toString(fi.id()), fi.name(), fi.description(), "", fi.selected());
                if (fi.children() != null && !fi.children().isEmpty()) {
                    List children = fi.children();
                    VREFunctionalityModel[] newchildrens = new VREFunctionalityModel[children.size()];
                    int i = 0;
                    while (i < children.size()) {
                        System.out.println(String.valueOf(((FunctionalityItem)children.get(i)).name()) + " is " + ((FunctionalityItem)children.get(i)).selected());
                        newchildrens[i] = new VREFunctionalityModel(Integer.toString(((FunctionalityItem)children.get(i)).id()), ((FunctionalityItem)children.get(i)).name(), ((FunctionalityItem)children.get(i)).description(), "functionality-add-icon", ((FunctionalityItem)children.get(i)).selected());
                        ArrayList<ResourceCategory> resCats = new ArrayList<ResourceCategory>();
                        if (((FunctionalityItem)children.get(i)).selectableResourcesDescription() != null) {
                            for (ResourceDescriptionItem category : ((FunctionalityItem)children.get(i)).selectableResourcesDescription()) {
                                if (category.resources() == null) continue;
                                ResourceCategory rc = new ResourceCategory(category.id(), category.description());
                                for (ResourceItem resource : category.resources()) {
                                    rc.addResourceItem(new ResourceCategoryItem(resource.id(), resource.name(), resource.description(), resource.selected()));
                                }
                                resCats.add(rc);
                            }
                            funCategories.put(newchildrens[i].getId(), resCats);
                        }
                        ++i;
                    }
                    toAdd.addChildren(newchildrens);
                    toReturn.add((ModelData)toAdd);
                    continue;
                }
                System.out.println("id:" + fi.id() + " " + fi.name() + " has no children");
            }
            this.storeResourceCategoryInSession(funCategories);
            for (String func : funCategories.keySet()) {
                System.out.println("-" + func);
                for (ResourceCategory category : (ArrayList)funCategories.get(func)) {
                    System.out.println("--" + category.getName());
                    for (ResourceCategoryItem rc : category.getItems()) {
                        System.out.println("----" + rc.getName());
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new VREDefinitionException("Set functionalities Error");
        }
        return toReturn;
    }

    public Map<String, Object> getVRE() throws VREDefinitionException {
        HashMap<String, Object> toReturn = new HashMap<String, Object>();
        HttpSession session = this.getThreadLocalRequest().getSession();
        String username = (String)session.getAttribute(USERNAME_ATTRIBUTE);
        List belongingUsers = new LinkedList();
        if (this.withinEclipse) {
            return this.getFakeBelongingUsers();
        }
        LiferayUserManager um = null;
        try {
            um = new LiferayUserManager();
            long currOrgid = this.getASLSession().getGroupId();
            LiferayRoleManager rm = new LiferayRoleManager();
            System.out.println("Trying to get roleid of " + VRE_MANAGER_STRING + " into " + this.getASLSession().getGroupName());
            String roleId = "none";
            roleId = rm.getRoleId(VRE_MANAGER_STRING, this.getASLSession().getGroupName());
            System.out.println("Trying to get VRE-Managers of " + currOrgid + " role id=" + roleId);
            belongingUsers = um.listUsersByGroupAndRole("" + currOrgid, roleId);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            throw new VREDefinitionException("We cannot find any VO-Admin user for this environment. There must be at least one.");
        }
        if (belongingUsers == null || belongingUsers.size() == 0) {
            throw new VREDefinitionException("We cannot find any VO-Admin user for this environment. There must be at least one.");
        }
        try {
            ArrayList<String> managers = new ArrayList<String>();
            int i = 0;
            while (i < belongingUsers.size()) {
                managers.add(String.valueOf(((UserModel)belongingUsers.get(i)).getFullname()) + " (" + ((UserModel)belongingUsers.get(i)).getScreenName() + ")");
                ++i;
            }
            toReturn.put(MANAGER, managers);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new VREDefinitionException("We cannot find any VO-Admin user for this environment. There must be at least one.");
        }
        try {
            String fullName = um.getUserByScreenName(username).getFullname();
            toReturn.put(DESIGNER, String.valueOf(fullName) + " (" + username + ")");
            VREDescriptionBean vre = this.getVREInSession();
            if (vre != null) {
                toReturn.put("vreName", vre.getName());
                toReturn.put("vreManager", vre.getManager());
                toReturn.put("vreDesigner", vre.getDesigner());
                toReturn.put("vreDescription", vre.getDescription());
                toReturn.put("vreStartTime", vre.getStartTime());
                toReturn.put("vreEndTime", vre.getEndTime());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    private HashMap<String, Object> getFakeBelongingUsers() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ArrayList<String> managers = new ArrayList<String>();
        managers.add("Pasquale Pagano (pasquale.pagano)");
        managers.add("Andrea Manzi (andrea.manzi)");
        managers.add("Massimiliano Assante (massimiliano.assante)");
        ret.put(MANAGER, managers);
        ret.put(DESIGNER, "Leanoardo Candela (leonardo.candela)");
        try {
            VREDescriptionBean vre = this.getVREInSession();
            if (vre != null) {
                System.out.println(" ########### VRE != NULL ##########");
                ret.put("vreName", vre.getName());
                ret.put("vreManager", vre.getManager());
                ret.put("vreDesigner", vre.getDesigner());
                ret.put("vreDescription", vre.getDescription());
                ret.put("vreStartTime", vre.getStartTime());
                ret.put("vreEndTime", vre.getEndTime());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    private String extractUserName(String toExtract) {
        int openBracket = toExtract.indexOf("(") + 1;
        int closeBracket = toExtract.indexOf(")");
        return toExtract.substring(openBracket, closeBracket);
    }

    private String extracName(String toExtract) {
        int openBracket = toExtract.indexOf("(") + 1;
        return toExtract.substring(0, openBracket);
    }

    public String setVRE(VREDescriptionBean bean, String[] functionalityIDs, HashMap<String, List<ExternalResourceModel>> funcToExternalResources) throws VREDefinitionException {
        bean.setDesigner(this.extractUserName(bean.getDesigner()));
        String managerUserName = this.extractUserName(bean.getManager());
        bean.setManager(managerUserName);
        this.setVREDescription(bean);
        this.setFunctionality(functionalityIDs, funcToExternalResources);
        try {
            this.getVREGenerator().setVREtoPendingState();
            this.getASLSession().setAttribute(VRE_DEFINER_GENERATOR_ATTRIBUTE, null);
            Workspace workspace = HomeLibrary.getUserWorkspace((String)this.getASLSession().getUsername());
            ArrayList<String> toSend = new ArrayList<String>();
            toSend.add(managerUserName);
            String subject = "New VRE Definition requires your approval";
            String body = "Dear Manager, " + bean.getDesigner() + " has created a VRE Definition indicating you as VRE Manager on " + this.getASLSession().getScope();
            body = String.valueOf(body) + ".\nThe VRE Name is: " + bean.getName() + ", its description: " + bean.getDescription() + ".";
            workspace.getWorkspaceMessageManager().sendMessageToPortalLogins(subject, body, new ArrayList(), toSend);
            ApplicationNotificationsManager nnm = new ApplicationNotificationsManager(this.getASLSession());
            if (nnm.notifyMessageReceived(managerUserName, subject)) {
                _log.trace("Sending VRE Definition create notification: " + subject + " OK");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        AccessLogger log = AccessLogger.getAccessLogger();
        CreatedVRELogEntry logEntry = new CreatedVRELogEntry(bean.getName(), "unknown", bean.getDesigner(), bean.getManager());
        log.logEntry(this.getASLSession().getUsername(), this.getASLSession().getScopeName(), (AccessLogEntry)logEntry);
        return null;
    }

    public String setFunctionality(String[] functionalityIDs, HashMap<String, List<ExternalResourceModel>> funcToExternalResources) throws VREDefinitionException {
        ArrayList<SelectedResourceDescriptionType> toSend = new ArrayList<SelectedResourceDescriptionType>();
        int i = 0;
        while (i < functionalityIDs.length) {
            if (funcToExternalResources.containsKey(functionalityIDs[i])) {
                String descriptionId = "";
                ArrayList<String> resourceIds = new ArrayList<String>();
                for (ExternalResourceModel extRes : funcToExternalResources.get(functionalityIDs[i])) {
                    _log.debug("resource: " + extRes.getName() + " Selected?" + extRes.isSelected());
                    if (!extRes.isSelected()) continue;
                    descriptionId = extRes.getCategoryId();
                    resourceIds.add(extRes.getId());
                    _log.debug("------> Added selected resource: " + extRes.getName() + " id=" + extRes.getId() + "\n");
                }
                SelectedResourceDescriptionType toAdd = new SelectedResourceDescriptionType();
                toAdd.descriptionId(descriptionId);
                toAdd.resourceIds(resourceIds);
                toSend.add(toAdd);
            }
            ++i;
        }
        Integer[] funcIdAsInts = new Integer[functionalityIDs.length];
        int i2 = 0;
        while (i2 < functionalityIDs.length) {
            try {
                funcIdAsInts[i2] = Integer.parseInt(functionalityIDs[i2]);
            }
            catch (ClassCastException e) {
                _log.error("Could not convert to int: " + functionalityIDs[i2]);
            }
            ++i2;
        }
        SelectedResourceDescriptionType[] selres = toSend.toArray(new SelectedResourceDescriptionType[toSend.size()]);
        System.out.println("SelectedResourceDescriptionType[] Sending to Service .... toSend size = " + toSend.size());
        int i3 = 0;
        while (i3 < selres.length) {
            System.out.println("SelectedResourceDescriptionType DESC: " + selres[i3].getDescriptionId());
            int j = 0;
            while (j < selres[i3].resourceIds().size()) {
                System.out.println("resid= " + (String)selres[i3].resourceIds().get(j));
                ++j;
            }
            ++i3;
        }
        VREGeneratorEvo vreGenerator = this.getVREGenerator();
        try {
            vreGenerator.setFunctionality(funcIdAsInts, selres);
            vreGenerator.setVREtoPendingState();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            throw new VREDefinitionException("Set functionalities Error");
        }
        return null;
    }

    private String setVREDescription(VREDescriptionBean bean) throws VREDefinitionException {
        VREGeneratorEvo vreGenerator = this.getVREGenerator();
        ASLSession d4ScienceSession = this.getASLSession();
        d4ScienceSession.setAttribute("VREName", (Object)bean.getName());
        d4ScienceSession.setAttribute(DESCRIPTION, (Object)bean.getDescription());
        d4ScienceSession.setAttribute(DESIGNER, (Object)bean.getDesigner());
        d4ScienceSession.setAttribute(MANAGER, (Object)bean.getManager());
        try {
            vreGenerator.setVREModel(bean.getName(), bean.getDescription(), bean.getDesigner(), bean.getManager(), bean.getStartTime().getTime(), bean.getEndTime().getTime());
        }
        catch (RemoteException e) {
            e.printStackTrace();
            throw new VREDefinitionException("Set Description Error");
        }
        return null;
    }

    public List<VRECollectionBean> getCollections() throws VREDefinitionException {
        ArrayList<VRECollectionBean> listToReturn = new ArrayList<VRECollectionBean>();
        return listToReturn;
    }

    private VREDescriptionBean getVREInSession() throws VREDefinitionException {
        VREGeneratorEvo vreGenerator = this.getVREGenerator();
        VREDescriptionBean vreDescBean = null;
        try {
            VREDescription sd = vreGenerator.getVREModel();
            vreDescBean = new VREDescriptionBean(sd.name(), sd.description(), sd.designer(), sd.manager(), sd.startTime().getTime(), sd.endTime().getTime());
        }
        catch (RemoteException e) {
            throw new VREDefinitionException("Fail retrieve VRE");
        }
        System.out.println("Model: " + vreDescBean.getName());
        System.out.println("--- END Getting VRE Model ---");
        return vreDescBean;
    }

    public String[] getExistingNames() {
        return null;
    }
}

