package org.gcube.portlets.admin.software_upload_wizard.server.rpc.handlers;

import java.util.UUID;

import net.customware.gwt.dispatch.server.ActionHandler;
import net.customware.gwt.dispatch.server.ExecutionContext;
import net.customware.gwt.dispatch.shared.ActionException;
import net.customware.gwt.dispatch.shared.DispatchException;

import org.gcube.portlets.admin.software_upload_wizard.server.importmanagers.ImportSessionManager;
import org.gcube.portlets.admin.software_upload_wizard.server.logging.InjectLogger;
import org.gcube.portlets.admin.software_upload_wizard.shared.rpc.RemoveMavenDependencies;
import org.gcube.portlets.admin.software_upload_wizard.shared.rpc.RemoveMavenDependenciesResult;
import org.slf4j.Logger;

import com.google.inject.Inject;

public class RemoveMavenDependenciesHandler implements
		ActionHandler<RemoveMavenDependencies, RemoveMavenDependenciesResult> {

	@InjectLogger
	Logger logger;

	ImportSessionManager importSessionManager;

	@Inject
	public RemoveMavenDependenciesHandler(
			ImportSessionManager importSessionManager) {
		super();
		this.importSessionManager = importSessionManager;
	}

	@Override
	public Class<RemoveMavenDependencies> getActionType() {
		return RemoveMavenDependencies.class;
	}

	@Override
	public RemoveMavenDependenciesResult execute(
			RemoveMavenDependencies action, ExecutionContext context)
			throws DispatchException {
		try {
			importSessionManager.getImportSession().getServiceProfile()
					.getService()
					.getPackage(UUID.fromString(action.getPackageId()))
					.getMavenDependencies().removeAll(action.getDependencies());
			return new RemoveMavenDependenciesResult();
		} catch (Exception e) {
			logger.error("Error encountered while removing maven dependency.",
					e);
			throw new ActionException(
					"Error encountered while removing maven dependency. Check server logs.");
		}
	}

	@Override
	public void rollback(RemoveMavenDependencies action,
			RemoveMavenDependenciesResult result, ExecutionContext context)
			throws DispatchException {
		// TODO Implement rollback for this method

	}

}
