package org.gcube.portlets.admin.software_upload_wizard.server.rpc.handlers;

import net.customware.gwt.dispatch.server.ActionHandler;
import net.customware.gwt.dispatch.server.ExecutionContext;
import net.customware.gwt.dispatch.shared.ActionException;
import net.customware.gwt.dispatch.shared.DispatchException;

import org.gcube.portlets.admin.software_upload_wizard.server.importmanagers.ImportSessionManager;
import org.gcube.portlets.admin.software_upload_wizard.server.logging.InjectLogger;
import org.gcube.portlets.admin.software_upload_wizard.shared.rpc.SetServiceData;
import org.gcube.portlets.admin.software_upload_wizard.shared.rpc.SetServiceDataResult;
import org.gcube.portlets.admin.software_upload_wizard.shared.softwareprofile.ServiceData;
import org.gcube.portlets.admin.software_upload_wizard.shared.softwaretypes.SoftwareTypeCode;
import org.slf4j.Logger;

import com.google.inject.Inject;

public class SetServiceDataHandler implements ActionHandler<SetServiceData, SetServiceDataResult> {
	
	@InjectLogger
	private Logger logger;
	
	private ImportSessionManager importSessionManager;

	@Inject
	public SetServiceDataHandler(ImportSessionManager importSessionManager) {
		super();
		this.importSessionManager = importSessionManager;
	}

	@Override
	public Class<SetServiceData> getActionType() {
		return SetServiceData.class;
	}

	@Override
	public SetServiceDataResult execute(SetServiceData action,
			ExecutionContext context) throws DispatchException {
		try {
			ServiceData data = action.getData();
			logger.trace("Setting service data");
			importSessionManager.getImportSession().getServiceProfile()
					.getService().setServiceData(data);
			
			//Set stub description for GCubeWebService case
			//TODO: handling the problem here is a bad solution, need to find another design, maybe using hooks or events
			if (importSessionManager.getImportSession().getSoftwareType().getCode()==SoftwareTypeCode.gCubeWebService){
				importSessionManager.getImportSession().getServiceProfile().getService().getPackages().get(1).getData().setDescription("Stubs for service " + data.getName());
			}
			
			
			return new SetServiceDataResult(data);
		} catch (Exception e) {
			logger.error("Error while executing " + this.getClass().getName() +":\n" + e.toString());
			throw new ActionException(e);
		}
	}

	@Override
	public void rollback(SetServiceData action, SetServiceDataResult result,
			ExecutionContext context) throws DispatchException {
		//TODO Implement rollback operations
	}

	

}
