/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resourcemanagement.support.shared.plugins;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.io.Serializable;
import java.util.List;
import java.util.Vector;

public class GenericResourcePlugin
implements Serializable,
IsSerializable {
    private static final long serialVersionUID = 6070331744211410508L;
    private String name = null;
    private String description = null;
    private String type = null;
    private List<Field> params = new Vector<Field>();
    private String namespace = "xmlns:ns4=\"http://gcube-system.org/namespaces/data/oaiplugin\"";

    public GenericResourcePlugin() {
    }

    public GenericResourcePlugin(String name, String namespace, String description, String type) {
        this.name = name;
        this.description = description;
        this.type = type;
        if (namespace != null && namespace.trim().length() > 0) {
            this.namespace = "xmlns:ns4=\"" + namespace.trim() + "\"";
        }
    }

    public final void addParam(Field param) {
        this.params.add(param);
    }

    public final String getName() {
        return this.name;
    }

    public final String getDescription() {
        return this.description;
    }

    public final String getType() {
        return this.type;
    }

    public final String getNamespace() {
        return this.namespace;
    }

    public final List<Field> getParams() {
        return this.params;
    }

    public static class Field
    implements Serializable,
    IsSerializable {
        private static final long serialVersionUID = 5921865866801474305L;
        private FieldType type = null;
        private String name = null;
        private boolean required = true;
        private String label = null;
        private String defaultValue = "";

        public Field() {
        }

        public Field(String name, FieldType type) {
            this(name, type, true);
        }

        public Field(String name, FieldType type, boolean required) {
            this(name, null, type, required);
        }

        public Field(String name, String label, FieldType type, boolean required) {
            this.setName(name);
            this.setLabel(label);
            this.type = type;
            this.setIsRequired(required);
        }

        public final String getDefaultValue() {
            return this.defaultValue;
        }

        public final void setDefaultValue(String defaultValue) {
            if (defaultValue != null && defaultValue.trim().length() > 0) {
                this.defaultValue = defaultValue;
            }
        }

        public final void setLabel(String label) {
            this.label = label != null && label.trim().length() > 0 ? label.trim() : this.name;
        }

        public final String getLabel() {
            if (this.label == null || this.label.trim().length() == 0) {
                return this.name;
            }
            return this.label;
        }

        private void setName(String name) {
            if (name != null) {
                this.name = name.trim();
            }
        }

        public final String getName() {
            return this.name;
        }

        public final FieldType getType() {
            return this.type;
        }

        public final void setType(FieldType type) {
            this.type = type;
        }

        public final boolean isRequired() {
            return this.required;
        }

        public final void setIsRequired(boolean required) {
            this.required = required;
        }
    }

    public static enum FieldType implements Serializable,
    IsSerializable
    {
        string,
        number,
        XML;

    }
}

