/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resourcemanagement.support.server.managers.scope;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.resourcemanagement.support.server.utils.ServerConsole;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ScopeManager {
    private static final Map<String, ScopeBean> SCOPES = new LinkedHashMap<String, ScopeBean>();
    private static String confFile = null;
    private static final String LOG_PREFIX = "[SCOPE-MGR]";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScopeBean getScope(String scope) throws Exception {
        Map<String, ScopeBean> map = SCOPES;
        synchronized (map) {
            if (ScopeManager.getAvailableScopes().containsKey(scope)) {
                return ScopeManager.getAvailableScopes().get(scope);
            }
        }
        ServerConsole.warn(LOG_PREFIX, "Using DEFAULT scope manager");
        return new ScopeBean(scope);
    }

    public static void setScopeConfigFile(String file) {
        confFile = file;
    }

    public static Map<String, ScopeBean> getAvailableScopes() throws Exception {
        if (SCOPES.size() == 0) {
            ScopeManager.update();
        }
        return SCOPES;
    }

    public static void clear() {
        SCOPES.clear();
    }

    public static void update() throws Exception {
        if (confFile == null) {
            throw new NullPointerException("the scope file has not been defined");
        }
        LinkedHashMap<String, ScopeBean> toCopy = ScopeManager.readScopes(confFile);
        for (String key : toCopy.keySet()) {
            SCOPES.put(key, toCopy.get(key));
        }
    }

    public static LinkedHashMap<String, ScopeBean> readScopes(String confFile) throws Exception {
        if (confFile == null) {
            throw new NullPointerException("the scope file has not been defined");
        }
        LinkedHashMap<String, ScopeBean> toReturn = new LinkedHashMap<String, ScopeBean>();
        String scopeXML = ScopeManager.fileToString(confFile);
        Document scopeDocument = ScopeManager.getDocumentGivenXML(scopeXML);
        NodeList voElements = scopeDocument.getElementsByTagName("vo");
        for (int i = 0; i < voElements.getLength(); ++i) {
            NodeList voDetails = voElements.item(i).getChildNodes();
            String voString = voDetails.item(5).getFirstChild().getNodeValue();
            ScopeBean vo = new ScopeBean(voString);
            toReturn.put(vo.toString(), vo);
            try {
                for (String vre : ScopeManager.getVREFromVO(vo)) {
                    toReturn.put(vre.toString(), new ScopeBean(vo.toString() + "/" + vre));
                }
                continue;
            }
            catch (Exception e) {
                ServerConsole.error("Exception raised while loading VREs for VO : " + vo, e);
            }
        }
        return toReturn;
    }

    protected static List<String> getVREFromVO(ScopeBean vo) throws Exception {
        ServerConsole.info(LOG_PREFIX, "Starting Retrieving VREs for VO : " + vo);
        ArrayList<String> toReturn = new ArrayList<String>();
        ScopeProvider.instance.set(vo.toString());
        XQuery query = ICFactory.queryFor(GenericResource.class);
        query.addCondition("$resource/Profile/SecondaryType/text() eq 'VRE'");
        DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
        List gRes = client.submit((Query)query);
        for (GenericResource res : gRes) {
            ServerConsole.info(LOG_PREFIX, "Found: " + res.profile().name());
            toReturn.add(res.profile().name());
        }
        return toReturn;
    }

    public static String getMapXML(ScopeBean searchvo) throws Exception {
        if (confFile == null) {
            throw new NullPointerException("the scope file has not been defined");
        }
        String scopeXML = ScopeManager.fileToString(confFile);
        ServerConsole.info(LOG_PREFIX, "Starting retrieving scopes..");
        Document scopeDocument = ScopeManager.getDocumentGivenXML(scopeXML);
        NodeList voElements = scopeDocument.getElementsByTagName("vo");
        for (int i = 0; i < voElements.getLength(); ++i) {
            NodeList voDetails = voElements.item(i).getChildNodes();
            String voString = voDetails.item(5).getFirstChild().getNodeValue();
            String fileName = voDetails.item(3).getFirstChild().getNodeValue();
            ScopeBean vo = new ScopeBean(voString);
            if (!vo.equals((Object)searchvo)) continue;
            return ScopeManager.fileToString(System.getenv("GLOBUS_LOCATION") + File.separator + "config" + File.separator + fileName);
        }
        ServerConsole.error(LOG_PREFIX, "*** maps for " + searchvo + " not found");
        return null;
    }

    public static String fileToString(String path) throws IOException {
        BufferedReader filebuf = null;
        String nextStr = null;
        StringBuilder ret = new StringBuilder();
        filebuf = new BufferedReader(new FileReader(path));
        nextStr = filebuf.readLine();
        while (nextStr != null) {
            ret.append(nextStr);
            nextStr = filebuf.readLine();
        }
        filebuf.close();
        return ret.toString();
    }

    public static Document getDocumentGivenXML(String result) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        Document document = null;
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            document = db.parse(new ByteArrayInputStream(result.getBytes()));
        }
        catch (ParserConfigurationException e1) {
            e1.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return document;
    }
}

