/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resourcemanagement.support.server.managers.resources;

import org.gcube.resourcemanagement.support.server.exceptions.ResourceOperationException;
import org.gcube.resourcemanagement.support.server.managers.resources.AbstractResourceManager;
import org.gcube.resourcemanagement.support.server.types.AllowedResourceTypes;
import org.gcube.resourcemanagement.support.server.utils.ServerConsole;

public class ResourceFactory {
    private static final String LOG_PREFIX = "[RES-MGR-FACTORY]";

    public static final AbstractResourceManager createResourceManager(AllowedResourceTypes type) throws ResourceOperationException {
        return ResourceFactory.createResourceManager(type, null);
    }

    public static final AbstractResourceManager createResourceManager(AllowedResourceTypes type, String id) throws ResourceOperationException {
        ServerConsole.info(LOG_PREFIX, "ResourceFactory building the " + type.name() + "Manager");
        String classToLoad = ResourceFactory.class.getPackage().getName() + "." + type.name() + "Manager";
        try {
            if (id == null) {
                return (AbstractResourceManager)Class.forName(classToLoad).newInstance();
            }
            return (AbstractResourceManager)Class.forName(classToLoad).getConstructor(String.class).newInstance(id);
        }
        catch (Exception e) {
            throw new ResourceOperationException(e);
        }
    }

    public static final void main(String[] args) throws Exception {
        for (AllowedResourceTypes res : AllowedResourceTypes.values()) {
            try {
                ServerConsole.info(LOG_PREFIX, "Loaded " + res.name() + " with ID: " + ResourceFactory.createResourceManager(res, "HelloID").getID());
            }
            catch (Exception e) {
                ServerConsole.error(LOG_PREFIX, "[ERR] Failed to load: " + res.name());
            }
        }
    }
}

