/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resourcemanagement.support.server.managers.resources;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.Software;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.resourcemanagement.support.server.exceptions.AbstractResourceException;
import org.gcube.resourcemanagement.support.server.exceptions.ResourceAccessException;
import org.gcube.resourcemanagement.support.server.exceptions.ResourceOperationException;
import org.gcube.resourcemanagement.support.server.exceptions.ResourceParameterException;
import org.gcube.resourcemanagement.support.server.managers.resources.AbstractResourceManager;
import org.gcube.resourcemanagement.support.server.managers.resources.ResourceFactory;
import org.gcube.resourcemanagement.support.server.types.AllowedResourceTypes;
import org.gcube.resourcemanagement.support.server.utils.Assertion;
import org.gcube.resourcemanagement.support.server.utils.ServerConsole;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.gcube.vremanagement.resourcemanager.client.RMBinderLibrary;
import org.gcube.vremanagement.resourcemanager.client.RMReportingLibrary;
import org.gcube.vremanagement.resourcemanager.client.fws.Types;

public class EServiceManager
extends AbstractResourceManager {
    private static final String LOG_PREFIX = "[RI-MGR]";

    public EServiceManager() throws ResourceParameterException, ResourceAccessException {
        super(AllowedResourceTypes.Eservice);
    }

    public EServiceManager(String id) throws ResourceParameterException, ResourceAccessException {
        super(id, AllowedResourceTypes.Eservice);
    }

    public EServiceManager(String id, String name) throws ResourceParameterException, ResourceAccessException {
        super(id, name, AllowedResourceTypes.Eservice);
    }

    public EServiceManager(String id, String name, String subType) throws ResourceParameterException, ResourceAccessException {
        super(id, name, AllowedResourceTypes.Eservice, subType);
    }

    public final String deploy(ScopeBean scope, String[] ghnsID, String[] servicesID) throws ResourceParameterException, ResourceOperationException {
        Assertion<ResourceParameterException> checker = new Assertion<ResourceParameterException>();
        checker.validate(servicesID != null && servicesID.length != 0, new ResourceParameterException("Invalid servicesID parameter. It cannot be null or empty."));
        checker.validate(scope != null, new ResourceParameterException("Cannot retrieve the scope."));
        ArrayList<Types.PackageItem> serviceProfiles = new ArrayList<Types.PackageItem>();
        try {
            XQuery query = null;
            DiscoveryClient client = ICFactory.clientFor(Software.class);
            for (String serviceID : servicesID) {
                query = ICFactory.queryFor(Software.class);
                query.addCondition("$resource/Profile/ID/text() eq '" + serviceID + "'");
                System.out.println("**** Query : " + query.toString());
                String curr = ScopeProvider.instance.get();
                ScopeProvider.instance.set(scope.toString());
                List results = client.submit((Query)query);
                ScopeProvider.instance.set(curr);
                System.out.println("**** results received : " + results.size());
                Software ret = null;
                if (results == null || results.size() <= 0) continue;
                ret = (Software)results.get(0);
                if (ret == null || ret.profile() == null || ret.profile().softwareClass() == null || ret.profile().softwareName() == null) {
                    ServerConsole.error(LOG_PREFIX, "found an invalid service profile");
                    continue;
                }
                Types.PackageItem toAdd = new Types.PackageItem();
                toAdd.serviceClass = ret.profile().softwareClass();
                toAdd.serviceName = ret.profile().softwareName();
                toAdd.serviceVersion = "1.0.0";
                if (ret.profile().packages().size() == 1) {
                    toAdd.packageName = ((Software.Profile.SoftwarePackage)ret.profile().packages().iterator().next()).name();
                    toAdd.packageVersion = ((Software.Profile.SoftwarePackage)ret.profile().packages().iterator().next()).version();
                } else {
                    for (Software.Profile.SoftwarePackage p : ret.profile().packages()) {
                        if (!p.getClass().isAssignableFrom(Software.Profile.ServicePackage.class)) continue;
                        toAdd.packageName = p.name();
                        toAdd.packageVersion = p.version();
                        break;
                    }
                }
                serviceProfiles.add(toAdd);
            }
            Types.SoftwareList serviceList = new Types.SoftwareList();
            ArrayList<String> arrayGHNSids = new ArrayList<String>();
            for (int i = 0; i < ghnsID.length; ++i) {
                arrayGHNSids.add(ghnsID[i]);
            }
            serviceList.suggestedTargetGHNNames = arrayGHNSids;
            serviceList.software = serviceProfiles;
            Types.AddResourcesParameters addResourcesParameters = new Types.AddResourcesParameters();
            addResourcesParameters.softwareList = serviceList;
            addResourcesParameters.setTargetScope(scope.toString());
            System.out.println("\n\n**** These is the ServiceList i pass to ResourceManagerPortType: ");
            for (int i = 0; i < serviceList.software.size(); ++i) {
                System.out.println(serviceList.software.get(i));
            }
            String id = "";
            RMBinderLibrary manager = ResourceFactory.createResourceManager(AllowedResourceTypes.Service).getResourceManager(scope.toString());
            String curr = ScopeProvider.instance.get();
            ScopeProvider.instance.set(scope.toString());
            id = manager.addResources(addResourcesParameters);
            ScopeProvider.instance.set(curr);
            return id;
        }
        catch (Exception e) {
            ServerConsole.error(LOG_PREFIX, "Error during deployment.", e);
            throw new ResourceOperationException("Software deployment failure: " + e.getMessage());
        }
    }

    public final String undeploy(ScopeBean scope) throws AbstractResourceException {
        Assertion<AbstractResourceException> checker = new Assertion<AbstractResourceException>();
        checker.validate(scope != null, new ResourceParameterException("Cannot retrieve the scope."));
        checker.validate(this.getID() != null, new ResourceOperationException("Invalid ID."));
        try {
            RMBinderLibrary rm = ResourceFactory.createResourceManager(AllowedResourceTypes.Service).getResourceManager(scope.toString());
            Types.RemoveResourcesParameters params = new Types.RemoveResourcesParameters();
            Types.ResourceItem[] resourcelist = new Types.ResourceItem[]{new Types.ResourceItem()};
            resourcelist[0].id = this.getID();
            resourcelist[0].type = this.getType().name();
            Types.ResourceList r = new Types.ResourceList();
            ArrayList<Types.ResourceItem> temp = new ArrayList<Types.ResourceItem>();
            temp.add(resourcelist[0]);
            r.setResource(temp);
            params.resources = r;
            params.targetScope = scope.toString();
            ServerConsole.info(LOG_PREFIX, "Sending the Remove Resource request....");
            String reportID = rm.removeResources(params);
            ServerConsole.info(LOG_PREFIX, "Returned report ID: " + reportID);
            return reportID;
        }
        catch (Exception e) {
            ServerConsole.error(LOG_PREFIX, "Error during deployment.", e);
            throw new ResourceOperationException("Software deployment failure: " + e.getMessage());
        }
    }

    public final String checkDeployStatus(ScopeBean scope, String deployID) throws AbstractResourceException {
        Assertion<ResourceParameterException> checker = new Assertion<ResourceParameterException>();
        checker.validate(scope != null, new ResourceParameterException("Invalid scope passed"));
        checker.validate(deployID != null && deployID.trim().length() > 0, new ResourceParameterException("Invalid reportID passed"));
        RMReportingLibrary vreManagerPortType = this.getReportResourceManager(scope.toString());
        try {
            return vreManagerPortType.getReport(deployID);
        }
        catch (Exception e) {
            ServerConsole.error(LOG_PREFIX, e);
            throw new ResourceOperationException("Cannot retrieve the report: " + deployID + " " + e.getMessage());
        }
    }

    @Override
    protected final Resource buildResource(String xmlRepresentation) throws AbstractResourceException {
        try {
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{GCoreEndpoint.class});
            Unmarshaller unmarshaller = ctx.createUnmarshaller();
            StringReader reader = new StringReader(xmlRepresentation);
            GCoreEndpoint deserialised = (GCoreEndpoint)unmarshaller.unmarshal((Reader)reader);
            return deserialised;
        }
        catch (Exception e) {
            throw new ResourceAccessException("Cannot load the stub for resource " + (Object)((Object)this.getType()), e);
        }
    }
}

